/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, ui).hasHighlightingOrInProgress();
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogDataProvider dataProvider = (VcsLogDataProvider)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || ui == null || dataProvider == null) {
            return;
        }
        DeepComparator dc = DeepComparator.getInstance(project, ui);
        if (selected) {
            String singleBranchName;
            VcsLogUtil.triggerUsage((AnActionEvent)e);
            VcsLogBranchFilter branchFilter = ui.getFilterUi().getFilters().getBranchFilter();
            String string = singleBranchName = branchFilter != null ? VcsLogUtil.getSingleFilteredBranch((VcsLogBranchFilter)branchFilter, (VcsLogRefs)ui.getDataPack().getRefs()) : null;
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction(ui.getDataPack(), e, (Consumer<String>)((Consumer)selectedBranch -> {
                    ui.getFilterUi().setFilter((VcsLogFilter)VcsLogBranchFilterImpl.fromBranch((String)selectedBranch));
                    dc.highlightInBackground((String)selectedBranch, dataProvider);
                }), DeepCompareAction.getAllVisibleRoots(ui));
                return;
            }
            dc.highlightInBackground(singleBranchName, dataProvider);
        } else {
            dc.stopAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogDataPack dataPack, @NotNull AnActionEvent event, final @NotNull Consumer<String> consumer, @NotNull Collection<VirtualFile> visibleRoots) {
        if (dataPack == null) {
            DeepCompareAction.$$$reportNull$$$0(0);
        }
        if (event == null) {
            DeepCompareAction.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            DeepCompareAction.$$$reportNull$$$0(2);
        }
        if (visibleRoots == null) {
            DeepCompareAction.$$$reportNull$$$0(3);
        }
        ActionGroup actionGroup = new BranchPopupBuilder(dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                DumbAwareAction dumbAwareAction = new DumbAwareAction(name){

                    public void actionPerformed(AnActionEvent e) {
                        consumer.consume((Object)name);
                    }
                };
                if (dumbAwareAction == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dumbAwareAction;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/branch/DeepCompareAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/branch/DeepCompareAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAction";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.build();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select branch to compare", actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup.showInBestPositionFor(event.getDataContext());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeepCompareAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && ui != null && DeepCompareAction.hasGitRoots(project, DeepCompareAction.getAllVisibleRoots(ui)));
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            DeepCompareAction.$$$reportNull$$$0(6);
        }
        GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
        return ContainerUtil.exists(roots, root -> manager.getRepositoryForRootQuick((VirtualFile)root) != null);
    }

    @NotNull
    private static Set<VirtualFile> getAllVisibleRoots(@NotNull VcsLogUi ui) {
        if (ui == null) {
            DeepCompareAction.$$$reportNull$$$0(7);
        }
        Set set = VcsLogUtil.getAllVisibleRoots(ui.getDataPack().getLogProviders().keySet(), (VcsLogRootFilter)ui.getFilterUi().getFilters().getRootFilter(), (VcsLogStructureFilter)ui.getFilterUi().getFilters().getStructureFilter());
        if (set == null) {
            DeepCompareAction.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/DeepCompareAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/DeepCompareAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVisibleRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectBranchAndPerformAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

