/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLineStartEndHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;
    private final boolean myIsHomeHandler;
    private final boolean myWithSelection;

    public TemplateLineStartEndHandler(EditorActionHandler originalHandler, boolean isHomeHandler, boolean withSelection) {
        super(true);
        this.myOriginalHandler = originalHandler;
        this.myIsHomeHandler = isHomeHandler;
        this.myWithSelection = withSelection;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        TemplateState templateState;
        if (editor == null) {
            TemplateLineStartEndHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            TemplateLineStartEndHandler.$$$reportNull$$$0(1);
        }
        if ((templateState = TemplateManagerImpl.getTemplateState(editor)) != null && !templateState.isFinished()) {
            TextRange range = templateState.getCurrentVariableRange();
            int caretOffset = editor.getCaretModel().getOffset();
            if (range != null && range.containsOffset(caretOffset)) {
                return true;
            }
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        TemplateState templateState;
        if (editor == null) {
            TemplateLineStartEndHandler.$$$reportNull$$$0(2);
        }
        if ((templateState = TemplateManagerImpl.getTemplateState(editor)) != null && !templateState.isFinished()) {
            TextRange range = templateState.getCurrentVariableRange();
            int caretOffset = editor.getCaretModel().getOffset();
            if (range != null && this.shouldStayInsideVariable(range, caretOffset)) {
                int selectionOffset = editor.getSelectionModel().getLeadSelectionOffset();
                int offsetToMove = this.myIsHomeHandler ? range.getStartOffset() : range.getEndOffset();
                LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offsetToMove).leanForward(this.myIsHomeHandler);
                editor.getCaretModel().moveToLogicalPosition(logicalPosition);
                EditorModificationUtil.scrollToCaret((Editor)editor);
                if (this.myWithSelection) {
                    editor.getSelectionModel().setSelection(selectionOffset, offsetToMove);
                } else {
                    editor.getSelectionModel().removeSelection();
                }
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    private boolean shouldStayInsideVariable(TextRange varRange, int caretOffset) {
        return varRange.containsOffset(caretOffset) && caretOffset != (this.myIsHomeHandler ? varRange.getStartOffset() : varRange.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/editorActions/TemplateLineStartEndHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

