/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentFactory;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.FormattingModelFactory;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentFactory;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingFactory;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapFactory;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterImpl
extends FormatterEx
implements IndentFactory,
WrapFactory,
AlignmentFactory,
SpacingFactory,
FormattingModelFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatterImpl");
    private final AtomicReference<FormattingProgressTask> myProgressTask = new AtomicReference();
    private final AtomicInteger myIsDisabledCount = new AtomicInteger();
    private final IndentImpl NONE_INDENT = new IndentImpl(Indent.Type.NONE, false, false);
    private final IndentImpl myAbsoluteNoneIndent = new IndentImpl(Indent.Type.NONE, true, false);
    private final IndentImpl myLabelIndent = new IndentImpl(Indent.Type.LABEL, false, false);
    private final IndentImpl myContinuationIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, true);
    private final IndentImpl myContinuationIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, false);
    private final IndentImpl myContinuationWithoutFirstIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, true);
    private final IndentImpl myContinuationWithoutFirstIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, false);
    private final IndentImpl myAbsoluteLabelIndent = new IndentImpl(Indent.Type.LABEL, true, false);
    private final IndentImpl myNormalIndentRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, true);
    private final IndentImpl myNormalIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, false);
    private final SpacingImpl myReadOnlySpacing = new SpacingImpl(0, 0, 0, true, false, true, 0, false, 0);
    private final Map<SpacingImpl, SpacingImpl> ourSharedProperties = new HashMap<SpacingImpl, SpacingImpl>();
    private final SpacingImpl ourSharedSpacing = new SpacingImpl(-1, -1, -1, false, false, false, -1, false, 0);

    public FormatterImpl() {
        Indent.setFactory((IndentFactory)this);
        Wrap.setFactory((WrapFactory)this);
        Alignment.setFactory((AlignmentFactory)this);
        Spacing.setFactory((SpacingFactory)this);
        FormattingModelProvider.setFactory((FormattingModelFactory)this);
    }

    public Alignment createAlignment(boolean applyToNonFirstBlocksOnLine, @NotNull Alignment.Anchor anchor) {
        if (anchor == null) {
            FormatterImpl.$$$reportNull$$$0(0);
        }
        return new AlignmentImpl(applyToNonFirstBlocksOnLine, anchor);
    }

    public Alignment createChildAlignment(Alignment base) {
        AlignmentImpl result2 = new AlignmentImpl();
        result2.setParent(base);
        return result2;
    }

    public Indent getNormalIndent(boolean relative) {
        return relative ? this.myNormalIndentRelativeToDirectParent : this.myNormalIndentNotRelativeToDirectParent;
    }

    public Indent getNoneIndent() {
        return this.NONE_INDENT;
    }

    @Override
    public void setProgressTask(@NotNull FormattingProgressTask progressIndicator) {
        if (progressIndicator == null) {
            FormatterImpl.$$$reportNull$$$0(1);
        }
        if (!FormatterUtil.isFormatterCalledExplicitly()) {
            return;
        }
        this.myProgressTask.set(progressIndicator);
    }

    @Override
    public int getSpacingForBlockAtOffset(FormattingModel model, int offset) {
        int minSpaces;
        SpacingImpl spacing = FormatterImpl.getSpacingBeforeBlockAtOffset(model, offset);
        if (spacing != null && (minSpaces = spacing.getMinSpaces()) >= 0) {
            return minSpaces;
        }
        return -1;
    }

    @Override
    public int getMinLineFeedsBeforeBlockAtOffset(FormattingModel model, int offset) {
        int minLineFeeds;
        SpacingImpl spacing = FormatterImpl.getSpacingBeforeBlockAtOffset(model, offset);
        if (spacing != null && (minLineFeeds = spacing.getMinLineFeeds()) >= 0) {
            return minLineFeeds;
        }
        return -1;
    }

    private static SpacingImpl getSpacingBeforeBlockAtOffset(FormattingModel model, int offset) {
        Couple<Block> blockWithParent = FormatterImpl.getBlockAtOffset(null, model.getRootBlock(), offset);
        if (blockWithParent != null) {
            Block prevBlock;
            Block parentBlock = (Block)blockWithParent.first;
            Block targetBlock = (Block)blockWithParent.second;
            if (parentBlock != null && targetBlock != null && (prevBlock = FormatterImpl.findPreviousSibling(parentBlock, targetBlock)) != null) {
                return (SpacingImpl)parentBlock.getSpacing(prevBlock, targetBlock);
            }
        }
        return null;
    }

    @Nullable
    private static Couple<Block> getBlockAtOffset(@Nullable Block parent, @NotNull Block block, int offset) {
        if (block == null) {
            FormatterImpl.$$$reportNull$$$0(2);
        }
        TextRange textRange = block.getTextRange();
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        if (startOffset == offset) {
            return Couple.of((Object)parent, (Object)block);
        }
        if (startOffset > offset || endOffset < offset || block.isLeaf()) {
            return null;
        }
        for (Block subBlock : block.getSubBlocks()) {
            Couple<Block> result2 = FormatterImpl.getBlockAtOffset(block, subBlock, offset);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static Block findPreviousSibling(@NotNull Block parent, Block block) {
        if (parent == null) {
            FormatterImpl.$$$reportNull$$$0(3);
        }
        Block result2 = null;
        for (Block subBlock : parent.getSubBlocks()) {
            if (subBlock == block) {
                return result2;
            }
            result2 = subBlock;
        }
        return null;
    }

    @Override
    public void format(final FormattingModel model, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, CommonCodeStyleSettings.IndentOptions javaIndentOptions, final FormatTextRanges affectedRanges) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            MyFormattingTask task2 = new MyFormattingTask(){

                @Override
                @NotNull
                protected FormatProcessor buildProcessor() {
                    FormatProcessor processor2 = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, affectedRanges, FormattingProgressCallback.EMPTY);
                    processor2.format(model);
                    FormatProcessor formatProcessor = processor2;
                    if (formatProcessor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return formatProcessor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$1", "buildProcessor"));
                }
            };
            this.execute(task2);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public Wrap createWrap(WrapType type, boolean wrapFirstElement) {
        return new WrapImpl(type, wrapFirstElement);
    }

    public Wrap createChildWrap(Wrap parentWrap, WrapType wrapType, boolean wrapFirstElement) {
        WrapImpl result2 = new WrapImpl(wrapType, wrapFirstElement);
        result2.registerParent((WrapImpl)parentWrap);
        return result2;
    }

    @NotNull
    public Spacing createSpacing(int minOffset, int maxOffset, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minOffset, maxOffset, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(4);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing getReadOnlySpacing() {
        SpacingImpl spacingImpl = this.myReadOnlySpacing;
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(5);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependencyRange, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRange == null) {
            FormatterImpl.$$$reportNull$$$0(6);
        }
        if (rule == null) {
            FormatterImpl.$$$reportNull$$$0(7);
        }
        DependantSpacingImpl dependantSpacingImpl = new DependantSpacingImpl(minSpaces, maxSpaces, dependencyRange, keepLineBreaks, keepBlankLines, rule);
        if (dependantSpacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(8);
        }
        return dependantSpacingImpl;
    }

    @NotNull
    public Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependentRegion, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependentRegion == null) {
            FormatterImpl.$$$reportNull$$$0(9);
        }
        if (rule == null) {
            FormatterImpl.$$$reportNull$$$0(10);
        }
        DependantSpacingImpl dependantSpacingImpl = new DependantSpacingImpl(minSpaces, maxSpaces, dependentRegion, keepLineBreaks, keepBlankLines, rule);
        if (dependantSpacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(11);
        }
        return dependantSpacingImpl;
    }

    @NotNull
    private FormattingProgressCallback getProgressCallback() {
        FormattingProgressCallback result2 = this.myProgressTask.get();
        FormattingProgressCallback formattingProgressCallback = result2 == null ? FormattingProgressCallback.EMPTY : result2;
        if (formattingProgressCallback == null) {
            FormatterImpl.$$$reportNull$$$0(12);
        }
        return formattingProgressCallback;
    }

    @Override
    public void format(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, FormatTextRanges affectedRanges) throws IncorrectOperationException {
        this.format(model, settings, indentOptions, affectedRanges, false);
    }

    @Override
    public void format(final FormattingModel model, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final FormatTextRanges affectedRanges, final boolean formatContextAroundRanges) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            MyFormattingTask task2 = new MyFormattingTask(){

                @Override
                @NotNull
                protected FormatProcessor buildProcessor() {
                    FormatProcessor.FormatOptions options = new FormatProcessor.FormatOptions(settings, indentOptions, affectedRanges, formatContextAroundRanges);
                    FormatProcessor processor2 = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), options, FormatterImpl.this.getProgressCallback());
                    processor2.format(model, true);
                    FormatProcessor formatProcessor = processor2;
                    if (formatProcessor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return formatProcessor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$2", "buildProcessor"));
                }
            };
            this.execute(task2);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public void formatWithoutModifications(final FormattingDocumentModel model, final Block rootBlock, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final TextRange affectedRange) throws IncorrectOperationException {
        MyFormattingTask task2 = new MyFormattingTask(){

            @Override
            @NotNull
            protected FormatProcessor buildProcessor() {
                FormatProcessor result2 = new FormatProcessor(model, rootBlock, settings, indentOptions, new FormatTextRanges(affectedRange, true), FormattingProgressCallback.EMPTY);
                result2.formatWithoutRealModifications();
                FormatProcessor formatProcessor = result2;
                if (formatProcessor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return formatProcessor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$3", "buildProcessor"));
            }
        };
        this.execute(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(@NotNull SequentialTask task2) {
        if (task2 == null) {
            FormatterImpl.$$$reportNull$$$0(13);
        }
        this.disableFormatting();
        Application application = ApplicationManager.getApplication();
        FormattingProgressTask progressTask = this.myProgressTask.getAndSet(null);
        if (progressTask == null || !application.isDispatchThread() || application.isUnitTestMode()) {
            try {
                task2.prepare();
                while (!task2.isDone()) {
                    task2.iteration();
                }
            }
            finally {
                this.enableFormatting();
            }
        } else {
            progressTask.setTask(task2);
            Runnable callback = () -> this.enableFormatting();
            for (FormattingProgressCallback.EventType eventType : FormattingProgressCallback.EventType.values()) {
                progressTask.addCallback(eventType, callback);
            }
            ProgressManager.getInstance().run((Task)progressTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndentInfo getWhiteSpaceBefore(FormattingDocumentModel model, Block block, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean mayChangeLineFeeds) {
        this.disableFormatting();
        try {
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(model, block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
            LeafBlockWrapper blockBefore = processor2.getBlockRangesMap().getBlockAtOrAfter(affectedRange.getStartOffset());
            LOG.assertTrue(blockBefore != null);
            WhiteSpace whiteSpace = blockBefore.getWhiteSpace();
            LOG.assertTrue(whiteSpace != null);
            if (!mayChangeLineFeeds) {
                whiteSpace.setLineFeedsAreReadOnly();
            }
            processor2.setAllWhiteSpacesAreReadOnly();
            whiteSpace.setReadOnly(false);
            processor2.formatWithoutRealModifications();
            IndentInfo indentInfo = new IndentInfo(whiteSpace.getLineFeeds(), whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
            return indentInfo;
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustLineIndentsForRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange rangeToAdjust) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, indentOptions, new FormatTextRanges(rangeToAdjust, true));
            for (LeafBlockWrapper tokenBlock = processor2.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                whiteSpace.setLineFeedsAreReadOnly(true);
                if (whiteSpace.containsLineFeeds()) continue;
                whiteSpace.setIsReadOnly(true);
            }
            processor2.formatWithoutRealModifications();
            processor2.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatAroundRange(FormattingModel model, CodeStyleSettings settings, PsiFile file2, TextRange textRange) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, settings.getIndentOptionsByFile(file2), null);
            for (LeafBlockWrapper tokenBlock = processor2.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                if (whiteSpace.getEndOffset() < textRange.getStartOffset() || whiteSpace.getEndOffset() > textRange.getEndOffset() + 1) {
                    whiteSpace.setIsReadOnly(true);
                    continue;
                }
                if (whiteSpace.getStartOffset() <= textRange.getStartOffset() || whiteSpace.getEndOffset() >= textRange.getEndOffset()) continue;
                if (whiteSpace.containsLineFeeds()) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                    continue;
                }
                whiteSpace.setIsReadOnly(true);
            }
            processor2.formatWithoutRealModifications();
            processor2.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) throws IncorrectOperationException {
        this.disableFormatting();
        try {
            Block block;
            FormattingDocumentModel documentModel;
            FormatProcessor processor2;
            LeafBlockWrapper blockAfterOffset;
            FormatterImpl.validateModel(model);
            if (model instanceof PsiBasedFormattingModel) {
                ((PsiBasedFormattingModel)model).canModifyAllWhiteSpaces();
            }
            if ((blockAfterOffset = (processor2 = FormatterImpl.buildProcessorAndWrapBlocks(documentModel = model.getDocumentModel(), block = model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true), offset)).getBlockRangesMap().getBlockAtOrAfter(offset)) != null && blockAfterOffset.contains(offset)) {
                int n = offset;
                return n;
            }
            WhiteSpace whiteSpace = blockAfterOffset != null ? blockAfterOffset.getWhiteSpace() : processor2.getLastWhiteSpace();
            int n = FormatterImpl.adjustLineIndent(offset, documentModel, processor2, indentOptions, model, whiteSpace, blockAfterOffset != null ? blockAfterOffset.getNode() : null);
            return n;
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
        return offset;
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges) {
        return FormatterImpl.buildProcessorAndWrapBlocks(docModel, rootBlock, settings, indentOptions, affectedRanges, -1);
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, int interestingOffset) {
        FormatProcessor.FormatOptions options = new FormatProcessor.FormatOptions(settings, indentOptions, affectedRanges, false, interestingOffset);
        FormatProcessor processor2 = new FormatProcessor(docModel, rootBlock, options, FormattingProgressCallback.EMPTY);
        while (!processor2.iteration()) {
        }
        return processor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int adjustLineIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor2, CommonCodeStyleSettings.IndentOptions indentOptions, FormattingModel model, WhiteSpace whiteSpace, ASTNode nodeAfter) {
        IndentInfo indent;
        boolean wsContainsCaret = whiteSpace.getStartOffset() <= offset && offset < whiteSpace.getEndOffset();
        int lineStartOffset = FormatterImpl.getLineStartOffset(offset, whiteSpace, documentModel);
        String newWS = whiteSpace.generateWhiteSpace(indentOptions, lineStartOffset, indent = FormatterImpl.calcIndent(offset, documentModel, processor2, whiteSpace)).toString();
        if (!whiteSpace.equalsToString(newWS)) {
            try {
                if (model instanceof FormattingModelEx) {
                    ((FormattingModelEx)model).replaceWhiteSpace(whiteSpace.getTextRange(), nodeAfter, newWS);
                } else {
                    model.replaceWhiteSpace(whiteSpace.getTextRange(), newWS);
                }
            }
            finally {
                model.commitChanges();
            }
        }
        int defaultOffset = offset - whiteSpace.getLength() + newWS.length();
        if (wsContainsCaret) {
            int ws = whiteSpace.getStartOffset() + CharArrayUtil.shiftForward((CharSequence)newWS, (int)Math.max(0, lineStartOffset - whiteSpace.getStartOffset()), (String)" \t");
            return Math.max(defaultOffset, ws);
        }
        return defaultOffset;
    }

    private static boolean hasContentAfterLineBreak(FormattingDocumentModel documentModel, int offset, WhiteSpace whiteSpace) {
        return documentModel.getLineNumber(offset) == documentModel.getLineNumber(whiteSpace.getEndOffset()) && documentModel.getTextLength() != whiteSpace.getEndOffset();
    }

    @Override
    public String getLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Block block = model.getRootBlock();
        if (block.getTextRange().isEmpty()) {
            return null;
        }
        FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, indentOptions, new FormatTextRanges(affectedRange, true), offset);
        WhiteSpace whiteSpace = FormatterImpl.getWhiteSpaceAtOffset(offset, processor2);
        if (whiteSpace != null) {
            IndentInfo indent = FormatterImpl.calcIndent(offset, documentModel, processor2, whiteSpace);
            return indent.generateNewWhiteSpace(indentOptions);
        }
        return null;
    }

    @Nullable
    private static WhiteSpace getWhiteSpaceAtOffset(int offset, @NotNull FormatProcessor formatProcessor) {
        LeafBlockWrapper blockAfterOffset;
        if (formatProcessor == null) {
            FormatterImpl.$$$reportNull$$$0(14);
        }
        if ((blockAfterOffset = formatProcessor.getBlockRangesMap().getBlockAtOrAfter(offset)) != null) {
            if (!blockAfterOffset.contains(offset)) {
                return blockAfterOffset.getWhiteSpace();
            }
        } else if (offset >= formatProcessor.getLastWhiteSpace().getStartOffset()) {
            return formatProcessor.getLastWhiteSpace();
        }
        return null;
    }

    private static IndentInfo calcIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor2, WhiteSpace whiteSpace) {
        IndentInfo indent;
        processor2.setAllWhiteSpacesAreReadOnly();
        whiteSpace.setLineFeedsAreReadOnly(true);
        if (FormatterImpl.hasContentAfterLineBreak(documentModel, offset, whiteSpace)) {
            whiteSpace.setReadOnly(false);
            processor2.formatWithoutRealModifications();
            indent = new IndentInfo(0, whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
        } else {
            indent = processor2.getIndentAt(offset);
        }
        return indent;
    }

    public static String getText(FormattingDocumentModel documentModel) {
        return FormatterImpl.getCharSequence(documentModel).toString();
    }

    private static CharSequence getCharSequence(FormattingDocumentModel documentModel) {
        return documentModel.getText(new TextRange(0, documentModel.getTextLength()));
    }

    private static int getLineStartOffset(int offset, WhiteSpace whiteSpace, FormattingDocumentModel documentModel) {
        int lineStartOffset = offset;
        CharSequence text = FormatterImpl.getCharSequence(documentModel);
        lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)lineStartOffset, (String)" \t\n");
        if (lineStartOffset > whiteSpace.getStartOffset()) {
            int prevEnd;
            if (lineStartOffset >= text.length()) {
                lineStartOffset = text.length() - 1;
            }
            int wsStart = whiteSpace.getStartOffset();
            if (text.charAt(lineStartOffset) == '\n' && wsStart <= (prevEnd = documentModel.getLineStartOffset(documentModel.getLineNumber(lineStartOffset - 1))) && documentModel.getText(new TextRange(prevEnd, lineStartOffset)).toString().trim().length() == 0) {
                --lineStartOffset;
            }
            if ((lineStartOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)lineStartOffset, (String)"\t ")) < 0) {
                lineStartOffset = 0;
            }
            if (lineStartOffset != offset && text.charAt(lineStartOffset) == '\n') {
                ++lineStartOffset;
            }
        }
        return lineStartOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean keepBlankLines, boolean keepLineBreaks, boolean changeWSBeforeFirstElement, boolean changeLineFeedsBeforeFirstElement, @Nullable FormatterEx.IndentInfoStorage indentInfoStorage) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor2.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                SpacingImpl spaceProperty;
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    if (whiteSpace.containsLineFeeds() && indentInfoStorage != null) {
                        whiteSpace.setLineFeedsAreReadOnly(true);
                        current.setIndentFromParent(indentInfoStorage.getIndentInfo(current.getStartOffset()));
                        continue;
                    }
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeWSBeforeFirstElement) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeLineFeedsBeforeFirstElement) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                }
                if ((spaceProperty = current.getSpaceProperty()) == null) continue;
                boolean needChange = false;
                int newKeepLineBreaks = spaceProperty.getKeepBlankLines();
                boolean newKeepLineBreaksFlag = spaceProperty.shouldKeepLineFeeds();
                if (!keepLineBreaks) {
                    needChange = true;
                    newKeepLineBreaksFlag = false;
                }
                if (!keepBlankLines) {
                    needChange = true;
                    newKeepLineBreaks = 0;
                }
                if (!needChange) continue;
                assert (!(spaceProperty instanceof DependantSpacingImpl));
                current.setSpaceProperty(this.getSpacingImpl(spaceProperty.getMinSpaces(), spaceProperty.getMaxSpaces(), spaceProperty.getMinLineFeeds(), spaceProperty.isReadOnly(), spaceProperty.isSafe(), newKeepLineBreaksFlag, newKeepLineBreaks, false, spaceProperty.getPrefLineFeeds()));
            }
            processor2.format(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor2.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                whiteSpace.setReadOnly(false);
            }
            processor2.format(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    @Override
    public void saveIndents(FormattingModel model, TextRange affectedRange, FormatterEx.IndentInfoStorage storage2, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions) {
        try {
            FormatterImpl.validateModel(model);
            Block block = model.getRootBlock();
            FormatProcessor processor2 = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor2.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly() || !whiteSpace.containsLineFeeds()) continue;
                storage2.saveIndentInfo(current.calcIndentFromParent(), current.getStartOffset());
            }
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public FormattingModel createFormattingModelForPsiFile(PsiFile file2, @NotNull Block rootBlock, CodeStyleSettings settings) {
        if (rootBlock == null) {
            FormatterImpl.$$$reportNull$$$0(15);
        }
        return new PsiBasedFormattingModel(file2, rootBlock, FormattingDocumentModelImpl.createOn(file2));
    }

    public Indent getSpaceIndent(int spaces, boolean relative) {
        return this.getIndent(Indent.Type.SPACES, spaces, relative, false);
    }

    public Indent getIndent(@NotNull Indent.Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(16);
        }
        return this.getIndent(type, 0, relativeToDirectParent, enforceIndentToChildren);
    }

    public Indent getSmartIndent(@NotNull Indent.Type type) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(17);
        }
        return new ExpandableIndent(type);
    }

    public Indent getIndent(@NotNull Indent.Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(18);
        }
        return new IndentImpl(type, false, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    public Indent getAbsoluteLabelIndent() {
        return this.myAbsoluteLabelIndent;
    }

    @NotNull
    public Spacing createSafeSpacing(boolean shouldKeepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(0, 0, 0, false, true, shouldKeepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(19);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createKeepingFirstColumnSpacing(int minSpace, int maxSpace, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpace, maxSpace, -1, false, false, keepLineBreaks, keepBlankLines, true, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(20);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpaces, maxSpaces, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, prefLineFeeds);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(21);
        }
        return spacingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpacingImpl getSpacingImpl(int minSpaces, int maxSpaces, int minLineFeeds, boolean readOnly, boolean safe, boolean keepLineBreaksFlag, int keepLineBreaks, boolean keepFirstColumn, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.ourSharedSpacing;
        synchronized (spacingImpl) {
            this.ourSharedSpacing.init(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
            SpacingImpl spacing = this.ourSharedProperties.get((Object)this.ourSharedSpacing);
            if (spacing == null) {
                spacing = new SpacingImpl(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
                this.ourSharedProperties.put(spacing, spacing);
            }
            return spacing;
        }
    }

    public Indent getAbsoluteNoneIndent() {
        return this.myAbsoluteNoneIndent;
    }

    public Indent getLabelIndent() {
        return this.myLabelIndent;
    }

    public Indent getContinuationIndent(boolean relative) {
        return relative ? this.myContinuationIndentRelativeToDirectParent : this.myContinuationIndentNotRelativeToDirectParent;
    }

    public Indent getContinuationWithoutFirstIndent(boolean relative) {
        return relative ? this.myContinuationWithoutFirstIndentRelativeToDirectParent : this.myContinuationWithoutFirstIndentNotRelativeToDirectParent;
    }

    @Override
    public boolean isDisabled() {
        return this.myIsDisabledCount.get() > 0;
    }

    private void disableFormatting() {
        this.myIsDisabledCount.incrementAndGet();
    }

    private void enableFormatting() {
        int old = this.myIsDisabledCount.getAndDecrement();
        if (old <= 0) {
            LOG.error("enableFormatting()/disableFormatting() not paired. DisabledLevel = " + old);
        }
    }

    @Nullable
    public <T> T runWithFormattingDisabled(@NotNull Computable<T> runnable2) {
        if (runnable2 == null) {
            FormatterImpl.$$$reportNull$$$0(22);
        }
        this.disableFormatting();
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            this.enableFormatting();
        }
    }

    private static void validateModel(FormattingModel model) throws FormattingModelInconsistencyException {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Document document = documentModel.getDocument();
        Block rootBlock = model.getRootBlock();
        if (rootBlock instanceof ASTBlock) {
            PsiElement rootElement = ((ASTBlock)rootBlock).getNode().getPsi();
            if (!rootElement.isValid()) {
                throw new FormattingModelInconsistencyException("Invalid root block PSI element");
            }
            PsiFile file2 = rootElement.getContainingFile();
            Project project = file2.getProject();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isUncommited(document)) {
                throw new FormattingModelInconsistencyException("Uncommitted document");
            }
            if (document.getTextLength() != file2.getTextLength()) {
                throw new FormattingModelInconsistencyException("Document length " + document.getTextLength() + " doesn't match PSI file length " + file2.getTextLength() + ", language: " + file2.getLanguage());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormatterImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRange";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentRegion";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormatterImpl";
                break;
            }
            case 4: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlySpacing";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentLFSpacing";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressCallback";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeSpacing";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeepingFirstColumnSpacing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProgressTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBlockAtOffset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousSibling";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDependentLFSpacing";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getWhiteSpaceAtOffset";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModelForPsiFile";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSmartIndent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runWithFormattingDisabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FormattingModelInconsistencyException
    extends Exception {
        public FormattingModelInconsistencyException(String message) {
            super(message);
        }
    }

    private static abstract class MyFormattingTask
    implements SequentialTask {
        private FormatProcessor myProcessor;
        private boolean myDone;

        private MyFormattingTask() {
        }

        public void prepare() {
            this.myProcessor = this.buildProcessor();
        }

        public boolean isDone() {
            return this.myDone;
        }

        public boolean iteration() {
            this.myDone = this.myProcessor.iteration();
            return this.myDone;
        }

        public void stop() {
            this.myProcessor.stopSequentialProcessing();
            this.myDone = true;
        }

        @NotNull
        protected abstract FormatProcessor buildProcessor();
    }
}

