/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.FileNestingBuilder;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.NestingTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class NestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NestingTreeStructureProvider.class);

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        if (parent == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children2 == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (!(settings instanceof ProjectViewSettings) || !((ProjectViewSettings)settings).isUseFileNestingRules()) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (!(parent instanceof PsiDirectoryNode)) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ArrayList<PsiFileNode> childNodes = new ArrayList<PsiFileNode>();
        for (AbstractTreeNode node : children2) {
            if (!(node instanceof PsiFileNode)) continue;
            childNodes.add((PsiFileNode)node);
        }
        Function<PsiFileNode, String> fileNameFunc = psiFileNode -> {
            PsiFile file2 = (PsiFile)psiFileNode.getValue();
            if (file2 == null) {
                return null;
            }
            return file2.getName();
        };
        FileNestingBuilder fileNestingBuilder = FileNestingBuilder.getInstance();
        MultiMap<PsiFileNode, PsiFileNode> parentToChildren = fileNestingBuilder.mapParentToChildren(childNodes, fileNameFunc);
        if (parentToChildren.isEmpty()) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                NestingTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        ArrayList<AbstractTreeNode> newChildren = new ArrayList<AbstractTreeNode>(children2.size() - parentToChildren.size());
        THashSet childrenToMoveDown = new THashSet(parentToChildren.values());
        for (AbstractTreeNode node : children2) {
            if (!(node instanceof PsiFileNode)) {
                newChildren.add(node);
                continue;
            }
            if (childrenToMoveDown.contains(node)) continue;
            Collection childrenOfThisFile = parentToChildren.get((Object)((PsiFileNode)node));
            if (childrenOfThisFile.isEmpty()) {
                newChildren.add(node);
                continue;
            }
            newChildren.add((AbstractTreeNode)new NestingTreeNode((PsiFileNode)node, childrenOfThisFile));
        }
        ArrayList<AbstractTreeNode> arrayList = newChildren;
        if (arrayList == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static Collection<ChildFileInfo> getFilesShownAsChildrenInProjectView(@NotNull Project project, @NotNull VirtualFile parentFile) {
        if (project == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (parentFile == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!parentFile.isDirectory());
        AbstractProjectViewPane pane = ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
        if (pane instanceof ProjectViewPane && !((ProjectViewPane)pane).isUseFileNestingRules()) {
            return Collections.emptyList();
        }
        VirtualFile dir = parentFile.getParent();
        if (dir == null) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rules = FileNestingBuilder.getInstance().getNestingRules();
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        VirtualFile[] children2 = dir.getChildren();
        if (children2.length <= 1) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeParent = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), true);
        if (rulesWhereItCanBeParent.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeChild = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), false);
        SmartList result2 = new SmartList();
        for (VirtualFile child : children2) {
            String baseName;
            Couple<Boolean> c;
            String childName;
            if (child.isDirectory() || child.equals(parentFile)) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeChild) {
                childName = child.getName();
                c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesParent = (Boolean)c.first;
                if (!matchesParent) continue;
                baseName = childName.substring(0, childName.length() - rule.getParentFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getChildFileSuffix())) continue;
                return Collections.emptyList();
            }
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeParent) {
                childName = child.getName();
                c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild) continue;
                baseName = childName.substring(0, childName.length() - rule.getChildFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getParentFileSuffix())) continue;
                result2.add((Object)new ChildFileInfo(child, baseName));
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<ProjectViewFileNestingService.NestingRule> filterRules(@NotNull Collection<ProjectViewFileNestingService.NestingRule> rules, @NotNull String fileName, boolean parentNotChild) {
        if (rules == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(9);
        }
        SmartList result2 = new SmartList();
        for (ProjectViewFileNestingService.NestingRule rule : rules) {
            Couple<Boolean> c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, fileName);
            boolean matchesParent = (Boolean)c.first;
            boolean matchesChild = (Boolean)c.second;
            if (!matchesChild && !matchesParent) continue;
            if (matchesParent && parentNotChild) {
                result2.add((Object)rule);
            }
            if (!matchesChild || parentNotChild) continue;
            result2.add((Object)rule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            NestingTreeStructureProvider.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilesShownAsChildrenInProjectView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChildFileInfo {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final String namePartCommonWithParentFile;

        public ChildFileInfo(@NotNull VirtualFile file2, @NotNull String namePartCommonWithParentFile) {
            if (file2 == null) {
                ChildFileInfo.$$$reportNull$$$0(0);
            }
            if (namePartCommonWithParentFile == null) {
                ChildFileInfo.$$$reportNull$$$0(1);
            }
            this.file = file2;
            this.namePartCommonWithParentFile = namePartCommonWithParentFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namePartCommonWithParentFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/projectView/impl/NestingTreeStructureProvider$ChildFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

