/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorWithPreview
extends UserDataHolderBase
implements FileEditor {
    protected final TextEditor myEditor;
    protected final FileEditor myPreview;
    @NotNull
    private final MyListenersMultimap myListenersGenerator;
    private Layout myLayout;
    private JComponent myComponent;
    private SplitEditorToolbar myToolbarWrapper;
    private String myName;

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview, @NotNull String editorName) {
        if (editor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            TextEditorWithPreview.$$$reportNull$$$0(1);
        }
        if (editorName == null) {
            TextEditorWithPreview.$$$reportNull$$$0(2);
        }
        this.myListenersGenerator = new MyListenersMultimap();
        this.myEditor = editor;
        this.myPreview = preview;
        this.myName = editorName;
    }

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview) {
        if (editor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(3);
        }
        if (preview == null) {
            TextEditorWithPreview.$$$reportNull$$$0(4);
        }
        this(editor, preview, "TextEditorWithPreview");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
        Disposer.dispose((Disposable)this.myPreview);
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
        this.myPreview.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
        this.myPreview.deselectNotify();
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            JBSplitter splitter = new JBSplitter(false, 0.5f, 0.15f, 0.85f);
            splitter.setSplitterProportionKey(this.getSplitterProportionKey());
            splitter.setFirstComponent(this.myEditor.getComponent());
            splitter.setSecondComponent(this.myPreview.getComponent());
            this.myToolbarWrapper = new SplitEditorToolbar((JComponent)splitter);
            this.myToolbarWrapper.addGutterToTrack((EditorGutterComponentEx)this.myEditor.getEditor().getGutter());
            if (this.myPreview instanceof TextEditor) {
                this.myToolbarWrapper.addGutterToTrack((EditorGutterComponentEx)((TextEditor)this.myPreview).getEditor().getGutter());
            }
            JPanel result2 = new JPanel(new BorderLayout());
            result2.add((Component)this.myToolbarWrapper, "North");
            result2.add((Component)splitter, "Center");
            if (this.myLayout == null) {
                this.myLayout = Layout.SHOW_EDITOR_AND_PREVIEW;
            }
            this.adjustEditorsVisibility();
            this.myComponent = result2;
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            TextEditorWithPreview.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public void setState(@NotNull FileEditorState state2) {
        if (state2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(6);
        }
        if (state2 instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state2;
            if (compositeState.getFirstState() != null) {
                this.myEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.myPreview.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.myLayout = compositeState.getSplitLayout();
                this.invalidateLayout();
            }
        }
    }

    private void adjustEditorsVisibility() {
        this.myEditor.getComponent().setVisible(this.myLayout == Layout.SHOW_EDITOR || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
        this.myPreview.getComponent().setVisible(this.myLayout == Layout.SHOW_PREVIEW || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    private void invalidateLayout() {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    @NotNull
    protected String getSplitterProportionKey() {
        if ("TextEditorWithPreview.SplitterProportionKey" == null) {
            TextEditorWithPreview.$$$reportNull$$$0(7);
        }
        return "TextEditorWithPreview.SplitterProportionKey";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TextEditorWithPreview.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TextEditorWithPreview.$$$reportNull$$$0(9);
        }
        MyFileEditorState myFileEditorState = new MyFileEditorState(this.myLayout, this.myEditor.getState(level), this.myPreview.getState(level));
        if (myFileEditorState == null) {
            TextEditorWithPreview.$$$reportNull$$$0(10);
        }
        return myFileEditorState;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(11);
        }
        this.myEditor.addPropertyChangeListener(listener2);
        this.myPreview.addPropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener2);
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.myPreview.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(12);
        }
        this.myEditor.removePropertyChangeListener(listener2);
        this.myPreview.removePropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener2);
        if (delegate != null) {
            this.myEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.myPreview.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    public boolean isModified() {
        return this.myEditor.isModified() || this.myPreview.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid() && this.myPreview.isValid();
    }

    @Nullable
    protected ActionToolbar createToolbar() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorName";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorWithPreview";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitterProportionKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChangeViewModeAction
    extends ToggleAction
    implements DumbAware {
        private Layout myActionLayout;

        public ChangeViewModeAction(Layout layout) {
            super(layout.getName(), layout.getName(), layout.getIcon());
            this.myActionLayout = layout;
        }

        public boolean isSelected(AnActionEvent e) {
            return TextEditorWithPreview.this.myLayout == this.myActionLayout;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                TextEditorWithPreview.this.myLayout = this.myActionLayout;
                TextEditorWithPreview.this.adjustEditorsVisibility();
            }
        }
    }

    public static enum Layout {
        SHOW_EDITOR("Editor only", AllIcons.General.LayoutEditorOnly),
        SHOW_PREVIEW("Preview only", AllIcons.General.LayoutPreviewOnly),
        SHOW_EDITOR_AND_PREVIEW("Editor and Preview", AllIcons.General.LayoutEditorPreview);

        private final String myName;
        private final Icon myIcon;

        private Layout(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    public class SplitEditorToolbar
    extends JPanel
    implements Disposable {
        private static final String LEFT_TOOLBAR_GROUP_ID = "Markdown.Toolbar.Left";
        private static final String RIGHT_TOOLBAR_GROUP_ID = "Markdown.Toolbar.Right";
        private final ActionToolbar myRightToolbar;
        private final List<EditorGutterComponentEx> myGutters;
        private final ComponentAdapter myAdjustToGutterListener;

        public SplitEditorToolbar(JComponent targetComponentForActions) {
            if (targetComponentForActions == null) {
                SplitEditorToolbar.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myGutters = new ArrayList<EditorGutterComponentEx>();
            this.myAdjustToGutterListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SplitEditorToolbar.this.adjustSpacing();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    SplitEditorToolbar.this.adjustSpacing();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    SplitEditorToolbar.this.adjustSpacing();
                }
            };
            ActionToolbar leftToolbar = TextEditorWithPreview.this.createToolbar();
            if (leftToolbar != null) {
                leftToolbar.setTargetComponent(targetComponentForActions);
                this.add((Component)leftToolbar.getComponent(), "West");
            }
            DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ChangeViewModeAction(Layout.SHOW_EDITOR), new ChangeViewModeAction(Layout.SHOW_EDITOR_AND_PREVIEW), new ChangeViewModeAction(Layout.SHOW_PREVIEW)});
            this.myRightToolbar = ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", (ActionGroup)group, true);
            this.myRightToolbar.setTargetComponent(targetComponentForActions);
            this.add((Component)this.myRightToolbar.getComponent(), "East");
            this.addComponentListener(this.myAdjustToGutterListener);
        }

        public void addGutterToTrack(@NotNull EditorGutterComponentEx gutterComponentEx) {
            if (gutterComponentEx == null) {
                SplitEditorToolbar.$$$reportNull$$$0(1);
            }
            this.myGutters.add(gutterComponentEx);
            gutterComponentEx.addComponentListener(this.myAdjustToGutterListener);
        }

        public void refresh() {
            this.adjustSpacing();
            this.myRightToolbar.updateActionsImmediately();
        }

        private void adjustSpacing() {
            EditorGutterComponentEx leftMostGutter = null;
            for (EditorGutterComponentEx gutter : this.myGutters) {
                if (!gutter.isShowing() || leftMostGutter != null && leftMostGutter.getX() <= gutter.getX()) continue;
                leftMostGutter = gutter;
            }
            if (leftMostGutter == null) {
                boolean spacing = false;
            } else {
                int spacing = leftMostGutter.getWhitespaceSeparatorOffset();
            }
            this.revalidate();
            this.repaint();
        }

        public void dispose() {
            this.removeComponentListener(this.myAdjustToGutterListener);
            for (EditorGutterComponentEx gutter : this.myGutters) {
                gutter.removeComponentListener(this.myAdjustToGutterListener);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetComponentForActions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gutterComponentEx";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$SplitEditorToolbar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGutterToTrack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(0);
            }
            if (!this.myMap.containsKey(listener2)) {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener2)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener2);
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)oldPair.getSecond()));
            }
            DoublingEventListenerDelegate doublingEventListenerDelegate = (DoublingEventListenerDelegate)this.myMap.get(listener2).getSecond();
            if (doublingEventListenerDelegate == null) {
                MyListenersMultimap.$$$reportNull$$$0(1);
            }
            return doublingEventListenerDelegate;
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair;
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(2);
            }
            if ((oldPair = this.myMap.get(listener2)) == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener2);
            } else {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)oldPair.getSecond()));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addListenerAndGetDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addListenerAndGetDelegate";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListenerAndGetDelegate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            if (delegate == null) {
                DoublingEventListenerDelegate.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)TextEditorWithPreview.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/fileEditor/TextEditorWithPreview$DoublingEventListenerDelegate", "<init>"));
        }
    }

    static class MyFileEditorState
    implements FileEditorState {
        private final Layout mySplitLayout;
        private final FileEditorState myFirstState;
        private final FileEditorState mySecondState;

        public MyFileEditorState(Layout layout, FileEditorState firstState, FileEditorState secondState) {
            this.mySplitLayout = layout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public Layout getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }
}

