/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleWithDependenciesScope
extends GlobalSearchScope {
    public static final int COMPILE_ONLY = 1;
    public static final int LIBRARIES = 2;
    public static final int MODULES = 4;
    public static final int TESTS = 8;
    public static final int CONTENT = 32;
    private final Module myModule;
    @ScopeConstant
    private final int myOptions;
    private final ProjectFileIndex myProjectFileIndex;
    private volatile Set<Module> myModules;
    private final TObjectIntHashMap<VirtualFile> myRoots;

    public ModuleWithDependenciesScope(@NotNull Module module2, @ScopeConstant int options) {
        if (module2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(0);
        }
        super(module2.getProject());
        this.myRoots = new TObjectIntHashMap();
        this.myModule = module2;
        this.myOptions = options;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        LinkedHashSet roots = ContainerUtil.newLinkedHashSet();
        if (this.hasOption(32)) {
            Set<Module> modules = this.calcModules();
            this.myModules = ContainerUtil.newTroveSet(modules);
            for (Module m : modules) {
                for (ContentEntry entry2 : ModuleRootManager.getInstance((Module)m).getContentEntries()) {
                    ContainerUtil.addIfNotNull((Collection)roots, (Object)entry2.getFile());
                }
            }
        } else {
            OrderEnumerator en = this.getOrderEnumeratorForOptions();
            Collections.addAll(roots, en.roots(entry -> {
                if (entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry) {
                    return OrderRootType.SOURCES;
                }
                return OrderRootType.CLASSES;
            }).getRoots());
        }
        int i = 1;
        for (VirtualFile root : roots) {
            this.myRoots.put((Object)root, i++);
        }
    }

    private OrderEnumerator getOrderEnumeratorForOptions() {
        OrderEnumerator en = ModuleRootManager.getInstance((Module)this.myModule).orderEntries();
        en.recursively();
        if (this.hasOption(1)) {
            en.exportedOnly().compileOnly();
        }
        if (!this.hasOption(2)) {
            en.withoutLibraries().withoutSdk();
        }
        if (!this.hasOption(4)) {
            en.withoutDepModules();
        }
        if (!this.hasOption(8)) {
            en.productionOnly();
        }
        return en;
    }

    @NotNull
    private Set<Module> calcModules() {
        LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        OrderEnumerator en = this.getOrderEnumeratorForOptions();
        en.forEach(each -> {
            if (each instanceof ModuleOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)modules, (Object)((ModuleOrderEntry)each).getModule());
            } else if (each instanceof ModuleSourceOrderEntry) {
                ContainerUtil.addIfNotNull((Collection)modules, (Object)each.getOwnerModule());
            }
            return true;
        });
        LinkedHashSet linkedHashSet = modules;
        if (linkedHashSet == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(2);
        }
        return module2;
    }

    private boolean hasOption(@ScopeConstant int option) {
        return BitUtil.isSet((int)this.myOptions, (int)option);
    }

    @NotNull
    public String getDisplayName() {
        String string = this.hasOption(1) ? PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{this.myModule.getName()}) : PsiBundle.message((String)"search.scope.module.runtime", (Object[])new Object[]{this.myModule.getName()});
        if (string == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        THashSet allModules;
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(4);
        }
        if ((allModules = this.myModules) == null) {
            this.myModules = allModules = ContainerUtil.newTroveSet(this.calcModules());
        }
        return allModules.contains(aModule);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(5);
        }
        return this.isSearchInModuleContent(aModule) && (this.hasOption(8) || !testSources);
    }

    public boolean isSearchInLibraries() {
        return this.hasOption(2);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(6);
        }
        if (this.hasOption(32)) {
            return this.myRoots.contains((Object)this.myProjectFileIndex.getContentRootForFile(file2));
        }
        if (this.myProjectFileIndex.isInContent(file2) && this.myRoots.contains((Object)this.myProjectFileIndex.getSourceRootForFile(file2))) {
            return true;
        }
        return this.myRoots.contains((Object)this.myProjectFileIndex.getClassRootForFile(file2));
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1;
        if (file1 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(8);
        }
        if (Comparing.equal((Object)(r1 = this.getFileRoot(file1)), (Object)(r2 = this.getFileRoot(file2)))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myRoots.get((Object)r1);
        int i2 = this.myRoots.get((Object)r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(9);
        }
        return (root = this.myProjectFileIndex.getClassRootForFile(file2)) != null ? root : this.myProjectFileIndex.getSourceRootForFile(file2);
    }

    public Collection<VirtualFile> getRoots() {
        ArrayList result2 = ContainerUtil.newArrayList((Object[])this.myRoots.keys());
        Collections.sort(result2, (o1, o2) -> this.myRoots.get(o1) - this.myRoots.get(o2));
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ModuleWithDependenciesScope that = (ModuleWithDependenciesScope)((Object)o);
        return this.myOptions == that.myOptions && this.myModule.equals(that.myModule);
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myOptions;
    }

    public String toString() {
        return "Module with dependencies:" + this.myModule.getName() + " compile only:" + this.hasOption(1) + " include libraries:" + this.hasOption(2) + " include other modules:" + this.hasOption(4) + " include tests:" + this.hasOption(8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface ScopeConstant {
    }
}

