/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.QueueProcessorRemovePartner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerManager
implements ProjectComponent,
LineStatusTrackerManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
    @NotNull
    private final Object myLock;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsBaseContentProvider myStatusProvider;
    @NotNull
    private final Application myApplication;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final Map<Document, TrackerData> myLineStatusTrackers;
    @NotNull
    private final QueueProcessorRemovePartner<Document, BaseRevisionLoader> myPartner;
    private long myLoadCounter;

    public static LineStatusTrackerManagerI getInstance(Project project) {
        return (LineStatusTrackerManagerI)PeriodicalTasksCloser.getInstance().safeGetComponent(project, LineStatusTrackerManagerI.class);
    }

    public LineStatusTrackerManager(@NotNull Project project, @NotNull VcsBaseContentProvider statusProvider, @NotNull Application application, DirectoryIndex makeSureIndexIsInitializedFirst) {
        if (project == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(0);
        }
        if (statusProvider == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(1);
        }
        if (application == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myLineStatusTrackers = new HashMap();
        this.myLoadCounter = 0L;
        this.myProject = project;
        this.myStatusProvider = statusProvider;
        this.myApplication = application;
        this.myPartner = new QueueProcessorRemovePartner(this.myProject, baseRevisionLoader -> baseRevisionLoader.run());
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                LineStatusTracker tracker;
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc)) != null) {
                    tracker.startBulkUpdate();
                }
            }

            @Override
            public void updateFinished(@NotNull Document doc) {
                LineStatusTracker tracker;
                if (doc == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((tracker = LineStatusTrackerManager.this.getLineStatusTracker(doc)) != null) {
                    tracker.finishBulkUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "doc";
                objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)new LineStatusTrackerSettingListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void settingsUpdated() {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    LineStatusTracker.Mode mode = LineStatusTrackerManager.getMode();
                    for (TrackerData data : LineStatusTrackerManager.this.myLineStatusTrackers.values()) {
                        data.tracker.setMode(mode);
                    }
                }
            }
        });
        this.myDisposable = new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    for (TrackerData data : LineStatusTrackerManager.this.myLineStatusTrackers.values()) {
                        data.tracker.release();
                    }
                    LineStatusTrackerManager.this.myLineStatusTrackers.clear();
                    LineStatusTrackerManager.this.myPartner.clear();
                }
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPreStartupActivity(() -> {
            MyFileStatusListener fileStatusListener = new MyFileStatusListener();
            MyEditorFactoryListener editorFactoryListener = new MyEditorFactoryListener();
            MyVirtualFileListener virtualFileListener = new MyVirtualFileListener();
            FileStatusManager fsManager = FileStatusManager.getInstance((Project)this.myProject);
            fsManager.addFileStatusListener((FileStatusListener)fileStatusListener, this.myDisposable);
            EditorFactory editorFactory = EditorFactory.getInstance();
            editorFactory.addEditorFactoryListener((EditorFactoryListener)editorFactoryListener, this.myDisposable);
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            virtualFileManager.addVirtualFileListener((VirtualFileListener)virtualFileListener, this.myDisposable);
        });
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineStatusTrackerManager" == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(3);
        }
        return "LineStatusTrackerManager";
    }

    public boolean isDisabled() {
        return !this.myProject.isOpen() || this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker getLineStatusTracker(Document document) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return null;
            }
            TrackerData data = this.myLineStatusTrackers.get(document);
            LineStatusTracker lineStatusTracker = data != null ? data.tracker : null;
            return lineStatusTracker;
        }
    }

    private boolean isTrackedEditor(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(4);
        }
        return editor.getProject() == null || editor.getProject() == this.myProject;
    }

    @NotNull
    private List<Editor> getAllTrackedEditors(@NotNull Document document) {
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(5);
        }
        List<Editor> list2 = Arrays.asList(EditorFactory.getInstance().getEditors(document, this.myProject));
        if (list2 == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private List<Editor> getAllTrackedEditors() {
        List list2 = ContainerUtil.filter((Object[])EditorFactory.getInstance().getAllEditors(), this::isTrackedEditor);
        if (list2 == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private void onEditorCreated(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(8);
        }
        if (this.isTrackedEditor(editor)) {
            this.installTracker(editor.getDocument());
        }
    }

    private void onEditorRemoved(@NotNull Editor editor) {
        List<Editor> editors;
        if (editor == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(9);
        }
        if (this.isTrackedEditor(editor) && ((editors = this.getAllTrackedEditors(editor.getDocument())).size() == 0 || editors.size() == 1 && editor == editors.get(0))) {
            this.doReleaseTracker(editor.getDocument());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEverythingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            LineStatusTrackerManager.log("onEverythingChanged", null);
            List trackers = ContainerUtil.map(this.myLineStatusTrackers.values(), data -> data.tracker);
            for (LineStatusTracker tracker : trackers) {
                this.resetTracker(tracker.getDocument(), tracker.getVirtualFile(), tracker);
            }
            for (Editor editor : this.getAllTrackedEditors()) {
                this.installTracker(editor.getDocument());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFileChanged(@NotNull VirtualFile virtualFile) {
        Document document;
        if (virtualFile == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(10);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            LineStatusTrackerManager.log("onFileChanged", virtualFile);
            this.resetTracker(document, virtualFile, this.getLineStatusTracker(document));
        }
    }

    private void installTracker(@NotNull Document document) {
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(11);
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        LineStatusTrackerManager.log("installTracker", file2);
        if (this.shouldBeInstalled(file2)) {
            this.doInstallTracker(file2, document);
        }
    }

    private void resetTracker(@NotNull Document document, @NotNull VirtualFile virtualFile, @Nullable LineStatusTracker tracker) {
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(13);
        }
        boolean isOpened = !this.getAllTrackedEditors(document).isEmpty();
        boolean shouldBeInstalled = isOpened && this.shouldBeInstalled(virtualFile);
        LineStatusTrackerManager.log("resetTracker: shouldBeInstalled - " + shouldBeInstalled + ", tracker - " + (tracker == null ? "null" : "found"), virtualFile);
        if (tracker != null && shouldBeInstalled) {
            this.doRefreshTracker(tracker);
        } else if (tracker != null) {
            this.doReleaseTracker(document);
        } else if (shouldBeInstalled) {
            this.doInstallTracker(virtualFile, document);
        }
    }

    @Contract(value="null -> false")
    private boolean shouldBeInstalled(@Nullable VirtualFile virtualFile) {
        if (this.isDisabled()) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        FileStatusManager statusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (statusManager == null) {
            return false;
        }
        if (!this.myStatusProvider.isSupported(virtualFile)) {
            LineStatusTrackerManager.log("shouldBeInstalled failed: file not supported", virtualFile);
            return false;
        }
        FileStatus status = statusManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED || status == FileStatus.ADDED || status == FileStatus.UNKNOWN || status == FileStatus.IGNORED) {
            LineStatusTrackerManager.log("shouldBeInstalled skipped: status=" + status, virtualFile);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshTracker(@NotNull LineStatusTracker tracker) {
        if (tracker == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            LineStatusTrackerManager.log("trackerRefreshed", tracker.getVirtualFile());
            this.startAlarm(tracker.getDocument(), tracker.getVirtualFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReleaseTracker(@NotNull Document document) {
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            this.myPartner.remove((Object)document);
            TrackerData data = this.myLineStatusTrackers.remove(document);
            if (data != null) {
                LineStatusTrackerManager.log("trackerReleased", data.tracker.getVirtualFile());
                data.tracker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInstallTracker(@NotNull VirtualFile virtualFile, @NotNull Document document) {
        if (virtualFile == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(16);
        }
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            if (this.myLineStatusTrackers.containsKey(document)) {
                return;
            }
            assert (!this.myPartner.containsKey((Object)document));
            LineStatusTrackerManager.log("trackerInstalled", virtualFile);
            LineStatusTracker tracker = LineStatusTracker.createOn(virtualFile, document, this.myProject, LineStatusTrackerManager.getMode());
            this.myLineStatusTrackers.put(document, new TrackerData(tracker));
            this.startAlarm(document, virtualFile);
        }
    }

    @NotNull
    private static LineStatusTracker.Mode getMode() {
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (!vcsApplicationSettings.SHOW_LST_GUTTER_MARKERS) {
            LineStatusTracker.Mode mode = LineStatusTracker.Mode.SILENT;
            if (mode == null) {
                LineStatusTrackerManager.$$$reportNull$$$0(18);
            }
            return mode;
        }
        LineStatusTracker.Mode mode = vcsApplicationSettings.SHOW_WHITESPACES_IN_LST ? LineStatusTracker.Mode.SMART : LineStatusTracker.Mode.DEFAULT;
        if (mode == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(19);
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAlarm(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(21);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPartner.add((Object)document, (Object)new BaseRevisionLoader(document, virtualFile));
        }
    }

    private static void log(@NotNull String message, @Nullable VirtualFile file2) {
        if (message == null) {
            LineStatusTrackerManager.$$$reportNull$$$0(22);
        }
        if (LOG.isDebugEnabled()) {
            if (file2 != null) {
                message = message + "; file: " + file2.getPath();
            }
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTrackedEditors";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTrackedEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllTrackedEditors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onEditorCreated";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onEditorRemoved";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onFileChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installTracker";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetTracker";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doRefreshTracker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doReleaseTracker";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doInstallTracker";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startAlarm";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContentInfo {
        @NotNull
        public final VcsRevisionNumber revision;
        @NotNull
        public final Charset charset;
        public final long loadCounter;

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (revision == null) {
                ContentInfo.$$$reportNull$$$0(0);
            }
            if (charset == null) {
                ContentInfo.$$$reportNull$$$0(1);
            }
            this.revision = revision;
            this.charset = charset;
            this.loadCounter = loadCounter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TrackerData {
        @NotNull
        public final LineStatusTracker tracker;
        @Nullable
        private final ContentInfo currentContent;

        public TrackerData(@NotNull LineStatusTracker tracker) {
            if (tracker == null) {
                TrackerData.$$$reportNull$$$0(0);
            }
            this.tracker = tracker;
            this.currentContent = null;
        }

        public TrackerData(@NotNull LineStatusTracker tracker, @NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (tracker == null) {
                TrackerData.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                TrackerData.$$$reportNull$$$0(2);
            }
            if (charset == null) {
                TrackerData.$$$reportNull$$$0(3);
            }
            this.tracker = tracker;
            this.currentContent = new ContentInfo(revision, charset, loadCounter);
        }

        public boolean shouldBeUpdated(@NotNull VcsRevisionNumber revision, @NotNull Charset charset, long loadCounter) {
            if (revision == null) {
                TrackerData.$$$reportNull$$$0(4);
            }
            if (charset == null) {
                TrackerData.$$$reportNull$$$0(5);
            }
            if (this.currentContent == null) {
                return true;
            }
            if (this.currentContent.revision.equals(revision) && !this.currentContent.revision.equals(VcsRevisionNumber.NULL)) {
                return !this.currentContent.charset.equals(charset);
            }
            return this.currentContent.loadCounter < loadCounter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charset";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            if (event.isFromRefresh()) {
                LineStatusTrackerManager.this.onFileChanged(event.getFile());
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            if ("encoding".equals(event.getPropertyName())) {
                LineStatusTrackerManager.this.onFileChanged(event.getFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(0);
            }
            LineStatusTrackerManager.this.onEditorCreated(event.getEditor());
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(1);
            }
            LineStatusTrackerManager.this.onEditorRemoved(event.getEditor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private class BaseRevisionLoader
    implements Runnable {
        @NotNull
        private final VirtualFile myVirtualFile;
        @NotNull
        private final Document myDocument;

        private BaseRevisionLoader(@NotNull Document document, VirtualFile virtualFile) {
            if (document == null) {
                BaseRevisionLoader.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                BaseRevisionLoader.$$$reportNull$$$0(1);
            }
            this.myDocument = document;
            this.myVirtualFile = virtualFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LineStatusTrackerManager.this.isDisabled()) {
                return;
            }
            if (!this.myVirtualFile.isValid()) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: virtual file not valid", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            VcsBaseContentProvider.BaseContent baseContent = LineStatusTrackerManager.this.myStatusProvider.getBaseRevision(this.myVirtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: null returned for base revision", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            VcsRevisionNumber revisionNumber = baseContent.getRevisionNumber();
            Charset charset = this.myVirtualFile.getCharset();
            long loadCounter = LineStatusTrackerManager.this.myLoadCounter;
            LineStatusTrackerManager.this.myLoadCounter++;
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                TrackerData data = (TrackerData)LineStatusTrackerManager.this.myLineStatusTrackers.get(this.myDocument);
                if (data == null) {
                    LineStatusTrackerManager.log("BaseRevisionLoader canceled: tracker already released", this.myVirtualFile);
                    return;
                }
                if (!data.shouldBeUpdated(revisionNumber, charset, loadCounter)) {
                    LineStatusTrackerManager.log("BaseRevisionLoader canceled: no need to update", this.myVirtualFile);
                    return;
                }
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.log("BaseRevisionLoader failed: can't load up-to-date content", this.myVirtualFile);
                this.reportTrackerBaseLoadFailed();
                return;
            }
            String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            Runnable runnable2 = () -> {
                Object object = LineStatusTrackerManager.this.myLock;
                synchronized (object) {
                    TrackerData data = (TrackerData)LineStatusTrackerManager.this.myLineStatusTrackers.get(this.myDocument);
                    if (data == null) {
                        LineStatusTrackerManager.log("BaseRevisionLoader initializing: tracker already released", this.myVirtualFile);
                        return;
                    }
                    if (!data.shouldBeUpdated(revisionNumber, charset, loadCounter)) {
                        LineStatusTrackerManager.log("BaseRevisionLoader initializing: no need to update", this.myVirtualFile);
                        return;
                    }
                    LineStatusTrackerManager.log("BaseRevisionLoader initializing: success", this.myVirtualFile);
                    LineStatusTrackerManager.this.myLineStatusTrackers.put(this.myDocument, new TrackerData(data.tracker, revisionNumber, charset, loadCounter));
                    data.tracker.setBaseRevision(converted);
                }
            };
            this.nonModalAliveInvokeLater(runnable2);
        }

        private void nonModalAliveInvokeLater(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                BaseRevisionLoader.$$$reportNull$$$0(2);
            }
            LineStatusTrackerManager.this.myApplication.invokeLater(runnable2, ModalityState.NON_MODAL, ignore -> LineStatusTrackerManager.this.isDisabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportTrackerBaseLoadFailed() {
            Object object = LineStatusTrackerManager.this.myLock;
            synchronized (object) {
                LineStatusTrackerManager.this.doReleaseTracker(this.myDocument);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseRevisionLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nonModalAliveInvokeLater";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

