/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetectAndAdjustIndentOptionsTask
extends ReadTask {
    private static final Logger LOG = Logger.getInstance(DetectAndAdjustIndentOptionsTask.class);
    private static final int INDENT_COMPUTATION_TIMEOUT = 5000;
    private final Document myDocument;
    private final Project myProject;
    private final CommonCodeStyleSettings.IndentOptions myOptionsToAdjust;
    private final ExecutorService myExecutor;
    private volatile long myComputationStarted;

    public DetectAndAdjustIndentOptionsTask(@NotNull Project project, @NotNull Document document, @NotNull CommonCodeStyleSettings.IndentOptions toAdjust, @NotNull ExecutorService executor) {
        if (project == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(1);
        }
        if (toAdjust == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(3);
        }
        this.myComputationStarted = 0L;
        this.myProject = project;
        this.myDocument = document;
        this.myOptionsToAdjust = toAdjust;
        this.myExecutor = executor;
    }

    private PsiFile getFile() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    @Override
    @Nullable
    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        PsiFile file2;
        if (indicator == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(4);
        }
        if ((file2 = this.getFile()) == null) {
            return null;
        }
        if (!PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(this.myDocument)) {
            this.scheduleInBackgroundForCommittedDocument();
            return null;
        }
        IndentOptionsDetectorImpl detector = new IndentOptionsDetectorImpl(file2, indicator);
        this.myComputationStarted = System.currentTimeMillis();
        IndentOptionsAdjuster adjuster = detector.getIndentOptionsAdjuster();
        return new ReadTask.Continuation(adjuster != null ? () -> this.adjustOptions(adjuster) : EmptyRunnable.INSTANCE);
    }

    private void adjustOptions(IndentOptionsAdjuster adjuster) {
        PsiFile file2 = this.getFile();
        if (file2 == null) {
            return;
        }
        TimeStampedIndentOptions currentDefault = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, this.myDocument);
        this.myOptionsToAdjust.copyFrom((CommonCodeStyleSettings.IndentOptions)currentDefault);
        adjuster.adjust(this.myOptionsToAdjust);
        if (this.myOptionsToAdjust instanceof TimeStampedIndentOptions) {
            TimeStampedIndentOptions cachedInDocument = (TimeStampedIndentOptions)this.myOptionsToAdjust;
            cachedInDocument.setTimeStamp(this.myDocument.getModificationStamp());
            cachedInDocument.setOriginalIndentOptionsHash(currentDefault.hashCode());
        }
    }

    @Override
    public void onCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(5);
        }
        if (this.isComputingForTooLong()) {
            this.logTooLongComputation();
            return;
        }
        this.scheduleInBackgroundForCommittedDocument();
    }

    private void logTooLongComputation() {
        PsiFile file2 = this.getFile();
        String fileName = file2 != null ? file2.getName() : "";
        LOG.debug("Indent detection is too long for: " + fileName);
    }

    private boolean isComputingForTooLong() {
        return System.currentTimeMillis() - this.myComputationStarted > 5000L;
    }

    public void scheduleInBackgroundForCommittedDocument() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            ReadTask.Continuation continuation = this.performInReadAction((ProgressIndicator)new DumbProgressIndicator());
            if (continuation != null) {
                continuation.getAction().run();
            }
        } else {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
            manager.performForCommittedDocument(this.myDocument, () -> ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myExecutor, (ReadTask)this));
        }
    }

    @NotNull
    public static TimeStampedIndentOptions getDefaultIndentOptions(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(6);
        }
        if (document == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(7);
        }
        Project project = file2.getProject();
        FileType fileType = file2.getFileType();
        CodeStyleSettings manager = CodeStyleSettingsManager.getSettings((Project)project);
        TimeStampedIndentOptions timeStampedIndentOptions = new TimeStampedIndentOptions(manager.getIndentOptions(fileType), document.getModificationStamp());
        if (timeStampedIndentOptions == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(8);
        }
        return timeStampedIndentOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdjust";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performInReadAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onCanceled";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultIndentOptions";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

