/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create((String)"stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(FileContent inputData) {
        Stub data = (Stub)inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = (Stub)inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            if (builder != null) {
                data = builder.buildStubTree(inputData);
                if (data instanceof PsiFileStubImpl && !((PsiFileStubImpl)data).rootsAreSet()) {
                    ((PsiFileStubImpl)data).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                FileContentImpl fileContent2 = (FileContentImpl)inputData;
                PsiFile psi = fileContent2.getPsiFileForPsiDependentIndex();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, (Object)contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    IStubFileElementType stubFileElementType = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterASTForPsiDependentIndex());
                        }
                        data = stubBuilder.buildStubTree(psi);
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)((Object)stubbedRoot.first)).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set((LighterAST)new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if (!((element = stubbedRootBuilder.buildStubTree(secondaryPsi)) instanceof PsiFileStub)) continue;
                            stubs.add((PsiFileStub)element);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            inputData.putUserData(stubElementKey, (Object)data);
            return data;
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(0);
        }
        SmartList roots = new SmartList();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            IStubFileElementType type;
            PsiFile file2 = viewProvider.getPsi(language);
            if (!(file2 instanceof PsiFileImpl) || (type = ((PsiFileImpl)file2).getElementTypeForStubBuilder()) == null) continue;
            roots.add(Trinity.create((Object)language, (Object)((Object)type), (Object)file2));
        }
        ContainerUtil.sort((List)roots, (o1, o2) -> {
            if (o1.third == stubBindingRoot) {
                return o2.third == stubBindingRoot ? 0 : -1;
            }
            if (o2.third == stubBindingRoot) {
                return 1;
            }
            return StringUtil.compare((String)((Language)o1.first).getID(), (String)((Language)o2.first).getID(), (boolean)false);
        });
        List list2 = ContainerUtil.map((Collection)roots, trinity -> Pair.create((Object)trinity.second, (Object)trinity.third));
        if (list2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

