/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BekBranch {
    private static final int MAX_BLOCK_SIZE = 20;
    private static final int MAX_DELTA_TIME = 259200000;
    private static final int SMALL_DELTA_TIME = 14400000;
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final List<Integer> myNodeIndexes;
    private int myNoInsertSize;
    @Nullable
    private List<Integer> myPrepareForInsertPart;

    public BekBranch(@NotNull LinearGraph permanentGraph, @NotNull List<Integer> nodeIndexes) {
        if (permanentGraph == null) {
            BekBranch.$$$reportNull$$$0(0);
        }
        if (nodeIndexes == null) {
            BekBranch.$$$reportNull$$$0(1);
        }
        this.myPrepareForInsertPart = null;
        this.myPermanentGraph = permanentGraph;
        this.myNodeIndexes = nodeIndexes;
        this.myNoInsertSize = this.myNodeIndexes.size();
    }

    public void updatePrepareForInsertPart(@NotNull TimestampGetter timestampGetter, @NotNull BekEdgeRestrictions edgeRestrictions) {
        int prevIndex;
        if (timestampGetter == null) {
            BekBranch.$$$reportNull$$$0(2);
        }
        if (edgeRestrictions == null) {
            BekBranch.$$$reportNull$$$0(3);
        }
        assert (this.myPrepareForInsertPart == null);
        int currentNode = this.myNodeIndexes.get(this.myNoInsertSize - 1);
        if (edgeRestrictions.hasRestriction(currentNode)) {
            return;
        }
        for (prevIndex = this.myNoInsertSize - 1; prevIndex > 0; --prevIndex) {
            long delta;
            List<Integer> downNodes;
            int upNode = this.myNodeIndexes.get(prevIndex - 1);
            int downNode = this.myNodeIndexes.get(prevIndex);
            if (edgeRestrictions.hasRestriction(upNode) || ((downNodes = LinearGraphUtils.getDownNodes(this.myPermanentGraph, upNode)).size() <= 1 || !downNodes.contains(downNode)) && (!downNodes.contains(downNode) || (delta = Math.abs(timestampGetter.getTimestamp(upNode) - timestampGetter.getTimestamp(downNode))) > 259200000L || prevIndex < this.myNoInsertSize - 20 && delta > 14400000L)) break;
        }
        this.myPrepareForInsertPart = this.myNodeIndexes.subList(prevIndex, this.myNoInsertSize);
    }

    @Nullable
    public List<Integer> getPrepareForInsertPart() {
        return this.myPrepareForInsertPart;
    }

    public void doneInsertPreparedPart() {
        assert (this.myPrepareForInsertPart != null);
        this.myNoInsertSize -= this.myPrepareForInsertPart.size();
        this.myPrepareForInsertPart = null;
    }

    public boolean isDone() {
        return this.myNoInsertSize == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeIndexes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeRestrictions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/bek/BekBranch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePrepareForInsertPart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

