/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BekBranchMerger {
    @NotNull
    private final List<BekBranch> myBekBranches;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<Integer> myInverseResultList;

    public BekBranchMerger(@NotNull List<BekBranch> bekBranches, @NotNull BekEdgeRestrictions edgeRestrictions, @NotNull TimestampGetter timestampGetter) {
        if (bekBranches == null) {
            BekBranchMerger.$$$reportNull$$$0(0);
        }
        if (edgeRestrictions == null) {
            BekBranchMerger.$$$reportNull$$$0(1);
        }
        if (timestampGetter == null) {
            BekBranchMerger.$$$reportNull$$$0(2);
        }
        this.myInverseResultList = ContainerUtil.newArrayList();
        this.myBekBranches = bekBranches;
        this.myEdgeRestrictions = edgeRestrictions;
        this.myTimestampGetter = timestampGetter;
    }

    private boolean prepareLastPartsForBranches() {
        boolean hasUndoneBranches = false;
        for (BekBranch bekBranch : this.myBekBranches) {
            if (bekBranch.isDone()) continue;
            hasUndoneBranches = true;
            if (bekBranch.getPrepareForInsertPart() != null) continue;
            bekBranch.updatePrepareForInsertPart(this.myTimestampGetter, this.myEdgeRestrictions);
        }
        return hasUndoneBranches;
    }

    private long getBranchLastPartTimestamp(BekBranch bekBranch) {
        List<Integer> prepareForInsertPart = bekBranch.getPrepareForInsertPart();
        if (prepareForInsertPart == null) {
            return Long.MAX_VALUE;
        }
        assert (!prepareForInsertPart.isEmpty());
        int nodeIndex = prepareForInsertPart.get(0);
        return this.myTimestampGetter.getTimestamp(nodeIndex);
    }

    private void step() {
        BekBranch selectBranch = this.myBekBranches.get(0);
        for (BekBranch bekBranch : this.myBekBranches) {
            if (this.getBranchLastPartTimestamp(selectBranch) <= this.getBranchLastPartTimestamp(bekBranch)) continue;
            selectBranch = bekBranch;
        }
        List<Integer> prepareForInsertPart = selectBranch.getPrepareForInsertPart();
        assert (prepareForInsertPart != null);
        for (int insertedNode : prepareForInsertPart) {
            this.myEdgeRestrictions.removeRestriction(insertedNode);
        }
        this.myInverseResultList.addAll(ContainerUtil.reverse(prepareForInsertPart));
        selectBranch.doneInsertPreparedPart();
    }

    @NotNull
    public List<Integer> getResult() {
        while (this.prepareLastPartsForBranches()) {
            this.step();
        }
        List list2 = ContainerUtil.reverse(this.myInverseResultList);
        if (list2 == null) {
            BekBranchMerger.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bekBranches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeRestrictions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/bek/BekBranchMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/bek/BekBranchMerger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

