/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import icons.VcsLogIcons;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserPopupAction
extends DumbAwareAction {
    public IntelliSortChooserPopupAction() {
        super("IntelliSort", "Change IntelliSort Type", VcsLogIcons.IntelliSort);
    }

    public void actionPerformed(AnActionEvent e) {
        VcsLogUi logUI = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        DefaultActionGroup settingsGroup = new DefaultActionGroup(ContainerUtil.map((Object[])PermanentGraph.SortType.values(), sortType -> new SelectIntelliSortTypeAction(logUI, properties, (PermanentGraph.SortType)sortType)));
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)settingsGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "ToolwindowPopup");
        Component component = e.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            popup2.showUnderneathOf(component);
        } else {
            popup2.showInCenterOf(component);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        e.getPresentation().setEnabled(properties != null);
        if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            String description = "IntelliSort: " + properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).getName();
            e.getPresentation().setDescription(description);
            e.getPresentation().setText(description);
        }
    }

    private static class SelectIntelliSortTypeAction
    extends ToggleAction
    implements DumbAware {
        private final PermanentGraph.SortType mySortType;
        private final VcsLogUi myUI;
        private final VcsLogUiProperties myProperties;

        public SelectIntelliSortTypeAction(@NotNull VcsLogUi ui, @NotNull VcsLogUiProperties properties, @NotNull PermanentGraph.SortType sortType) {
            if (ui == null) {
                SelectIntelliSortTypeAction.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                SelectIntelliSortTypeAction.$$$reportNull$$$0(1);
            }
            if (sortType == null) {
                SelectIntelliSortTypeAction.$$$reportNull$$$0(2);
            }
            super(sortType.getName(), sortType.getDescription() + ".", null);
            this.myUI = ui;
            this.myProperties = properties;
            this.mySortType = sortType;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectIntelliSortTypeAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myUI.areGraphActionsEnabled() && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE));
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && this.myProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).equals((Object)this.mySortType);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2 && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
                this.myProperties.set(MainVcsLogUiProperties.BEK_SORT_TYPE, this.mySortType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

