/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.stubs.PyParameterListStub;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterListImpl
extends PyBaseElementImpl<PyParameterListStub>
implements PyParameterList {
    public PyParameterListImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyParameterListImpl(PyParameterListStub stub) {
        this(stub, (IStubElementType)PyElementTypes.PARAMETER_LIST);
    }

    public PyParameterListImpl(PyParameterListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyParameterList(this);
    }

    @Override
    public PyParameter[] getParameters() {
        return (PyParameter[])this.getStubOrPsiChildren(PythonDialectsTokenSetProvider.INSTANCE.getParameterTokens(), (PsiElement[])new PyParameter[0]);
    }

    @Override
    public void addParameter(PyNamedParameter param) {
        PsiElement paren = this.getLastChild();
        if (paren != null && ")".equals(paren.getText())) {
            ASTNode beforeWhat = paren.getNode();
            PyParameter[] params = this.getParameters();
            boolean hasDefaultValue = param.hasDefaultValue();
            boolean isLast = true;
            for (PyParameter p : params) {
                PyNamedParameter named;
                if (!hasDefaultValue && p.hasDefaultValue()) {
                    beforeWhat = p.getNode();
                    isLast = false;
                    break;
                }
                if (!(p instanceof PyNamedParameter) || !(named = (PyNamedParameter)p).isKeywordContainer() && !named.isPositionalContainer()) continue;
                beforeWhat = p.getNode();
                isLast = false;
                break;
            }
            ASTNode previous = PyPsiUtils.getPrevNonWhitespaceSibling(beforeWhat);
            PyUtil.addListNode((PsiElement)this, param, beforeWhat, !isLast || params.length == 0 || previous.getElementType() == PyTokenTypes.COMMA, isLast, beforeWhat.getElementType() != PyTokenTypes.RPAR);
        }
    }

    @Override
    public boolean hasPositionalContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasKeywordContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PyNamedParameter findParameterByName(final @NotNull String name) {
        if (name == null) {
            PyParameterListImpl.$$$reportNull$$$0(0);
        }
        final Ref result2 = new Ref();
        ParamHelper.walkDownParamArray(this.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                if (name.equals(param.getName())) {
                    result2.set((Object)param);
                }
            }
        });
        return (PyNamedParameter)result2.get();
    }

    @Override
    @NotNull
    public String getPresentableText(boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        String string = ParamHelper.getPresentableText(this.getParameters(), includeDefaultValue, context);
        if (string == null) {
            PyParameterListImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public PyFunction getContainingFunction() {
        PsiElement parent = this.getParentByStub();
        return parent instanceof PyFunction ? (PyFunction)parent : null;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode node) {
        if (node == null) {
            PyParameterListImpl.$$$reportNull$$$0(2);
        }
        if (ArrayUtil.contains((Object)node.getPsi(), (Object[])this.getParameters())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, node.getPsi());
        }
        super.deleteChildInternal(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyParameterListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyParameterListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findParameterByName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

