/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.KeywordArgumentCompletionUtil;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyOverridingReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReferenceImpl
implements PsiReferenceEx,
PsiPolyVariantReference {
    protected final PyQualifiedExpression myElement;
    protected final PyResolveContext myContext;
    private static boolean USE_CACHE = true;

    public PyReferenceImpl(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            PyReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myContext = context;
    }

    public TextRange getRangeInElement() {
        ASTNode nameElement = this.myElement.getNameElement();
        TextRange range = nameElement != null ? nameElement.getTextRange() : this.myElement.getNode().getTextRange();
        return range.shiftRight(-this.myElement.getNode().getStartOffset());
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length >= 1 && !(results[0] instanceof ImplicitResolveResult) ? results[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (USE_CACHE) {
            ResolveCache cache = ResolveCache.getInstance(this.getElement().getProject());
            ResolveResult[] resolveResultArray = cache.resolveWithCaching(this, CachingResolver.INSTANCE, true, incompleteCode);
            if (resolveResultArray == null) {
                PyReferenceImpl.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = this.multiResolveInner();
        if (resolveResultArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] multiResolveInner() {
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PyReferenceImpl.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<RatedResolveResult> targets = this.resolveInner();
        if (targets.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PyReferenceImpl.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myElement.getParent() instanceof PyCallExpression) {
            ListIterator<RatedResolveResult> iterator = targets.listIterator();
            block0: while (iterator.hasNext()) {
                RatedResolveResult rrr = iterator.next();
                PsiElement element = rrr.getElement();
                if (!(element instanceof PyClass)) continue;
                PyClass cls = (PyClass)element;
                List<PyFunction> ownInits = cls.multiFindMethodByName("__init__", false, null);
                if (!ownInits.isEmpty()) {
                    iterator.remove();
                    ownInits.forEach(init -> iterator.add(rrr.replace((PsiElement)init)));
                    continue;
                }
                for (PyClass ancestor : cls.getAncestorClasses(this.myContext.getTypeEvalContext())) {
                    List<PyFunction> ancestorInits = ancestor.multiFindMethodByName("__init__", false, null);
                    if (ancestorInits.isEmpty()) continue;
                    ancestorInits.forEach(init -> iterator.add(new RatedResolveResult(-1000, (PsiElement)init)));
                    continue block0;
                }
            }
        }
        ResolveResult[] resolveResultArray = RatedResolveResult.sorted(targets).toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResultList resolveToLatestDefs(@NotNull List<Instruction> instructions, @NotNull PsiElement element, @NotNull String name, @NotNull TypeEvalContext context) {
        if (instructions == null) {
            PyReferenceImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PyReferenceImpl.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyReferenceImpl.$$$reportNull$$$0(9);
        }
        ResolveResultList ret = new ResolveResultList();
        for (Instruction instruction : instructions) {
            PsiElement definition = instruction.getElement();
            if (PyReferenceImpl.isInnerComprehension(element, definition)) continue;
            if (definition instanceof PyImportedNameDefiner && !(definition instanceof PsiNamedElement)) {
                PyImportedNameDefiner definer = (PyImportedNameDefiner)definition;
                List<RatedResolveResult> resolvedResults = definer.multiResolveName(name);
                for (RatedResolveResult result2 : resolvedResults) {
                    ret.add(new ImportedResolveResult(result2.getElement(), result2.getRate(), definer));
                }
                if (resolvedResults.isEmpty()) {
                    ret.add(new ImportedResolveResult(null, 0, definer));
                    continue;
                }
                ret.poke((PsiElement)definer, -1000);
                continue;
            }
            ret.poke(definition, PyReferenceImpl.getRate(definition, context));
        }
        ResolveResultList results = new ResolveResultList();
        for (RatedResolveResult r : ret) {
            PsiElement e = r.getElement();
            if (e == element || element instanceof PyTargetExpression && e != null && PyPsiUtils.isBefore(element, e)) continue;
            results.add(PyReferenceImpl.changePropertyMethodToSameNameGetter(r, name));
        }
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(10);
        }
        return resolveResultList;
    }

    private static boolean isInnerComprehension(PsiElement referenceElement, PsiElement definition) {
        PyComprehensionElement elementComprehension;
        PyComprehensionElement definitionComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)definition, PyComprehensionElement.class);
        return definitionComprehension != null && PyUtil.isOwnScopeComprehension(definitionComprehension) && ((elementComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PyComprehensionElement.class)) == null || !PsiTreeUtil.isAncestor((PsiElement)definitionComprehension, (PsiElement)elementComprehension, (boolean)false));
    }

    @NotNull
    private static RatedResolveResult changePropertyMethodToSameNameGetter(@NotNull RatedResolveResult resolveResult, @NotNull String name) {
        Property property;
        PsiElement element;
        if (resolveResult == null) {
            PyReferenceImpl.$$$reportNull$$$0(11);
        }
        if (name == null) {
            PyReferenceImpl.$$$reportNull$$$0(12);
        }
        if ((element = resolveResult.getElement()) instanceof PyFunction && (property = ((PyFunction)element).getProperty()) != null) {
            PyCallable getter = property.getGetter().valueOrNull();
            PyCallable setter = property.getSetter().valueOrNull();
            PyCallable deleter = property.getDeleter().valueOrNull();
            if (getter != null && name.equals(getter.getName()) && (setter == null || name.equals(setter.getName())) && (deleter == null || name.equals(deleter.getName()))) {
                RatedResolveResult ratedResolveResult = resolveResult.replace((PsiElement)getter);
                if (ratedResolveResult == null) {
                    PyReferenceImpl.$$$reportNull$$$0(13);
                }
                return ratedResolveResult;
            }
        }
        RatedResolveResult ratedResolveResult = resolveResult;
        if (ratedResolveResult == null) {
            PyReferenceImpl.$$$reportNull$$$0(14);
        }
        return ratedResolveResult;
    }

    private static boolean isInOwnScopeComprehension(PsiElement uexpr) {
        PyComprehensionElement comprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)uexpr, PyComprehensionElement.class);
        return comprehensionElement != null && PyUtil.isOwnScopeComprehension(comprehensionElement);
    }

    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        ResolveResultList overriddenResult = this.resolveByOverridingReferenceResolveProviders();
        if (!overriddenResult.isEmpty()) {
            ResolveResultList resolveResultList = overriddenResult;
            if (resolveResultList == null) {
                PyReferenceImpl.$$$reportNull$$$0(15);
            }
            return resolveResultList;
        }
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            List<RatedResolveResult> list2 = Collections.emptyList();
            if (list2 == null) {
                PyReferenceImpl.$$$reportNull$$$0(16);
            }
            return list2;
        }
        if (this.myElement instanceof PyTargetExpression && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyComprehensionElement.class) != null) {
            List<RatedResolveResult> list3 = ResolveResultList.to((PsiElement)this.myElement);
            if (list3 == null) {
                PyReferenceImpl.$$$reportNull$$$0(17);
            }
            return list3;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referencedName);
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)this.myElement);
        PsiElement roof = this.findResolveRoof(referencedName, realContext);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)this.myElement, referencedName, roof);
        List<RatedResolveResult> list4 = this.getResultsFromProcessor(referencedName, processor2, realContext, roof);
        if (list4 == null) {
            PyReferenceImpl.$$$reportNull$$$0(18);
        }
        return list4;
    }

    protected List<RatedResolveResult> getResultsFromProcessor(@NotNull String referencedName, @NotNull PyResolveProcessor processor2, @Nullable PsiElement realContext, @Nullable PsiElement resolveRoof) {
        if (referencedName == null) {
            PyReferenceImpl.$$$reportNull$$$0(19);
        }
        if (processor2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(20);
        }
        boolean unreachableLocalDeclaration = false;
        boolean resolveInParentScope = false;
        ResolveResultList resultList = new ResolveResultList();
        ScopeOwner referenceOwner = ScopeUtil.getScopeOwner(realContext);
        TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
        ScopeOwner resolvedOwner = processor2.getOwner();
        if (resolvedOwner != null && !processor2.getResults().isEmpty()) {
            Collection<PsiElement> resolvedElements = processor2.getElements();
            Scope resolvedScope = ControlFlowCache.getScope(resolvedOwner);
            if (!resolvedScope.isGlobal(referencedName)) {
                if (resolvedOwner == referenceOwner) {
                    List<Instruction> instructions = PyDefUseUtil.getLatestDefs(resolvedOwner, referencedName, realContext, false, true);
                    ResolveResultList latestDefs = PyReferenceImpl.resolveToLatestDefs(instructions, realContext, referencedName, typeEvalContext);
                    if (!latestDefs.isEmpty()) {
                        if (ContainerUtil.exists((Iterable)latestDefs, result2 -> result2.getElement() instanceof PyCallable)) {
                            return ((StreamEx)StreamEx.of(processor2.getResults().keySet()).nonNull().filter(element -> PyiUtil.isOverload(element, typeEvalContext))).map(element -> new RatedResolveResult(PyReferenceImpl.getRate(element, typeEvalContext), (PsiElement)element)).prepend((Collection)latestDefs).toList();
                        }
                        return latestDefs;
                    }
                    if (resolvedOwner instanceof PyClass || instructions.isEmpty() && PyReferenceImpl.allInOwnScopeComprehensions(resolvedElements)) {
                        resolveInParentScope = true;
                    } else {
                        if (PyiUtil.isInsideStubAnnotation((PsiElement)this.myElement)) {
                            for (PsiElement element2 : resolvedElements) {
                                resultList.poke(element2, PyReferenceImpl.getRate(element2, typeEvalContext));
                            }
                            return resultList;
                        }
                        unreachableLocalDeclaration = true;
                    }
                } else if (referenceOwner != null) {
                    PyClass outermostNestedClass;
                    if (!PyReferenceImpl.allowsForwardOutgoingReferencesInClass(this.myElement) && (outermostNestedClass = PyReferenceImpl.outermostNestedClass(referenceOwner, resolvedOwner)) != null) {
                        List<Instruction> instructions = PyDefUseUtil.getLatestDefs(resolvedOwner, referencedName, (PsiElement)outermostNestedClass, false, true);
                        return PyReferenceImpl.resolveToLatestDefs(instructions, (PsiElement)outermostNestedClass, referencedName, typeEvalContext);
                    }
                    Scope referenceScope = ControlFlowCache.getScope(referenceOwner);
                    if (referenceScope.containsDeclaration(referencedName)) {
                        unreachableLocalDeclaration = true;
                    }
                }
            }
        }
        if (!unreachableLocalDeclaration) {
            if (resolveInParentScope) {
                processor2 = new PyResolveProcessor(referencedName);
                if ((resolvedOwner = ScopeUtil.getScopeOwner((PsiElement)resolvedOwner)) != null) {
                    PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, resolvedOwner, referencedName, resolveRoof);
                }
            }
            for (Map.Entry<PsiElement, PyImportedNameDefiner> entry : processor2.getResults().entrySet()) {
                PsiElement resolved = entry.getKey();
                PyImportedNameDefiner definer = entry.getValue();
                if (resolved != null) {
                    if (typeEvalContext.maySwitchToAST(resolved) && PyReferenceImpl.isInnerComprehension(realContext, resolved) || this.skipClassForwardReferences(referenceOwner, resolved)) continue;
                    if (definer == null) {
                        resultList.poke(resolved, PyReferenceImpl.getRate(resolved, typeEvalContext));
                        continue;
                    }
                    resultList.poke((PsiElement)definer, PyReferenceImpl.getRate((PsiElement)definer, typeEvalContext));
                    resultList.add(new ImportedResolveResult(resolved, PyReferenceImpl.getRate(resolved, typeEvalContext), definer));
                    continue;
                }
                if (definer == null) continue;
                resultList.add(new ImportedResolveResult(null, -1000, definer));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        return this.resolveByReferenceResolveProviders();
    }

    private boolean skipClassForwardReferences(@Nullable ScopeOwner referenceOwner, @NotNull PsiElement resolved) {
        if (resolved == null) {
            PyReferenceImpl.$$$reportNull$$$0(21);
        }
        return resolved == referenceOwner && referenceOwner instanceof PyClass && !PyiUtil.isInsideStubAnnotation((PsiElement)this.myElement);
    }

    private static boolean allInOwnScopeComprehensions(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            PyReferenceImpl.$$$reportNull$$$0(22);
        }
        for (PsiElement element : elements) {
            if (PyReferenceImpl.isInOwnScopeComprehension(element)) continue;
            return false;
        }
        return true;
    }

    private static boolean allowsForwardOutgoingReferencesInClass(@NotNull PyQualifiedExpression element) {
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(23);
        }
        return ContainerUtil.exists((Object[])Extensions.getExtensions(PyReferenceResolveProvider.EP_NAME), provider -> {
            if (element == null) {
                PyReferenceImpl.$$$reportNull$$$0(36);
            }
            return provider.allowsForwardOutgoingReferencesInClass(element);
        });
    }

    @Nullable
    private static PyClass outermostNestedClass(@NotNull ScopeOwner referenceOwner, @NotNull ScopeOwner resolvedOwner) {
        if (referenceOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(24);
        }
        if (resolvedOwner == null) {
            PyReferenceImpl.$$$reportNull$$$0(25);
        }
        PyClass current = PyUtil.as(referenceOwner, PyClass.class);
        ScopeOwner outer = ScopeUtil.getScopeOwner((PsiElement)current);
        while (outer != resolvedOwner) {
            current = PyUtil.as(outer, PyClass.class);
            if (current == null) {
                return null;
            }
            outer = ScopeUtil.getScopeOwner((PsiElement)outer);
        }
        return current;
    }

    @NotNull
    private ResolveResultList resolveByOverridingReferenceResolveProviders() {
        ResolveResultList results = new ResolveResultList();
        TypeEvalContext context = this.myContext.getTypeEvalContext();
        Arrays.stream(Extensions.getExtensions(PyReferenceResolveProvider.EP_NAME)).filter(PyOverridingReferenceResolveProvider.class::isInstance).map(provider -> provider.resolveName(this.myElement, context)).forEach(results::addAll);
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(26);
        }
        return resolveResultList;
    }

    @NotNull
    private ResolveResultList resolveByReferenceResolveProviders() {
        ResolveResultList results = new ResolveResultList();
        TypeEvalContext context = this.myContext.getTypeEvalContext();
        for (PyReferenceResolveProvider provider : (PyReferenceResolveProvider[])Extensions.getExtensions(PyReferenceResolveProvider.EP_NAME)) {
            if (provider instanceof PyOverridingReferenceResolveProvider) continue;
            results.addAll(provider.resolveName(this.myElement, context));
        }
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            PyReferenceImpl.$$$reportNull$$$0(27);
        }
        return resolveResultList;
    }

    private PsiElement findResolveRoof(String referencedName, PsiElement realContext) {
        ScopeOwner scopeOwner;
        if (PyUtil.isClassPrivateName(referencedName)) {
            PyArgumentList superClassExpressionList;
            PyElement one = this.myElement;
            while ((one = ScopeUtil.getScopeOwner((PsiElement)one)) instanceof PyFunction) {
            }
            if (one instanceof PyClass && ((superClassExpressionList = ((PyClass)one).getSuperClassExpressionList()) == null || !PsiTreeUtil.isAncestor((PsiElement)superClassExpressionList, (PsiElement)this.myElement, (boolean)false))) {
                return one;
            }
        }
        if (this.myElement instanceof PyTargetExpression && (scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, ScopeOwner.class)) != null) {
            ScopeOwner nonlocalOwner;
            String name;
            Scope scope = ControlFlowCache.getScope(scopeOwner);
            if (scope.isNonlocal(name = this.myElement.getName()) && (nonlocalOwner = ScopeUtil.getDeclarationScopeOwner((PsiElement)this.myElement, referencedName)) != null && !(nonlocalOwner instanceof PyFile)) {
                return nonlocalOwner;
            }
            if (!scope.isGlobal(name)) {
                return scopeOwner;
            }
        }
        return realContext.getContainingFile();
    }

    public static int getRate(@Nullable PsiElement elt, @NotNull TypeEvalContext context) {
        PsiElement parent;
        if (context == null) {
            PyReferenceImpl.$$$reportNull$$$0(28);
        }
        int rate = elt instanceof PyTargetExpression && context.maySwitchToAST(elt) ? ((parent = elt.getParent()) instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement ? -1000 : 0) : (elt instanceof PyImportedNameDefiner || elt instanceof PyReferenceExpression ? -1000 : (elt instanceof PyFile ? 1000 : (elt != null && !PyiUtil.isInsideStub(elt) && PyiUtil.isOverload(elt, context) ? -1000 : 0)));
        return rate;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            PyReferenceImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode nameElement = this.myElement.getNameElement();
        newElementName = StringUtil.trimEnd((String)newElementName, (String)".py");
        if (nameElement != null && PyNames.isIdentifier(newElementName)) {
            ASTNode newNameElement = PyUtil.createNewName(this.myElement, newElementName);
            this.myElement.getNode().replaceChild(nameElement, newNameElement);
        }
        return this.myElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(30);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            PsiDirectory directory2;
            PyFile file2;
            PsiElement resolveResult = this.resolve();
            if (resolveResult instanceof PyImportedModule) {
                resolveResult = resolveResult.getNavigationElement();
            }
            if (element instanceof PsiDirectory && (resolveResult instanceof PyFile ? PyUtil.isPackage(file2 = (PyFile)resolveResult) && file2.getContainingDirectory() == element : resolveResult instanceof PsiDirectory && PyUtil.isPackage(directory2 = (PsiDirectory)resolveResult, null) && directory2 == element)) {
                return true;
            }
            return resolveResult == element;
        }
        if (element instanceof PsiNamedElement) {
            String elementName = ((PsiNamedElement)element).getName();
            if (Comparing.equal((String)this.myElement.getReferencedName(), (String)elementName) || "__init__".equals(elementName)) {
                if (!this.haveQualifiers(element)) {
                    ScopeOwner ourScopeOwner = ScopeUtil.getScopeOwner(this.getElement());
                    ScopeOwner theirScopeOwner = ScopeUtil.getScopeOwner(element);
                    if ((element instanceof PyParameter || element instanceof PyTargetExpression) && this.resolvesToSameLocal(element, elementName, ourScopeOwner, theirScopeOwner)) {
                        return true;
                    }
                    PsiElement resolveResult = this.resolve();
                    if (resolveResult == element) {
                        return true;
                    }
                    if (!this.haveQualifiers(element) && ourScopeOwner != null && theirScopeOwner != null && this.resolvesToSameGlobal(element, elementName, ourScopeOwner, theirScopeOwner, resolveResult)) {
                        return true;
                    }
                    if (this.resolvesToWrapper(element, resolveResult)) {
                        return true;
                    }
                }
                if (element instanceof PyExpression) {
                    PyExpression expr = (PyExpression)element;
                    if (PyUtil.isClassAttribute((PsiElement)this.myElement) && (PyUtil.isClassAttribute((PsiElement)expr) || PyUtil.isInstanceAttribute(expr))) {
                        PyClass c1 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
                        PyClass c2 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class);
                        TypeEvalContext context = this.myContext.getTypeEvalContext();
                        if (c1 != null && c2 != null && (c1.isSubclass(c2, context) || c2.isSubclass(c1, context))) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean resolvesToSameLocal(PsiElement element, String elementName, ScopeOwner ourScopeOwner, ScopeOwner theirScopeOwner) {
        PsiElement ourContainer = PyReferenceImpl.findContainer(this.getElement());
        PsiElement theirContainer = PyReferenceImpl.findContainer(element);
        if (ourContainer != null) {
            if (ourContainer == theirContainer) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)theirContainer, (PsiElement)ourContainer, (boolean)true)) {
                if (ourContainer instanceof PyComprehensionElement && PyReferenceImpl.containsDeclaration((PyComprehensionElement)ourContainer, elementName)) {
                    return false;
                }
                ScopeOwner owner = ourScopeOwner;
                while (owner != theirScopeOwner && owner != null) {
                    if (ControlFlowCache.getScope(owner).containsDeclaration(elementName)) {
                        return false;
                    }
                    owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement findContainer(@NotNull PsiElement element) {
        PyElement parent;
        if (element == null) {
            PyReferenceImpl.$$$reportNull$$$0(31);
        }
        if ((parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{ScopeOwner.class, PyComprehensionElement.class})) instanceof PyListCompExpression && LanguageLevel.forElement(element).isOlderThan(LanguageLevel.PYTHON30)) {
            return PyReferenceImpl.findContainer((PsiElement)parent);
        }
        return parent;
    }

    private static boolean containsDeclaration(@NotNull PyComprehensionElement comprehensionElement, @NotNull String variableName) {
        if (comprehensionElement == null) {
            PyReferenceImpl.$$$reportNull$$$0(32);
        }
        if (variableName == null) {
            PyReferenceImpl.$$$reportNull$$$0(33);
        }
        for (PyComprehensionForComponent forComponent : comprehensionElement.getForComponents()) {
            PyExpression iteratorVariable = forComponent.getIteratorVariable();
            if (iteratorVariable instanceof PyTupleExpression) {
                for (PyExpression variable : (PyTupleExpression)iteratorVariable) {
                    if (!(variable instanceof PyTargetExpression) || !variableName.equals(variable.getName())) continue;
                    return true;
                }
                continue;
            }
            if (!(iteratorVariable instanceof PyTargetExpression) || !variableName.equals(iteratorVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean resolvesToSameGlobal(PsiElement element, String elementName, ScopeOwner ourScopeOwner, ScopeOwner theirScopeOwner, PsiElement resolveResult) {
        PsiFile theirFile;
        PsiFile ourFile = this.getElement().getContainingFile();
        if (ourFile == (theirFile = element.getContainingFile())) {
            boolean ourIsGlobal = ControlFlowCache.getScope(ourScopeOwner).isGlobal(elementName);
            boolean theirIsGlobal = ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
            if (ourIsGlobal && theirIsGlobal) {
                return true;
            }
        }
        return ScopeUtil.getScopeOwner(resolveResult) == ourFile && ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
    }

    protected boolean resolvesToWrapper(PsiElement element, PsiElement resolveResult) {
        PyCallExpression call;
        Pair<String, PyFunction> functionPair;
        PyExpression assignedValue;
        return element instanceof PyFunction && ((PyFunction)element).getContainingClass() != null && resolveResult instanceof PyTargetExpression && (assignedValue = ((PyTargetExpression)resolveResult).findAssignedValue()) instanceof PyCallExpression && (functionPair = PyCallExpressionHelper.interpretAsModifierWrappingCall(call = (PyCallExpression)assignedValue)) != null && functionPair.second == element;
    }

    private boolean haveQualifiers(PsiElement element) {
        if (this.myElement.isQualified()) {
            return true;
        }
        return element instanceof PyQualifiedExpression && ((PyQualifiedExpression)element).isQualified();
    }

    @NotNull
    public Object[] getVariants() {
        ScopeOwner owner;
        ArrayList ret = Lists.newArrayList();
        PyQualifiedExpression originalElement = CompletionUtil.getOriginalElement(this.myElement);
        PyQualifiedExpression element = originalElement != null ? originalElement : this.myElement;
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)element);
        int underscores = PyUtil.getInitialUnderscores(element.getName());
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)element);
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor((PsiElement)element, (Condition<PsiElement>)((Condition)e -> {
            if (builtinCache.isBuiltin((PsiElement)e)) {
                String name;
                String string = name = e instanceof PyElement ? ((PyElement)e).getName() : null;
                if (e instanceof PyImportElement) {
                    return false;
                }
                if (name != null && PyUtil.getInitialUnderscores(name) == 1) {
                    return false;
                }
            }
            return true;
        }), null);
        ScopeOwner scopeOwner = owner = realContext instanceof ScopeOwner ? (ScopeOwner)realContext : ScopeUtil.getScopeOwner(realContext);
        if (owner != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, owner, null, null);
        }
        KeywordArgumentCompletionUtil.collectFunctionArgNames(element, ret, TypeEvalContext.codeCompletion(element.getProject(), element.getContainingFile()));
        PyFile builtinsFile = builtinCache.getBuiltinsFile();
        if (builtinsFile != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, builtinsFile, null, null);
        }
        if (underscores >= 2) {
            if (realContext.getContainingFile() instanceof PyFile) {
                for (String name : PyModuleType.getPossibleInstanceMembers()) {
                    ret.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.FIELD_ICON));
                }
            }
            if (LanguageLevel.forElement((PsiElement)this.myElement).isAtLeast(LanguageLevel.PYTHON30)) {
                Optional.ofNullable(PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyFunction.class)).map(PyPossibleClassMember::getContainingClass).ifPresent(pyClass -> ret.add(LookupElementBuilder.create((String)"__class__")));
            }
        }
        ret.addAll(this.getOriginalElements(processor2));
        Object[] objectArray = ret.toArray();
        if (objectArray == null) {
            PyReferenceImpl.$$$reportNull$$$0(34);
        }
        return objectArray;
    }

    protected List<LookupElement> getOriginalElements(@NotNull CompletionVariantsProcessor processor2) {
        if (processor2 == null) {
            PyReferenceImpl.$$$reportNull$$$0(35);
        }
        ArrayList ret = Lists.newArrayList();
        for (LookupElement item : processor2.getResultList()) {
            PsiElement original;
            PsiElement e = item.getPsiElement();
            if (e != null && (original = CompletionUtil.getOriginalElement(e)) == null) continue;
            ret.add(item);
        }
        return ret;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        if (this.isBuiltInConstant()) {
            return null;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier == null) {
            return HighlightSeverity.ERROR;
        }
        if (context.getType(qualifier) != null) {
            return HighlightSeverity.WARNING;
        }
        return null;
    }

    private boolean isBuiltInConstant() {
        String name = this.myElement.getReferencedName();
        return "None".equals(name) || "True".equals(name) || "False".equals(name) || "__debug__".equals(name);
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyReferenceImpl that = (PyReferenceImpl)o;
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myContext.equals(that.myContext);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    protected static Object[] getTypeCompletionVariants(PyExpression pyExpression, PyType type) {
        ProcessingContext context = new ProcessingContext();
        context.put(PyType.CTX_NAMES, new HashSet());
        return type.getCompletionVariants(pyExpression.getName(), (PsiElement)pyExpression, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 29: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 29: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 7: 
            case 23: 
            case 30: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 20: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedOwner";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comprehensionElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToLatestDefs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "changePropertyMethodToSameNameGetter";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByOverridingReferenceResolveProviders";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByReferenceResolveProviders";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 29: 
            case 34: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveToLatestDefs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "changePropertyMethodToSameNameGetter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getResultsFromProcessor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "skipClassForwardReferences";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "allInOwnScopeComprehensions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "allowsForwardOutgoingReferencesInClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "outermostNestedClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaration";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElements";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$allowsForwardOutgoingReferencesInClass$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 29: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachingResolver
    implements ResolveCache.PolyVariantResolver<PyReferenceImpl> {
        public static CachingResolver INSTANCE = new CachingResolver();
        private ThreadLocal<AtomicInteger> myNesting = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger();
            }
        };
        private static final int MAX_NESTING_LEVEL = 30;

        private CachingResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PyReferenceImpl ref, boolean incompleteCode) {
            ResolveResult[] resolveResultArray;
            block5: {
                if (ref == null) {
                    CachingResolver.$$$reportNull$$$0(0);
                }
                if (this.myNesting.get().getAndIncrement() >= 30) {
                    System.out.println("Stack overflow pending");
                }
                resolveResultArray = ref.multiResolveInner();
                if (resolveResultArray != null) break block5;
                CachingResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
            finally {
                this.myNesting.get().getAndDecrement();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

