/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.util.ArrayList;

public class PyMemberInfoStorage
extends AbstractMemberInfoStorage<PyElement, PyClass, PyMemberInfo<PyElement>> {
    public PyMemberInfoStorage(PyClass aClass) {
        this(aClass, (MemberInfoBase.Filter<PyElement>)new MemberInfoBase.EmptyFilter());
    }

    public PyMemberInfoStorage(PyClass aClass, MemberInfoBase.Filter<PyElement> memberInfoFilter) {
        super(aClass, memberInfoFilter);
    }

    @Override
    protected boolean isInheritor(PyClass baseClass, PyClass aClass) {
        return this.getSubclasses(baseClass).contains(aClass);
    }

    @Override
    protected void buildSubClassesMap(PyClass aClass) {
        this.buildSubClassesMapImpl(aClass, (HashSet<PyClass>)new HashSet());
    }

    private void buildSubClassesMapImpl(PyClass aClass, HashSet<PyClass> visited) {
        visited.add((Object)aClass);
        for (PyClass clazz : aClass.getSuperClasses(null)) {
            this.getSubclasses(clazz).add(aClass);
            if (visited.contains((Object)clazz)) continue;
            this.buildSubClassesMapImpl(clazz, visited);
        }
    }

    @Override
    protected void extractClassMembers(PyClass aClass, ArrayList<PyMemberInfo<PyElement>> temp) {
        temp.addAll(MembersManager.getAllMembersCouldBeMoved(aClass));
    }

    @Override
    protected boolean memberConflict(PyElement member1, PyElement member) {
        return member1 instanceof PyFunction && member instanceof PyFunction && PyRefactoringUtil.areConflictingMethods((PyFunction)member, (PyFunction)member1);
    }
}

