/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.actions.CreatePackageAction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveFileHandler
extends MoveFileHandler {
    private static final Key<PsiNamedElement> REFERENCED_ELEMENT = Key.create((String)"PY_REFERENCED_ELEMENT");
    private static final Key<String> ORIGINAL_FILE_LOCATION = Key.create((String)"PY_ORIGINAL_FILE_LOCATION");

    @Override
    public boolean canProcessElement(PsiFile element) {
        return element.getFileType() == PythonFileType.INSTANCE;
    }

    @Override
    public void prepareMovedFile(PsiFile file2, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        if (file2 != null) {
            PsiDirectory root;
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                PyUtil.deletePycFiles(virtualFile.getPath());
            }
            Collection<VirtualFile> roots = PyUtil.getSourceRoots((PsiElement)file2);
            for (root = moveDestination; root != null && !roots.contains(root.getVirtualFile()); root = root.getParentDirectory()) {
            }
            boolean searchForReferences = RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE;
            if (moveDestination != root && root != null && searchForReferences && !PyMoveFileHandler.probablyNamespacePackage(file2, moveDestination, root)) {
                CreatePackageAction.createInitPyInHierarchy(moveDestination, root);
            }
        }
    }

    @Override
    public void updateMovedFile(PsiFile file2) throws IncorrectOperationException {
        if (file2 instanceof PyFile) {
            PyMoveFileHandler.updateRelativeImportsInModule((PyFile)file2);
        }
    }

    private static void updateRelativeImportsInModule(@NotNull PyFile module2) {
        QualifiedName newName;
        String originalLocation;
        if (module2 == null) {
            PyMoveFileHandler.$$$reportNull$$$0(0);
        }
        if ((originalLocation = (String)module2.getUserData(ORIGINAL_FILE_LOCATION)) == null) {
            return;
        }
        for (PyFromImportStatement statement : module2.getFromImports()) {
            if (!PyMoveFileHandler.canBeRelative(statement)) continue;
            int relativeLevel = Math.max(statement.getRelativeLevel(), 1);
            PsiFileSystemItem sourceElement = PyMoveFileHandler.resolveRelativeImportFromModuleLocation(statement.getManager(), originalLocation, statement.getImportSource(), relativeLevel);
            if (sourceElement == null) continue;
            newName = QualifiedNameFinder.findShortestImportableQName(sourceElement);
            PyMoveFileHandler.replaceRelativeImportSourceWithQualifiedExpression(statement, newName);
        }
        for (PyImportElement importElement : module2.getImportTargets()) {
            ScopeOwner scopeOwner;
            PsiFileSystemItem resolved;
            PyReferenceExpression referenceExpr = importElement.getImportReferenceExpression();
            if (!PyMoveFileHandler.canBeRelative(importElement) || referenceExpr == null || (resolved = PyMoveFileHandler.resolveRelativeImportFromModuleLocation(importElement.getManager(), originalLocation, referenceExpr, 1)) == null) continue;
            newName = QualifiedNameFinder.findShortestImportableQName(resolved);
            PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)referenceExpr, newName);
            final QualifiedName oldQualifiedName = referenceExpr.asQualifiedName();
            if (Comparing.equal((Object)oldQualifiedName, (Object)newName) || (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)importElement)) == null) continue;
            scopeOwner.accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    if (Comparing.equal((Object)node.asQualifiedName(), (Object)oldQualifiedName)) {
                        PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)node, newName);
                    } else {
                        super.visitPyReferenceExpression(node);
                    }
                }
            });
        }
    }

    private static boolean canBeRelative(@NotNull PyFromImportStatement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(1);
        }
        return LanguageLevel.forElement((PsiElement)statement).isPython2() || statement.getRelativeLevel() > 0;
    }

    private static boolean canBeRelative(@NotNull PyImportElement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(2);
        }
        return LanguageLevel.forElement((PsiElement)statement).isPython2();
    }

    @Nullable
    private static PsiFileSystemItem resolveRelativeImportFromModuleLocation(@NotNull PsiManager manager, @NotNull String moduleLocation, @Nullable PyReferenceExpression referenceExpr, int relativeLevel) {
        if (manager == null) {
            PyMoveFileHandler.$$$reportNull$$$0(3);
        }
        if (moduleLocation == null) {
            PyMoveFileHandler.$$$reportNull$$$0(4);
        }
        String relativeImportBasePath = VirtualFileManager.extractPath((String)moduleLocation);
        for (int level = 0; level < relativeLevel; ++level) {
            relativeImportBasePath = PathUtil.getParentPath((String)relativeImportBasePath);
        }
        if (!relativeImportBasePath.isEmpty()) {
            VirtualFile relativeImportBaseDir;
            String protocol = VirtualFileManager.extractProtocol((String)moduleLocation);
            assert (protocol != null) : "Original location: " + moduleLocation;
            String relativeImportBaseUrl = VirtualFileManager.constructUrl((String)protocol, (String)relativeImportBasePath);
            VirtualFile sourceFile = relativeImportBaseDir = VirtualFileManager.getInstance().findFileByUrl(relativeImportBaseUrl);
            if (relativeImportBaseDir != null && relativeImportBaseDir.isDirectory() && referenceExpr != null) {
                QualifiedName qualifiedName = referenceExpr.asQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                String relativePath = qualifiedName.join("/");
                sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath);
                if (sourceFile == null) {
                    sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath + ".py");
                }
            }
            if (sourceFile != null) {
                Object sourceElement = sourceFile.isDirectory() ? manager.findDirectory(sourceFile) : manager.findFile(sourceFile);
                return sourceElement;
            }
        }
        return null;
    }

    private static boolean probablyNamespacePackage(@NotNull PsiFile anchor, @NotNull PsiDirectory destination, @NotNull PsiDirectory root) {
        if (anchor == null) {
            PyMoveFileHandler.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            PyMoveFileHandler.$$$reportNull$$$0(6);
        }
        if (root == null) {
            PyMoveFileHandler.$$$reportNull$$$0(7);
        }
        if (!LanguageLevel.forElement((PsiElement)anchor).isAtLeast(LanguageLevel.PYTHON33)) {
            return false;
        }
        while (destination != null && destination != root) {
            if (destination.findFile("__init__.py") != null) {
                return false;
            }
            destination = destination.getParent();
        }
        return true;
    }

    @Override
    public List<UsageInfo> findUsages(PsiFile file2, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (file2 != null) {
            file2.putUserData(ORIGINAL_FILE_LOCATION, (Object)file2.getVirtualFile().getUrl());
            List<UsageInfo> usages = PyRefactoringUtil.findUsages((PsiNamedElement)file2, false);
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null) continue;
                element.putCopyableUserData(REFERENCED_ELEMENT, (Object)file2);
            }
            return usages;
        }
        return null;
    }

    @Override
    public void retargetUsages(List<UsageInfo> usages, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet<PsiFile> updatedFiles = new HashSet<PsiFile>();
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (usageElement == null) continue;
            PsiNamedElement movedElement = (PsiNamedElement)usageElement.getCopyableUserData(REFERENCED_ELEMENT);
            usageElement.putCopyableUserData(REFERENCED_ELEMENT, null);
            if (movedElement == null) continue;
            PsiFile usageFile = usageElement.getContainingFile();
            PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)usageElement, PyImportStatementBase.class);
            if (importStmt != null) {
                boolean usageInsideImportElement;
                if (usageFile.getUserData(ORIGINAL_FILE_LOCATION) != null) {
                    TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(usageFile.getProject(), usageFile);
                    PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(typeEvalContext);
                    if (ContainerUtil.getFirstItem(PyUtil.multiResolveTopPriority(usageElement, resolveContext)) == movedElement) continue;
                }
                updatedFiles.add(usageFile);
                boolean bl = usageInsideImportElement = PsiTreeUtil.getParentOfType((PsiElement)usageElement, PyImportElement.class) != null;
                if (usageInsideImportElement && PyClassRefactoringUtil.updateUnqualifiedImportOfElement(importStmt, movedElement)) continue;
                QualifiedName newElementName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)movedElement, usageElement);
                if (importStmt instanceof PyFromImportStatement) {
                    if (usageInsideImportElement) continue;
                    PyMoveFileHandler.replaceRelativeImportSourceWithQualifiedExpression((PyFromImportStatement)importStmt, newElementName);
                    continue;
                }
                PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newElementName);
                continue;
            }
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            updatedFiles.add(usageFile);
            if (((PyReferenceExpression)usageElement).isQualified()) {
                QualifiedName newQualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)movedElement, usageElement);
                PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newQualifiedName);
                continue;
            }
            QualifiedName newName = QualifiedName.fromComponents((String[])new String[]{PyClassRefactoringUtil.getOriginalName(movedElement)});
            PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newName);
        }
        if (!updatedFiles.isEmpty()) {
            PyImportOptimizer optimizer = PyImportOptimizer.onlyRemoveUnused();
            for (PsiFile file2 : updatedFiles) {
                boolean injectedFragment = InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2);
                if (injectedFragment) continue;
                optimizer.processFile(file2).run();
            }
        }
    }

    @NotNull
    private static PsiElement replaceWithQualifiedExpression(@NotNull PsiElement oldElement, @Nullable QualifiedName newElementName) {
        PyElementGenerator generator;
        PyExpression newElement;
        if (oldElement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(8);
        }
        if (newElementName != null && PyClassRefactoringUtil.isValidQualifiedName(newElementName) && (newElement = (generator = PyElementGenerator.getInstance(oldElement.getProject())).createExpressionFromText(LanguageLevel.forElement(oldElement), newElementName.toString())) != null) {
            PsiElement psiElement = oldElement.replace((PsiElement)newElement);
            if (psiElement == null) {
                PyMoveFileHandler.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement psiElement = oldElement;
        if (psiElement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement replaceRelativeImportSourceWithQualifiedExpression(@NotNull PyFromImportStatement importStatement, @Nullable QualifiedName qualifiedName) {
        Couple<PsiElement> range;
        if (importStatement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(11);
        }
        if ((range = PyMoveFileHandler.getRelativeImportSourceRange(importStatement)) != null && qualifiedName != null) {
            if (range.getFirst() == range.getSecond()) {
                PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)range.getFirst(), qualifiedName);
            } else {
                importStatement.deleteChildRange(((PsiElement)range.getFirst()).getNextSibling(), (PsiElement)range.getSecond());
                PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)range.getFirst(), qualifiedName);
            }
        }
        PyFromImportStatement pyFromImportStatement = importStatement;
        if (pyFromImportStatement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(12);
        }
        return pyFromImportStatement;
    }

    @Nullable
    private static Couple<PsiElement> getRelativeImportSourceRange(@NotNull PyFromImportStatement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(13);
        }
        PsiElement fromKeyword = statement.getFirstChild();
        assert (fromKeyword.getNode().getElementType() == PyTokenTypes.FROM_KEYWORD);
        PsiElement elementAfterFrom = PsiTreeUtil.skipWhitespacesForward((PsiElement)fromKeyword);
        if (elementAfterFrom == null) {
            return null;
        }
        if (elementAfterFrom instanceof PyReferenceExpression) {
            return Couple.of((Object)elementAfterFrom, (Object)elementAfterFrom);
        }
        if (elementAfterFrom.getNode().getElementType() == PyTokenTypes.DOT) {
            PsiElement lastDot;
            PsiElement next = elementAfterFrom;
            do {
                lastDot = next;
            } while ((next = PsiTreeUtil.skipWhitespacesForward((PsiElement)next)) != null && next.getNode().getElementType() == PyTokenTypes.DOT);
            if (next instanceof PyReferenceExpression) {
                return Couple.of((Object)elementAfterFrom, (Object)next);
            }
            return Couple.of((Object)elementAfterFrom, (Object)lastDot);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithQualifiedExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateRelativeImportsInModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeRelative";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveRelativeImportFromModuleLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "probablyNamespacePackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithQualifiedExpression";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeImportSourceRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

