/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PythonRunConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import java.io.File;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfiguration
extends AbstractPythonRunConfiguration
implements AbstractPythonRunConfigurationParams,
PythonRunConfigurationParams,
RefactoringListenerProvider {
    public static final String SCRIPT_NAME = "SCRIPT_NAME";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String MULTIPROCESS = "MULTIPROCESS";
    public static final String SHOW_COMMAND_LINE = "SHOW_COMMAND_LINE";
    public static final String EMULATE_TERMINAL = "EMULATE_TERMINAL";
    public static final String MODULE_MODE = "MODULE_MODE";
    private String myScriptName;
    private String myScriptParameters;
    private boolean myShowCommandLineAfterwards = false;
    private boolean myEmulateTerminal = false;
    private boolean myModuleMode = false;
    private final Pattern myQualifiedNameRegex = Pattern.compile("^[a-zA-Z0-9._]+[a-zA-Z0-9_]$");

    protected PythonRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
        this.setUnbufferedEnv();
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PythonRunConfigurationEditor(this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PythonRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PythonRunConfiguration.$$$reportNull$$$0(1);
        }
        return new PythonScriptCommandLineState(this, env);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myScriptName)) {
            throw new RuntimeConfigurationException(PyBundle.message(this.isModuleMode() ? "runcfg.unittest.no_module_name" : "runcfg.unittest.no_script_name", new Object[0]));
        }
        if (this.isModuleMode() && !this.myQualifiedNameRegex.matcher(this.myScriptName).matches()) {
            throw new RuntimeConfigurationWarning("Provide a qualified name of a module");
        }
    }

    public String suggestedName() {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            return null;
        }
        String name = new File(scriptName).getName();
        if (name.endsWith(".py")) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.myScriptName = scriptName;
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineAfterwards;
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineAfterwards = showCommandLineAfterwards;
    }

    @Override
    public boolean emulateTerminal() {
        return this.myEmulateTerminal;
    }

    @Override
    public void setEmulateTerminal(boolean emulateTerminal) {
        this.myEmulateTerminal = emulateTerminal;
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_NAME);
        this.myScriptParameters = JDOMExternalizerUtil.readField((Element)element, (String)PARAMETERS);
        this.myShowCommandLineAfterwards = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)SHOW_COMMAND_LINE, (String)"false"));
        this.myEmulateTerminal = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EMULATE_TERMINAL, (String)"false"));
        this.myModuleMode = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)MODULE_MODE, (String)"false"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_NAME, (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element, (String)PARAMETERS, (String)this.myScriptParameters);
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_COMMAND_LINE, (String)Boolean.toString(this.myShowCommandLineAfterwards));
        JDOMExternalizerUtil.writeField((Element)element, (String)EMULATE_TERMINAL, (String)Boolean.toString(this.myEmulateTerminal));
        JDOMExternalizerUtil.writeField((Element)element, (String)MODULE_MODE, (String)Boolean.toString(this.myModuleMode));
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    public static void copyParams(PythonRunConfigurationParams source, PythonRunConfigurationParams target2) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target2.getBaseParams());
        target2.setModuleMode(source.isModuleMode());
        target2.setScriptName(source.getScriptName());
        target2.setScriptParameters(source.getScriptParameters());
        target2.setShowCommandLineAfterwards(source.showCommandLineAfterwards());
        target2.setEmulateTerminal(source.emulateTerminal());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile virtualFile;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && Comparing.equal((String)new File(virtualFile.getPath()).getAbsolutePath(), (String)new File(this.myScriptName).getAbsolutePath())) {
            return new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    VirtualFile virtualFile;
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((virtualFile = ((PsiFile)newElement).getVirtualFile()) != null) {
                        this.updateScriptName(virtualFile.getPath());
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.updateScriptName(oldQualifiedName);
                }

                private void updateScriptName(String path) {
                    PythonRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)path);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/run/PythonRunConfiguration$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    @Override
    public boolean isModuleMode() {
        return this.myModuleMode;
    }

    @Override
    public void setModuleMode(boolean moduleMode) {
        this.myModuleMode = moduleMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "executor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/run/PythonRunConfiguration";
        objectArray[2] = "getState";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

