/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.InitializationData;
import Ice.Properties;
import Ice.Util;
import IceBox.ServiceManagerI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Server
extends Application {
    private static void usage() {
        System.err.println("Usage: IceBox.Server [options] --Ice.Config=<file>\n");
        System.err.println("Options:\n-h, --help           Show this message.\n");
    }

    public static void main(String[] args) {
        InitializationData initData = new InitializationData();
        initData.properties = Util.createProperties();
        initData.properties.setProperty("Ice.Admin.DelayCreation", "1");
        Server server = new Server();
        System.exit(server.main("IceBox.Server", args, initData));
    }

    @Override
    public int run(String[] args) {
        String prefix = "IceBox.Service.";
        Properties properties = Server.communicator().getProperties();
        Map<String, String> services = properties.getPropertiesForPrefix("IceBox.Service.");
        ArrayList<String> argSeq = new ArrayList<String>(args.length);
        for (String s : args) {
            argSeq.add(s);
        }
        for (Map.Entry entry : services.entrySet()) {
            String name = ((String)entry.getKey()).substring("IceBox.Service.".length());
            for (int i = 0; i < argSeq.size(); ++i) {
                if (!((String)argSeq.get(i)).startsWith("--" + name)) continue;
                argSeq.remove(i);
                --i;
            }
        }
        Iterator iterator = argSeq.iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("-h") || string.equals("--help")) {
                Server.usage();
                return 0;
            }
            System.err.println("Server: unknown option `" + string + "'");
            Server.usage();
            return 1;
        }
        ServiceManagerI serviceManagerImpl = new ServiceManagerI(Server.communicator(), args);
        return serviceManagerImpl.run();
    }
}

