// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 **/
public interface LoggerAdmin extends com.zeroc.Ice.Object
{
    public static class GetLogResult
    {
        public GetLogResult()
        {
        }

        /**
         * This constructor makes shallow copies of the results for operation GetLog.
         * @param returnValue The Log messages.
         * @param prefix The prefix of the associated local {@link Logger}.
         **/
        public GetLogResult(LogMessage[] returnValue, String prefix)
        {
            this.returnValue = returnValue;
            this.prefix = prefix;
        }

        /**
         * The Log messages.
         **/
        public LogMessage[] returnValue;
        /**
         * The prefix of the associated local {@link Logger}.
         **/
        public String prefix;

        public void write(com.zeroc.Ice.OutputStream ostr)
        {
            ostr.writeString(this.prefix);
            LogMessageSeqHelper.write(ostr, returnValue);
        }

        public void read(com.zeroc.Ice.InputStream istr)
        {
            this.prefix = istr.readString();
            returnValue = LogMessageSeqHelper.read(istr);
        }
    }

    /**
     * attachRemoteLogger is called to attach a {@link RemoteLogger} object to
     * the local {@link Logger}.
     * attachRemoteLogger calls init on the provided {@link RemoteLogger} proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to {@link RemoteLogger#init}. A negative value requests all messages available.
     * @param current The Current object for the invocation.
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     **/
    void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, com.zeroc.Ice.Current current)
        throws RemoteLoggerAlreadyAttachedException;

    /**
     * detachRemoteLogger is called to detach a {@link RemoteLogger} object from
     * the local {@link Logger}.
     * @param prx A proxy to the remote logger.
     * @param current The Current object for the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     **/
    boolean detachRemoteLogger(RemoteLoggerPrx prx, com.zeroc.Ice.Current current);

    /**
     * getLog retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param current The Current object for the invocation.
     * @return An instance of LoggerAdmin.GetLogResult.
     **/
    LoggerAdmin.GetLogResult getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::LoggerAdmin",
        "::Ice::Object"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::LoggerAdmin";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_attachRemoteLogger(LoggerAdmin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        RemoteLoggerPrx iceP_prx;
        LogMessageType[] iceP_messageTypes;
        String[] iceP_traceCategories;
        int iceP_messageMax;
        iceP_prx = RemoteLoggerPrx.uncheckedCast(istr.readProxy());
        iceP_messageTypes = LogMessageTypeSeqHelper.read(istr);
        iceP_traceCategories = istr.readStringSeq();
        iceP_messageMax = istr.readInt();
        inS.endReadParams();
        obj.attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_detachRemoteLogger(LoggerAdmin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        RemoteLoggerPrx iceP_prx;
        iceP_prx = RemoteLoggerPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        boolean ret = obj.detachRemoteLogger(iceP_prx, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getLog(LoggerAdmin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        LogMessageType[] iceP_messageTypes;
        String[] iceP_traceCategories;
        int iceP_messageMax;
        iceP_messageTypes = LogMessageTypeSeqHelper.read(istr);
        iceP_traceCategories = istr.readStringSeq();
        iceP_messageMax = istr.readInt();
        inS.endReadParams();
        LoggerAdmin.GetLogResult ret = obj.getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    final static String[] _iceOps =
    {
        "attachRemoteLogger",
        "detachRemoteLogger",
        "getLog",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_attachRemoteLogger(this, in, current);
            }
            case 1:
            {
                return _iceD_detachRemoteLogger(this, in, current);
            }
            case 2:
            {
                return _iceD_getLog(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
