// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `UserAccountMapper.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 *
 **/
public interface UserAccountMapperPrx extends Ice.ObjectPrx
{
    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @return The user account name.
     *
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     *
     **/
    public String getUserAccount(String user)
        throws UserAccountNotFoundException;

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @return The user account name.
     *
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     *
     **/
    public String getUserAccount(String user, java.util.Map<String, String> context)
        throws UserAccountNotFoundException;

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> context);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Ice.Callback cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Callback_UserAccountMapper_getUserAccount cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> context, Callback_UserAccountMapper_getUserAccount cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param result The asynchronous result object.
     * @return The user account name.
     *
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     *
     **/
    public String end_getUserAccount(Ice.AsyncResult result)
        throws UserAccountNotFoundException;
}
