/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge.ui;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.merge.JoinWithSeparator;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JoinWithSeparatorUI
extends JPanel
implements ManipulatorUI {
    private JoinWithSeparator manipulator;
    private DialogControls dialogControls;
    private Table table;
    private JLabel separatorLabel;
    private JTextField separatorText;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public JoinWithSeparatorUI() {
        this.initComponents();
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            private void refreshOkButton() {
                String text = JoinWithSeparatorUI.this.titleTextField.getText();
                JoinWithSeparatorUI.this.dialogControls.setOkButtonEnabled(text != null && !text.isEmpty() && !JoinWithSeparatorUI.this.table.hasColumn(text));
            }
        });
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (JoinWithSeparator)m;
        this.dialogControls = dialogControls;
        this.table = this.manipulator.getTable();
        this.separatorText.setText(this.manipulator.getSeparator());
    }

    public void unSetup() {
        this.manipulator.setNewColumnTitle(this.titleTextField.getText());
        this.manipulator.setSeparator(this.separatorText.getText());
        NbPreferences.forModule(JoinWithSeparator.class).put("JoinWithSeparator_Separator", this.separatorText.getText());
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        return validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.separatorLabel = new JLabel();
        this.separatorText = new JTextField();
        this.titleLabel.setText(NbBundle.getMessage(JoinWithSeparatorUI.class, (String)"JoinWithSeparatorUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(JoinWithSeparatorUI.class, (String)"JoinWithSeparatorUI.titleTextField.text"));
        this.separatorLabel.setText(NbBundle.getMessage(JoinWithSeparatorUI.class, (String)"JoinWithSeparatorUI.separatorLabel.text"));
        this.separatorText.setText(NbBundle.getMessage(JoinWithSeparatorUI.class, (String)"JoinWithSeparatorUI.separatorText.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel).addComponent(this.separatorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separatorText, -1, 135, Short.MAX_VALUE).addComponent(this.titleTextField, -1, 135, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separatorLabel).addComponent(this.separatorText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

