/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeSelectionSchema;

class MultipleCandidateMatcher<T extends HasAttributes> {
    private final AttributeSelectionSchema schema;
    private final ImmutableAttributes requested;
    private final List<? extends T> candidates;
    private final Attribute<?>[] allAttributes;
    private final BitSet compatible;
    private Object[] attributeValues;
    private int candidateWithLongestMatch;
    private int lengthOfLongestMatch;
    private BitSet remaining;

    MultipleCandidateMatcher(AttributeSelectionSchema schema, Collection<? extends T> candidates, ImmutableAttributes requested) {
        this.schema = schema;
        this.requested = requested;
        this.candidates = candidates instanceof List ? (List)candidates : ImmutableList.copyOf(candidates);
        this.allAttributes = schema.getAttributes().toArray(new Attribute[0]);
        this.attributeValues = new Object[MultipleCandidateMatcher.initialTableSize(candidates.size(), this.allAttributes.length, requested.keySet().size())];
        this.compatible = new BitSet(candidates.size());
        this.compatible.set(0, candidates.size());
    }

    public List<T> getMatches() {
        this.fillRequestedValues();
        this.findCompatibleCandidates();
        if (this.compatible.cardinality() <= 1) {
            return this.getCandidates(this.compatible);
        }
        if (this.longestMatchIsSuperSetOfAllOthers()) {
            return Collections.singletonList(this.candidates.get(this.candidateWithLongestMatch));
        }
        return this.disambiguateCompatibleCandidates();
    }

    private void fillRequestedValues() {
        for (int a = 0; a < this.allAttributes.length; ++a) {
            Attribute<?> attribute = this.allAttributes[a];
            AttributeValue attributeValue = this.requested.findEntry(attribute);
            this.setRequestedValue(a, attributeValue.isPresent() ? attributeValue.get() : null);
        }
    }

    private void findCompatibleCandidates() {
        for (int c = 0; c < this.candidates.size(); ++c) {
            this.matchCandidate(c);
        }
    }

    private void matchCandidate(int c) {
        int matchLength = 0;
        ImmutableAttributes candidateAttributes = ((AttributeContainerInternal)((HasAttributes)this.candidates.get(c)).getAttributes()).asImmutable();
        for (int a = 0; a < this.allAttributes.length; ++a) {
            MatchResult result = this.recordAndMatchCandidateValue(c, a, candidateAttributes);
            if (result == MatchResult.NO_MATCH) {
                return;
            }
            if (result != MatchResult.MATCH) continue;
            ++matchLength;
        }
        if (matchLength > this.lengthOfLongestMatch) {
            this.lengthOfLongestMatch = matchLength;
            this.candidateWithLongestMatch = c;
        }
    }

    private MatchResult recordAndMatchCandidateValue(int c, int a, ImmutableAttributes candidateAttributes) {
        Object requestedValue = this.getRequestedValue(a);
        Attribute<?> attribute = this.allAttributes[a];
        AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
        if (!candidateValue.isPresent()) {
            this.setCandidateValue(c, a, null);
            return MatchResult.MISSING;
        }
        Object coercedValue = candidateValue.coerce(attribute);
        this.setCandidateValue(c, a, coercedValue);
        if (requestedValue == null) {
            return MatchResult.EXTRA;
        }
        boolean match = this.schema.matchValue(attribute, requestedValue, coercedValue);
        if (match) {
            return MatchResult.MATCH;
        }
        this.compatible.clear(c);
        return MatchResult.NO_MATCH;
    }

    private boolean longestMatchIsSuperSetOfAllOthers() {
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            if (c != this.candidateWithLongestMatch) {
                int lengthOfOtherMatch = 0;
                for (int a = 0; a < this.allAttributes.length; ++a) {
                    if (this.getRequestedValue(a) == null || this.getCandidateValue(c, a) == null) continue;
                    ++lengthOfOtherMatch;
                    if (this.getCandidateValue(this.candidateWithLongestMatch, a) != null) continue;
                    return false;
                }
                if (lengthOfOtherMatch == this.lengthOfLongestMatch) {
                    return false;
                }
            }
            c = this.compatible.nextSetBit(c + 1);
        }
        return true;
    }

    private List<T> disambiguateCompatibleCandidates() {
        this.remaining = new BitSet(this.candidates.size());
        this.remaining.or(this.compatible);
        for (int a = 0; a < this.allAttributes.length; ++a) {
            this.disambiguateAttribute(a);
            if (this.remaining.cardinality() != 0) continue;
            return this.getCandidates(this.compatible);
        }
        return this.getCandidates(this.remaining);
    }

    private void disambiguateAttribute(int a) {
        Set<Object> candidateValues = this.getCandidateValues(a);
        if (candidateValues.size() == 1) {
            return;
        }
        Set<Object> matches = this.schema.disambiguate(this.allAttributes[a], this.getRequestedValue(a), candidateValues);
        this.removeCandidatesWithValueNotIn(a, matches);
    }

    private Set<Object> getCandidateValues(int a) {
        HashSet candidateValues = Sets.newHashSetWithExpectedSize((int)this.compatible.cardinality());
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            candidateValues.add(this.getCandidateValue(c, a));
            c = this.compatible.nextSetBit(c + 1);
        }
        return candidateValues;
    }

    private void removeCandidatesWithValueNotIn(int a, Set<Object> matchedValues) {
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            if (!matchedValues.contains(this.getCandidateValue(c, a))) {
                this.remaining.clear(c);
            }
            c = this.compatible.nextSetBit(c + 1);
        }
    }

    private List<T> getCandidates(BitSet liveSet) {
        if (liveSet.cardinality() == 0) {
            return Collections.emptyList();
        }
        if (liveSet.cardinality() == 1) {
            return Collections.singletonList(this.candidates.get(liveSet.nextSetBit(0)));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int c = liveSet.nextSetBit(0);
        while (c >= 0) {
            builder.add(this.candidates.get(c));
            c = liveSet.nextSetBit(c + 1);
        }
        return builder.build();
    }

    private void setRequestedValue(int a, Object value) {
        this.attributeValues[a] = value;
    }

    private Object getRequestedValue(int a) {
        return this.attributeValues[a];
    }

    private void setCandidateValue(int c, int a, Object value) {
        int index = this.getValueIndex(c, a);
        this.ensureTableSize(index);
        this.attributeValues[index] = value;
    }

    private Object getCandidateValue(int c, int a) {
        return this.attributeValues[this.getValueIndex(c, a)];
    }

    private int getValueIndex(int c, int a) {
        return (1 + c - this.reusedSlotsBefore(c)) * this.allAttributes.length + a;
    }

    private int reusedSlotsBefore(int c) {
        int slots = 0;
        int slot = this.compatible.nextClearBit(0);
        while (slot >= 0 && slot < c) {
            ++slots;
            slot = this.compatible.nextClearBit(slot + 1);
        }
        return slots;
    }

    private void ensureTableSize(int index) {
        if (this.attributeValues.length <= index) {
            Object[] newTable = new Object[this.fullTableSize(this.candidates.size(), this.allAttributes.length)];
            System.arraycopy(this.attributeValues, 0, newTable, 0, this.attributeValues.length);
            this.attributeValues = newTable;
        }
    }

    private static int initialTableSize(int candidates, int allAttributes, int requestedAttributes) {
        int expectedCompatibleCandidates = Math.max(1, candidates / Math.max(1, requestedAttributes));
        return (2 + expectedCompatibleCandidates) * allAttributes;
    }

    private int fullTableSize(int candidates, int allAttributes) {
        return (1 + candidates) * allAttributes;
    }

    private static enum MatchResult {
        MATCH,
        MISSING,
        EXTRA,
        NO_MATCH;

    }
}

