/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.model.internal.type.ClassTypeWrapper;
import org.gradle.model.internal.type.GenericArrayTypeWrapper;
import org.gradle.model.internal.type.ParameterizedTypeWrapper;
import org.gradle.model.internal.type.TypeVariableTypeWrapper;
import org.gradle.model.internal.type.TypeWrapper;
import org.gradle.model.internal.type.WildcardTypeWrapper;
import org.gradle.model.internal.type.WildcardWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelType<T> {
    public static final ModelType<Object> UNTYPED = ModelType.of(Object.class);
    private final TypeWrapper wrapper;
    private static final TypeWrapper[] EMPTY_TYPE_WRAPPER_ARRAY = new TypeWrapper[0];

    private ModelType(TypeWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected ModelType() {
        this.wrapper = ModelType.wrap(new TypeToken<T>(this.getClass()){}.getType());
    }

    public static <T> ModelType<T> of(Class<T> clazz) {
        return new Simple(clazz);
    }

    public static <T> ModelType<T> returnType(Method method) {
        return new Simple(method.getGenericReturnType());
    }

    public static <T> ModelType<T> declaringType(Method method) {
        return new Simple(method.getDeclaringClass());
    }

    @Nullable
    public static <T> ModelType<T> paramType(Method method, int i) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (i < parameterTypes.length) {
            return new Simple(parameterTypes[i]);
        }
        return null;
    }

    public static <T> ModelType<T> typeOf(T instance) {
        Class<?> clazz = instance.getClass();
        return ModelType.of(clazz);
    }

    public static ModelType<?> of(Type type) {
        return Simple.typed(type);
    }

    public boolean isClass() {
        return this.wrapper instanceof ClassTypeWrapper;
    }

    public Class<? super T> getRawClass() {
        return (Class)Cast.uncheckedCast(this.wrapper.getRawClass());
    }

    public Class<T> getConcreteClass() {
        return (Class)Cast.uncheckedCast(this.wrapper.getRawClass());
    }

    public boolean isRawClassOfParameterizedType() {
        return this.wrapper instanceof ClassTypeWrapper && ((ClassTypeWrapper)this.wrapper).unwrap().getTypeParameters().length > 0;
    }

    public static ModelType<Object> untyped() {
        return UNTYPED;
    }

    public boolean isParameterized() {
        return this.wrapper instanceof ParameterizedTypeWrapper;
    }

    public ModelType<?> getRawType() {
        return Simple.typed(((ParameterizedTypeWrapper)this.wrapper).getRawType());
    }

    public ModelType<?> withArguments(List<ModelType<?>> types) {
        return Simple.typed(((ParameterizedTypeWrapper)this.wrapper).substituteAll(ModelType.toWrappers(types)));
    }

    public boolean isGenericArray() {
        return this.wrapper instanceof GenericArrayTypeWrapper;
    }

    public ModelType<?> getComponentType() {
        return Simple.typed(((GenericArrayTypeWrapper)this.wrapper).getComponentType());
    }

    public List<ModelType<?>> getTypeVariables() {
        if (this.isParameterized()) {
            TypeWrapper[] typeArguments = ((ParameterizedTypeWrapper)this.wrapper).getActualTypeArguments();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (TypeWrapper typeArgument : typeArguments) {
                builder.add(Simple.typed(typeArgument));
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public <U> ModelType<? extends U> asSubtype(ModelType<U> modelType) {
        if (this.isWildcard()) {
            throw new IllegalStateException(this + " is a wildcard type");
        }
        if (modelType.isWildcard()) {
            throw new IllegalArgumentException(modelType + " is a wildcard type");
        }
        if (modelType.getRawClass().isAssignableFrom(this.getRawClass())) {
            return (ModelType)Cast.uncheckedCast((Object)this);
        }
        throw new ClassCastException(String.format("'%s' cannot be cast as a subtype of '%s'", this, modelType));
    }

    public boolean isAssignableFrom(ModelType<?> modelType) {
        return modelType == this || this.wrapper.isAssignableFrom(modelType.wrapper);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getRawClass().isAnnotationPresent(annotation);
    }

    public boolean isWildcard() {
        return this.getWildcardType() != null;
    }

    @Nullable
    public ModelType<?> getUpperBound() {
        WildcardWrapper wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        ModelType upperBound = Simple.typed(wildcardType.getUpperBound());
        if (upperBound.equals(UNTYPED)) {
            return null;
        }
        return upperBound;
    }

    @Nullable
    public ModelType<?> getLowerBound() {
        WildcardWrapper wildcardType = this.getWildcardType();
        if (wildcardType == null) {
            return null;
        }
        TypeWrapper lowerBound = wildcardType.getLowerBound();
        if (lowerBound == null) {
            return null;
        }
        return Simple.typed(lowerBound);
    }

    private WildcardWrapper getWildcardType() {
        if (this.wrapper instanceof WildcardWrapper) {
            return (WildcardWrapper)this.wrapper;
        }
        return null;
    }

    public boolean isHasWildcardTypeVariables() {
        if (this.isWildcard()) {
            return true;
        }
        if (this.isParameterized()) {
            for (ModelType<?> typeVariable : this.getTypeVariables()) {
                if (!typeVariable.isHasWildcardTypeVariables()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Class<?>> getAllClasses() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.wrapper.collectClasses(builder);
        return builder.build();
    }

    public String getName() {
        return this.wrapper.getRepresentation(true);
    }

    public String getDisplayName() {
        return this.wrapper.getRepresentation(false);
    }

    public String toString() {
        return this.wrapper.getRepresentation(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelType)) {
            return false;
        }
        ModelType modelType = (ModelType)o;
        return this.wrapper.equals(modelType.wrapper);
    }

    public int hashCode() {
        return this.wrapper.hashCode();
    }

    @Nullable
    private static TypeWrapper wrap(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return new ClassTypeWrapper((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeWrapper(ModelType.toWrappers(parameterizedType.getActualTypeArguments()), (ClassTypeWrapper)ModelType.wrap(parameterizedType.getRawType()), ModelType.wrap(parameterizedType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new WildcardTypeWrapper(ModelType.toWrappers(wildcardType.getUpperBounds()), ModelType.toWrappers(wildcardType.getLowerBounds()), type.hashCode());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return new TypeVariableTypeWrapper(typeVariable.getName(), ModelType.toWrappers(typeVariable.getBounds()), type.hashCode());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new GenericArrayTypeWrapper(ModelType.wrap(genericArrayType.getGenericComponentType()), type.hashCode());
        }
        throw new IllegalArgumentException("cannot wrap type of type " + type.getClass());
    }

    static TypeWrapper[] toWrappers(Type[] types) {
        if (types.length == 0) {
            return EMPTY_TYPE_WRAPPER_ARRAY;
        }
        TypeWrapper[] wrappers = new TypeWrapper[types.length];
        int i = 0;
        for (Type type : types) {
            wrappers[i++] = ModelType.wrap(type);
        }
        return wrappers;
    }

    static TypeWrapper[] toWrappers(List<ModelType<?>> types) {
        if (types.isEmpty()) {
            return EMPTY_TYPE_WRAPPER_ARRAY;
        }
        TypeWrapper[] wrappers = new TypeWrapper[types.size()];
        int i = 0;
        for (ModelType<?> type : types) {
            wrappers[i++] = type.wrapper;
        }
        return wrappers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Simple<T>
    extends ModelType<T> {
        public static <T> ModelType<T> typed(Type type) {
            return new Simple<T>(type);
        }

        public static <T> ModelType<T> typed(TypeWrapper wrapper) {
            return new Simple<T>(wrapper);
        }

        public Simple(Type type) {
            super(ModelType.wrap(type));
        }

        public Simple(TypeWrapper type) {
            super(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Parameter<T> {
        private final TypeVariable<?> typeVariable;

        public Parameter() {
            Type type = new TypeToken<T>(this.getClass()){}.getType();
            if (!(type instanceof TypeVariable)) {
                throw new IllegalStateException("T for Parameter<T> MUST be a type variable");
            }
            this.typeVariable = (TypeVariable)type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<T> {
        private ParameterizedTypeWrapper wrapper = (ParameterizedTypeWrapper)ModelType.access$000(new TypeToken<T>(this.getClass()){}.getType());

        public <I> Builder<T> where(Parameter<I> parameter, ModelType<I> type) {
            this.wrapper = this.wrapper.substitute(((Parameter)parameter).typeVariable, ((ModelType)type).wrapper);
            return this;
        }

        public ModelType<T> build() {
            return Simple.typed(this.wrapper);
        }
    }
}

