/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.DomExtension;
import org.apache.batik.dom.ExtensibleDOMImplementation;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationElement;
import org.apache.batik.extension.svg.BatikRegularPolygonElement;
import org.apache.batik.extension.svg.BatikStarElement;
import org.apache.batik.extension.svg.ColorSwitchElement;
import org.apache.batik.extension.svg.FlowDivElement;
import org.apache.batik.extension.svg.FlowLineElement;
import org.apache.batik.extension.svg.FlowParaElement;
import org.apache.batik.extension.svg.FlowRegionBreakElement;
import org.apache.batik.extension.svg.FlowRegionElement;
import org.apache.batik.extension.svg.FlowSpanElement;
import org.apache.batik.extension.svg.FlowTextElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatikDomExtension
implements DomExtension,
BatikExtConstants {
    @Override
    public float getPriority() {
        return 1.0f;
    }

    @Override
    public String getAuthor() {
        return "Thomas DeWeese";
    }

    @Override
    public String getContactAddress() {
        return "deweese@apache.org";
    }

    @Override
    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    @Override
    public String getDescription() {
        return "Example extension to standard SVG shape tags";
    }

    @Override
    public void registerTags(ExtensibleDOMImplementation di) {
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "regularPolygon", new BatikRegularPolygonElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "star", new BatikStarElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "histogramNormalization", new BatikHistogramNormalizationElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "colorSwitch", new ColorSwitchElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowText", new FlowTextElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowDiv", new FlowDivElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowPara", new FlowParaElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowRegionBreak", new FlowRegionBreakElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowRegion", new FlowRegionElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowLine", new FlowLineElementFactory());
        di.registerCustomElementFactory("http://xml.apache.org/batik/ext", "flowSpan", new FlowSpanElementFactory());
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowSpanElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowLineElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowRegionElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowRegionBreakElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowParaElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowDivElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowTextElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new FlowTextElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class ColorSwitchElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new ColorSwitchElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class BatikHistogramNormalizationElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new BatikHistogramNormalizationElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class BatikStarElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new BatikStarElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class BatikRegularPolygonElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        @Override
        public Element create(String prefix, Document doc) {
            return new BatikRegularPolygonElement(prefix, (AbstractDocument)doc);
        }
    }
}

