/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PsiReader
extends MOReader {
    Lst<String> atomNames = new Lst();
    Lst<Lst<int[]>> shellsByUniqueAtom = new Lst();
    Map<String, Integer> uniqueAtomMap = new Hashtable<String, Integer>();

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("-Geometry after Center-of-Mass shift and reorientation (a.u.):") >= 0) {
            this.readAtoms(true);
            this.doProcessLines = true;
            return true;
        }
        if (this.line.indexOf("-Unique atoms in the canonical coordinate system (a.u.):") >= 0) {
            this.readUniqueAtoms();
            this.doProcessLines = true;
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("New Cartesian Geometry in a.u.") >= 0) {
            this.readAtoms(false);
            return true;
        }
        if (this.line.startsWith("  label        = ")) {
            this.calculationType = this.line.substring(17).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.startsWith("molecular orbitals for ")) {
            this.moData.put("energyUnits", "");
            return true;
        }
        if (this.line.startsWith("  -BASIS SETS:")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (this.filterMO()) {
                this.readPsiMolecularOrbitals();
            }
            return true;
        }
        if (this.line.indexOf("SCF total energy   =") >= 0) {
            this.readSCFDone();
            return true;
        }
        if (this.line.indexOf("Normal Modes") >= 0) {
            this.readFrequencies();
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        this.asc.setAtomSetName(this.line);
    }

    private void readAtoms(boolean isInitial) throws Exception {
        if (isInitial) {
            this.asc.newAtomSet();
            this.asc.setAtomSetName("");
            this.discardLinesUntilContains("----");
        }
        int atomPt = 0;
        while (this.rd() != null && this.line.length() > 0) {
            Atom atom;
            String[] tokens = this.getTokens();
            Atom atom2 = atom = isInitial ? this.asc.addNewAtom() : this.asc.atoms[atomPt++];
            if (isInitial) {
                this.atomNames.addLast(tokens[0]);
                if (tokens[0].length() <= 2) {
                    atom.elementNumber = (short)JmolAdapter.getElementNumber(tokens[0]);
                }
            } else {
                atom.elementNumber = (short)this.parseIntStr(tokens[0]);
            }
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordScaled(atom, tokens, 1, 0.5291772f);
        }
    }

    void readBasis() throws Exception {
        String[] tokens;
        Lst<String[]> gdata = new Lst<String[]>();
        this.gaussianCount = 0;
        this.shellCount = 0;
        int[] slater = null;
        Lst<int[]> slatersByUniqueAtom = null;
        this.rd();
        while (this.rd() != null && this.line.startsWith("   -Basis set on")) {
            slatersByUniqueAtom = new Lst<int[]>();
            int nGaussians = 0;
            while (this.rd() != null && !this.line.startsWith("       )")) {
                this.line = this.line.replace('(', ' ').replace(')', ' ');
                tokens = this.getTokens();
                int ipt = 0;
                switch (tokens.length) {
                    case 3: {
                        if (slater != null) {
                            slatersByUniqueAtom.addLast(slater);
                        }
                        ipt = 1;
                        slater = new int[3];
                        slater[0] = BasisFunctionReader.getQuantumShellTagID(tokens[0]);
                        slater[1] = this.gaussianCount;
                        ++this.shellCount;
                        break;
                    }
                }
                gdata.addLast(new String[]{tokens[ipt], tokens[ipt + 1]});
                slater[2] = ++nGaussians;
            }
            if (slater != null) {
                slatersByUniqueAtom.addLast(slater);
            }
            this.shellsByUniqueAtom.addLast(slatersByUniqueAtom);
            this.gaussianCount += nGaussians;
            this.rd();
        }
        float[][] garray = AU.newFloat2(this.gaussianCount);
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            garray[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                garray[i][j] = this.parseFloatStr(tokens[j]);
            }
        }
        this.moData.put("gaussians", garray);
        if (this.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readUniqueAtoms() throws Exception {
        Lst<int[]> sdata = new Lst<int[]>();
        this.discardLinesUntilContains("----");
        int n = 0;
        while (this.rd() != null && this.line.length() > 0) {
            String[] tokens = this.getTokens();
            this.uniqueAtomMap.put(tokens[0], n++);
        }
        int ac = this.atomNames.size();
        for (int i = 0; i < ac; ++i) {
            String atomType = (String)this.atomNames.get(i);
            int iUnique = this.uniqueAtomMap.get(atomType);
            Lst slaters = (Lst)this.shellsByUniqueAtom.get(iUnique);
            if (slaters == null) {
                Logger.error("slater for atom " + i + " atomType " + atomType + " was not found in listing. Ignoring molecular orbitals");
                return;
            }
            for (int j = 0; j < slaters.size(); ++j) {
                int[] slater = (int[])slaters.get(j);
                sdata.addLast(new int[]{i + 1, slater[0], slater[1], slater[2]});
            }
        }
        this.moData.put("shells", sdata);
    }

    void readPsiMolecularOrbitals() throws Exception {
        Map<K, V>[] mos = AU.createArrayOfHashtable(5);
        Lst<type>[] data = AU.createArrayOfArrayList(5);
        int nThisLine = 0;
        while (this.rd() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int i;
            int ptData;
            String[] tokens = this.getTokens();
            int n = ptData = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(nThisLine, data, mos);
                nThisLine = tokens.length;
                tokens = PT.getTokens(this.rd());
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Lst();
                    mos[i].put("symmetry", tokens[i]);
                }
                tokens = PsiReader.getStrings(this.rd().substring(21), nThisLine, 10);
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", Float.valueOf(PT.fVal(tokens[i])));
                }
                continue;
            }
            try {
                for (i = 0; i < nThisLine; ++i) {
                    data[i].addLast(tokens[i + ptData]);
                }
            }
            catch (Exception e) {
                Logger.error("Error reading Psi3 file molecular orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(nThisLine, data, mos);
        this.moData.put("mos", this.orbitals);
        this.finalizeMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        this.rd();
        int ac = this.asc.getLastAtomSetAtomCount();
        while (this.rd() != null && this.line.indexOf("Frequency") >= 0) {
            String[] tokens = this.getTokens();
            int iAtom0 = this.asc.ac;
            boolean[] ignore = new boolean[1];
            if (!this.doGetVibration(++this.vibrationNumber)) continue;
            this.asc.cloneLastAtomSet();
            this.asc.setAtomSetFrequency(null, null, tokens[1], null);
            this.readLines(2);
            this.fillFrequencyData(iAtom0, ac, ac, ignore, true, 0, 0, null, 0);
            this.rd();
        }
    }
}

