/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control.event;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementEventQueue
implements IElementEventQueue {
    private static final String THREAD_PREFIX = "JCS-ElementEventQueue-";
    private static final Log log = LogFactory.getLog(ElementEventQueue.class);
    private boolean destroyed = false;
    private ExecutorService queueProcessor = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 1, 1, 0, PoolConfiguration.WhenBlockedPolicy.RUN, 1), "JCS-ElementEventQueue-");

    public ElementEventQueue() {
        if (log.isDebugEnabled()) {
            log.debug("Constructed: " + this);
        }
    }

    @Override
    public void dispose() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.queueProcessor.shutdownNow();
            this.queueProcessor = null;
            if (log.isInfoEnabled()) {
                log.info("Element event queue destroyed: " + this);
            }
        }
    }

    @Override
    public <T> void addElementEvent(IElementEventHandler hand, IElementEvent<T> event) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Adding Event Handler to QUEUE, !destroyed = " + !this.destroyed);
        }
        if (this.destroyed) {
            log.warn("Event submitted to disposed element event queue " + event);
        } else {
            ElementEventRunner runner = new ElementEventRunner(hand, event);
            if (log.isDebugEnabled()) {
                log.debug("runner = " + runner);
            }
            this.queueProcessor.execute(runner);
        }
    }

    private class ElementEventRunner
    extends AbstractElementEventRunner {
        private final IElementEventHandler hand;
        private final IElementEvent<?> event;

        ElementEventRunner(IElementEventHandler hand, IElementEvent<?> event) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("Constructing " + this);
            }
            this.hand = hand;
            this.event = event;
        }

        @Override
        protected void doRun() throws IOException {
            this.hand.handleElementEvent(this.event);
        }
    }

    protected abstract class AbstractElementEventRunner
    implements Runnable {
        protected AbstractElementEventRunner() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException e) {
                log.warn("Giving up element event handling " + ElementEventQueue.this, e);
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

