/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteTagsAction
extends JosmAction {
    private static final String HELP = HelpUtil.ht("/Action/PasteTags");
    private final OsmTransferHandler transferHandler = new OsmTransferHandler();

    public PasteTagsAction() {
        super(I18n.tr("Paste Tags", new Object[0]), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items.", new Object[0]), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009), true);
        this.putValue("help", HELP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        this.transferHandler.pasteTags(selection);
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

