/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bugreport;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.bugreport.BugReportSettingsPanel;
import org.openstreetmap.josm.gui.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.gui.bugreport.JosmUpdatePanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class BugReportDialog
extends JDialog {
    private static final int MAX_MESSAGE_SIZE = 500;
    private final JPanel content = new JPanel(new GridBagLayout());
    private final BugReport report;
    private final DebugTextDisplay textPanel;
    private JCheckBox cbSuppressSingle;
    private JCheckBox cbSuppressAll;
    public static final BugReportSender.BugReportSendingHandler bugReportSendingHandler = new BugReportSender.BugReportSendingHandler(){

        @Override
        public String sendingBugReport(String bugUrl, String statusText) {
            return OpenBrowser.displayUrl(bugUrl);
        }

        @Override
        public void failed(String errorMessage, String statusText) {
            SwingUtilities.invokeLater(() -> {
                JPanel errorPanel = new JPanel(new GridBagLayout());
                errorPanel.add((Component)new JMultilineLabel(I18n.tr("Opening the bug report failed. Please report manually using this website:", new Object[0])), GBC.eol().fill(2));
                errorPanel.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket", 2), GBC.eop().insets(8, 0, 0, 0));
                errorPanel.add(new DebugTextDisplay(statusText));
                JOptionPane.showMessageDialog(Main.parent, errorPanel, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
            });
        }
    };

    public BugReportDialog(BugReport report) {
        super(BugReportDialog.findParent(), I18n.tr("You have encountered a bug in JOSM", new Object[0]));
        this.report = report;
        this.textPanel = new DebugTextDisplay(report);
        this.setContentPane(this.content);
        this.addMessageSection();
        this.addUpToDateSection();
        this.addCreateTicketSection();
        if (ExpertToggleAction.isExpert()) {
            this.addDebugTextSection();
        }
        this.addIgnoreButton();
        this.pack();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        InputMapUtils.addEscapeAction(this.getRootPane(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReportDialog.this.closeDialog();
            }
        });
    }

    private void addMessageSection() {
        String message = I18n.tr("An unexpected exception occurred.\nThis is always a coding error. If you are running the latest version of JOSM, please consider being kind and file a bug report.", new Object[0]);
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(icon), GBC.std().insets(0, 0, 10, 0));
        JMultilineLabel messageLabel = new JMultilineLabel(message);
        messageLabel.setMaxWidth(500);
        panel.add((Component)messageLabel, GBC.eol().fill());
        this.content.add((Component)panel, GBC.eop().fill(2).insets(20, 10, 10, 10));
    }

    private void addDebugTextSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        BugReportDialog.addBorder(panel, I18n.tr("Debug information", new Object[0]));
        panel.add((Component)this.textPanel, GBC.eop().fill());
        panel.add((Component)new JLabel(I18n.tr("Manually report at:", new Object[0]) + ' '), GBC.std());
        panel.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket"), GBC.std().fill(2));
        JButton copy = new JButton("Copy to clipboard");
        copy.addActionListener(e -> this.textPanel.copyToClipboard());
        panel.add((Component)copy, GBC.eol().anchor(13));
        this.content.add((Component)panel, GBC.eop().fill());
    }

    private void addUpToDateSection() {
        JosmUpdatePanel panel = new JosmUpdatePanel();
        BugReportDialog.addBorder(panel, I18n.tr("Is JOSM up to date?", new Object[0]));
        this.content.add((Component)panel, GBC.eop().fill(2));
    }

    private void addCreateTicketSection() {
        JPanel panel = new JPanel(new GridBagLayout());
        BugReportDialog.addBorder(panel, I18n.tr("Send bug report", new Object[0]));
        JMultilineLabel helpText = new JMultilineLabel(I18n.tr("If you are running the latest version of JOSM and the plugins, please file a bug report in our bugtracker.\nThere the error information should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.", new Object[0]));
        helpText.setMaxWidth(500);
        panel.add((Component)helpText, GBC.eop().fill(2));
        Component settings = GBC.glue(0, 0);
        if (ExpertToggleAction.isExpert()) {
            settings = new BugReportSettingsPanel(this.report);
        }
        panel.add(settings);
        JButton sendBugReportButton = new JButton(I18n.tr("Report Bug", new Object[0]), ImageProvider.get("bug"));
        sendBugReportButton.addActionListener(e -> this.sendBug());
        panel.add((Component)sendBugReportButton, GBC.eol().insets(0, 0, 0, 0).anchor(14));
        this.content.add((Component)panel, GBC.eop().fill(2));
    }

    private static void addBorder(JPanel panel, String title) {
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    private void addIgnoreButton() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.cbSuppressSingle = new JCheckBox(I18n.tr("Suppress this error for this session.", new Object[0]));
        this.cbSuppressSingle.setVisible(false);
        panel.add((Component)this.cbSuppressSingle, GBC.std(0, 0).fill(2));
        this.cbSuppressAll = new JCheckBox(I18n.tr("Suppress further error dialogs for this session.", new Object[0]));
        this.cbSuppressAll.setVisible(false);
        panel.add((Component)this.cbSuppressAll, GBC.std(0, 1).fill(2));
        JButton ignore = new JButton(I18n.tr("Ignore this error.", new Object[0]));
        ignore.addActionListener(e -> this.closeDialog());
        panel.add((Component)ignore, GBC.std(1, 0).span(1, 2).anchor(10));
        this.content.add((Component)panel, GBC.eol().fill(2).insets(0, 0, 10, 10));
    }

    public void setShowSuppress(boolean showSuppress) {
        this.cbSuppressSingle.setVisible(showSuppress);
        this.pack();
    }

    public void setShowSuppressAll(boolean showSuppress) {
        this.cbSuppressAll.setVisible(showSuppress);
        this.pack();
    }

    public BugReportQueue.SuppressionMode shouldSuppressFurtherErrors() {
        if (this.cbSuppressAll.isSelected()) {
            return BugReportQueue.SuppressionMode.ALL;
        }
        if (this.cbSuppressSingle.isSelected()) {
            return BugReportQueue.SuppressionMode.SAME;
        }
        return BugReportQueue.SuppressionMode.NONE;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void sendBug() {
        BugReportSender.reportBug(this.textPanel.getCodeText());
    }

    private static Frame findParent() {
        return (Frame)(Main.parent instanceof Frame ? Main.parent : SwingUtilities.getAncestorOfClass(Frame.class, Main.parent));
    }

    public static BugReportQueue.SuppressionMode showFor(ReportedException e, int exceptionCounter) {
        if (e.isOutOfMemory()) {
            JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
            return BugReportQueue.SuppressionMode.NONE;
        }
        return GuiHelper.runInEDTAndWaitAndReturn(() -> {
            PluginDownloadTask downloadTask = PluginHandler.updateOrdisablePluginAfterException(e);
            if (downloadTask != null) {
                PluginPreference.notifyDownloadResults(Main.parent, downloadTask, !downloadTask.getDownloadedPlugins().isEmpty());
                return BugReportQueue.SuppressionMode.NONE;
            }
            BugReport report = new BugReport(e);
            BugReportDialog dialog = new BugReportDialog(report);
            dialog.setShowSuppress(exceptionCounter > 0);
            dialog.setShowSuppressAll(exceptionCounter > 1);
            dialog.setVisible(true);
            return dialog.shouldSuppressFurtherErrors();
        });
    }
}

