/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AccessTokenInfoPanel;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.oauth.OsmPrivilegesPanel;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DefaultTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class FullyAutomaticAuthorizationUI
extends AbstractAuthorizationUI {
    private final JosmTextField tfUserName = new JosmTextField();
    private final JosmPasswordField tfPassword = new JosmPasswordField();
    private transient UserNameValidator valUserName;
    private transient PasswordValidator valPassword;
    private final AccessTokenInfoPanel pnlAccessTokenInfo = new AccessTokenInfoPanel();
    private OsmPrivilegesPanel pnlOsmPrivileges;
    private JPanel pnlPropertiesPanel;
    private JPanel pnlActionButtonsPanel;
    private JPanel pnlResult;
    private final transient Executor executor;

    protected VerticallyScrollablePanel buildGrantsPanel() {
        this.pnlOsmPrivileges = new OsmPrivilegesPanel();
        return this.pnlOsmPrivileges;
    }

    protected VerticallyScrollablePanel buildUserNamePasswordPanel() {
        VerticallyScrollablePanel pnl = new VerticallyScrollablePanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:#DDFFDD; padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        kit.getStyleSheet().addRule("ol {margin-left: 1cm}");
        pnlMessage.setText("<html><body><p class=\"warning-body\">" + I18n.tr("Please enter your OSM user name and password. The password will <strong>not</strong> be saved in clear text in the JOSM preferences and it will be submitted to the OSM server <strong>only once</strong>. Subsequent data upload requests don''t use your password any more.", new Object[0]) + "</p></body></html>");
        pnl.add((Component)pnlMessage, gc);
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        pnl.add((Component)new JLabel(I18n.tr("Username: ", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfUserName, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
        this.valUserName = new UserNameValidator(this.tfUserName);
        this.valUserName.validate();
        gc.anchor = 18;
        gc.fill = 2;
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password: ", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfPassword, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfPassword);
        this.valPassword = new PasswordValidator(this.tfPassword);
        this.valPassword.validate();
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildPropertiesPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTabbedPane tpProperties = new JTabbedPane();
        tpProperties.add(this.buildUserNamePasswordPanel().getVerticalScrollPane());
        tpProperties.add(this.buildGrantsPanel().getVerticalScrollPane());
        tpProperties.add(this.getAdvancedPropertiesPanel().getVerticalScrollPane());
        tpProperties.setTitleAt(0, I18n.tr("Basic", new Object[0]));
        tpProperties.setTitleAt(1, I18n.tr("Granted rights", new Object[0]));
        tpProperties.setTitleAt(2, I18n.tr("Advanced OAuth properties", new Object[0]));
        pnl.add((Component)tpProperties, "Center");
        return pnl;
    }

    @Override
    public void initialize(String paramApiUrl) {
        super.initialize(paramApiUrl);
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost());
            if (pa == null) {
                this.tfUserName.setText("");
                this.tfPassword.setText("");
            } else {
                this.tfUserName.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            this.tfUserName.setText("");
            this.tfPassword.setText("");
        }
    }

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        RunAuthorisationAction runAuthorisationAction = new RunAuthorisationAction();
        this.tfPassword.getDocument().addDocumentListener(runAuthorisationAction);
        this.tfUserName.getDocument().addDocumentListener(runAuthorisationAction);
        pnl.add(new JButton(runAuthorisationAction));
        return pnl;
    }

    protected JPanel buildResultsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        JMultilineLabel msg = new JMultilineLabel("");
        msg.setFont(msg.getFont().deriveFont(0));
        String lbl = I18n.tr("Accept Access Token", new Object[0]);
        msg.setText(I18n.tr("<html>You have successfully retrieved an OAuth Access Token from the OSM website. Click on <strong>{0}</strong> to accept the token. JOSM will use it in subsequent requests to gain access to the OSM API.</html>", lbl));
        pnl.add((Component)msg, gc);
        gc.gridy = 1;
        gc.insets = new Insets(5, 0, 0, 0);
        pnl.add((Component)this.pnlAccessTokenInfo, gc);
        JPanel pnl1 = new JPanel(new FlowLayout(0));
        pnl1.add(new JButton(new BackAction()));
        pnl1.add(new JButton(new TestAccessTokenAction()));
        gc.gridy = 2;
        pnl.add((Component)pnl1, gc);
        gc.gridy = 3;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.pnlPropertiesPanel = this.buildPropertiesPanel();
        this.pnlActionButtonsPanel = this.buildActionButtonPanel();
        this.pnlResult = this.buildResultsPanel();
        this.prepareUIForEnteringRequest();
    }

    protected void prepareUIForEnteringRequest() {
        this.removeAll();
        this.add((Component)this.pnlPropertiesPanel, "Center");
        this.add((Component)this.pnlActionButtonsPanel, "South");
        this.pnlPropertiesPanel.revalidate();
        this.pnlActionButtonsPanel.revalidate();
        this.validate();
        this.repaint();
        this.setAccessToken(null);
    }

    protected void prepareUIForResultDisplay() {
        this.removeAll();
        this.add((Component)this.pnlResult, "Center");
        this.validate();
        this.repaint();
    }

    protected String getOsmUserName() {
        return this.tfUserName.getText();
    }

    protected String getOsmPassword() {
        return String.valueOf(this.tfPassword.getPassword());
    }

    public FullyAutomaticAuthorizationUI(String apiUrl, Executor executor) {
        super(apiUrl);
        this.executor = executor;
        this.build();
    }

    @Override
    public boolean isSaveAccessTokenToPreferences() {
        return this.pnlAccessTokenInfo.isSaveToPreferences();
    }

    @Override
    protected void setAccessToken(OAuthToken accessToken) {
        super.setAccessToken(accessToken);
        this.pnlAccessTokenInfo.setAccessToken(accessToken);
    }

    class FullyAutomaticAuthorisationTask
    extends PleaseWaitRunnable {
        private boolean canceled;

        FullyAutomaticAuthorisationTask(Component parent) {
            super(parent, I18n.tr("Authorize JOSM to access the OSM API", new Object[0]), false);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertAuthorisationFailed() {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed.<br><br>Please try again or choose another kind of authorization process,<br>i.e. semi-automatic or manual authorization.</html>", new Object[0]), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertInvalidLoginUrl() {
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed because JOSM was not able to build<br>a valid login URL from the OAuth Authorize Endpoint URL ''{0}''.<br><br>Please check your advanced setting and try again.</html>", FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getAuthoriseUrl()), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void alertLoginFailed() {
            String loginUrl = FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getOsmLoginUrl();
            HelpAwareOptionPane.showOptionDialog(FullyAutomaticAuthorizationUI.this, I18n.tr("<html>The automatic process for retrieving an OAuth Access Token<br>from the OSM server failed. JOSM failed to log into {0}<br>for user {1}.<br><br>Please check username and password and try again.</html>", loginUrl, Utils.escapeReservedCharactersHTML(FullyAutomaticAuthorizationUI.this.getOsmUserName())), I18n.tr("OAuth authorization failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#FullyAutomaticProcessFailed"));
        }

        protected void handleException(OsmOAuthAuthorizationException e) {
            Runnable r = () -> {
                if (e instanceof OsmLoginFailedException) {
                    this.alertLoginFailed();
                } else {
                    this.alertAuthorisationFailed();
                }
            };
            Logging.error(e);
            GuiHelper.runInEDT(r);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.getProgressMonitor().setTicksCount(3);
                OsmOAuthAuthorizationClient authClient = new OsmOAuthAuthorizationClient(FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters());
                OAuthToken requestToken = authClient.getRequestToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                authClient.authorise(requestToken, FullyAutomaticAuthorizationUI.this.getOsmUserName(), FullyAutomaticAuthorizationUI.this.getOsmPassword(), FullyAutomaticAuthorizationUI.this.pnlOsmPrivileges.getPrivileges(), this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                OAuthToken accessToken = authClient.getAccessToken(this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
                GuiHelper.runInEDT(() -> {
                    FullyAutomaticAuthorizationUI.this.prepareUIForResultDisplay();
                    FullyAutomaticAuthorizationUI.this.setAccessToken(accessToken);
                });
            }
            catch (OsmOAuthAuthorizationException e) {
                this.handleException(e);
            }
        }
    }

    static class PasswordValidator
    extends DefaultTextComponentValidator {
        PasswordValidator(JTextComponent tc) {
            super(tc, I18n.tr("Please enter your OSM password", new Object[0]), I18n.tr("The password cannot be empty. Please enter your OSM password", new Object[0]));
        }
    }

    class TestAccessTokenAction
    extends AbstractAction {
        TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            new ImageProvider("logo").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FullyAutomaticAuthorizationUI.this.executor.execute(new TestAccessTokenTask(FullyAutomaticAuthorizationUI.this, FullyAutomaticAuthorizationUI.this.getApiUrl(), FullyAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), FullyAutomaticAuthorizationUI.this.getAccessToken()));
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
            this.putValue("Name", I18n.tr("Back", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Run the automatic authorization steps again", new Object[0]));
            new ImageProvider("dialogs", "previous").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FullyAutomaticAuthorizationUI.this.prepareUIForEnteringRequest();
        }
    }

    class RunAuthorisationAction
    extends AbstractAction
    implements DocumentListener {
        RunAuthorisationAction() {
            this.putValue("Name", I18n.tr("Authorize now", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to redirect you to the authorization form on the JOSM web site", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FullyAutomaticAuthorizationUI.this.executor.execute(new FullyAutomaticAuthorisationTask(FullyAutomaticAuthorizationUI.this));
        }

        protected final void updateEnabledState() {
            this.setEnabled(FullyAutomaticAuthorizationUI.this.valPassword.isValid() && FullyAutomaticAuthorizationUI.this.valUserName.isValid());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }
}

