/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.project.ProjectBuildingException;

public class InvalidProjectVersionException
extends ProjectBuildingException {
    private final String locationInPom;
    private final String offendingVersion;

    public InvalidProjectVersionException(String projectId, String locationInPom, String offendingVersion, File pomFile, InvalidVersionSpecificationException cause) {
        super(projectId, InvalidProjectVersionException.formatMessage(projectId, locationInPom, offendingVersion, cause), pomFile, (Throwable)cause);
        this.locationInPom = locationInPom;
        this.offendingVersion = offendingVersion;
    }

    private static String formatMessage(String projectId, String locationInPom, String offendingVersion, InvalidVersionSpecificationException cause) {
        return "Invalid version: " + offendingVersion + " found for: " + locationInPom + " in project: " + projectId + ". Reason: " + cause.getMessage();
    }

    public String getOffendingVersion() {
        return this.offendingVersion;
    }

    public String getLocationInPom() {
        return this.locationInPom;
    }
}

