/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplPlain
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final String literal;
    @Nonnull
    private final String lang;

    public OWLLiteralImplPlain(@Nonnull String literal, @Nullable String lang) {
        this.literal = literal;
        this.lang = lang == null || lang.length() == 0 ? "" : lang;
        this.hashCode = this.getHashCode();
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add(RDF_PLAIN_LITERAL);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    protected int index() {
        return 4008;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean hasLang() {
        return !this.lang.equals("");
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return true;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean parseBoolean() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a boolean value");
    }

    @Override
    public double parseDouble() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a double value");
    }

    @Override
    public float parseFloat() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a float value");
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(String l) {
        if (l == null) {
            return this.lang.isEmpty();
        }
        return this.lang.equalsIgnoreCase(l.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode() {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code *= 37;
        try {
            code = this.isInteger() ? (code += this.parseInteger() * 65536) : (this.isDouble() ? (code += (int)this.parseDouble() * 65536) : (this.isFloat() ? (code += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (code += this.parseBoolean() ? 65536 : 0) : (code += this.getLiteral().hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            code += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        if (other instanceof OWLLiteralImplPlain) {
            return this.literal.equals(((OWLLiteralImplPlain)other).literal) && this.lang.equals(other.getLang());
        }
        return this.getLiteral().equals(other.getLiteral()) && this.getDatatype().equals(other.getDatatype()) && this.lang.equals(other.getLang());
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.getDatatype().compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

