/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockFragmentWrapper;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BlockUtil {
    private BlockUtil() {
    }

    public static List<DataLanguageBlockWrapper> buildChildWrappers(@NotNull Block parent) {
        if (parent == null) {
            BlockUtil.$$$reportNull$$$0(0);
        }
        assert (!(parent instanceof DataLanguageBlockWrapper)) : parent.getClass();
        List children2 = parent.getSubBlocks();
        if (children2.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataLanguageBlockWrapper> result2 = new ArrayList<DataLanguageBlockWrapper>(children2.size());
        DataLanguageBlockWrapper prevWrapper = null;
        for (Block child : children2) {
            DataLanguageBlockWrapper currWrapper = BlockUtil.createAndAddBlock(result2, child, null);
            if (currWrapper != null && prevWrapper != null) {
                Spacing spacing = parent.getSpacing(prevWrapper.getOriginal(), currWrapper.getOriginal());
                prevWrapper.setRightHandSpacing(currWrapper, spacing);
            }
            prevWrapper = currWrapper;
        }
        return result2;
    }

    public static Pair<List<DataLanguageBlockWrapper>, List<DataLanguageBlockWrapper>> splitBlocksByRightBound(@NotNull Block parent, @NotNull TextRange bounds) {
        List subBlocks;
        if (parent == null) {
            BlockUtil.$$$reportNull$$$0(1);
        }
        if (bounds == null) {
            BlockUtil.$$$reportNull$$$0(2);
        }
        if ((subBlocks = parent.getSubBlocks()).size() == 0) {
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<DataLanguageBlockWrapper> before = new ArrayList<DataLanguageBlockWrapper>(subBlocks.size() / 2);
        ArrayList<DataLanguageBlockWrapper> after = new ArrayList<DataLanguageBlockWrapper>(subBlocks.size() / 2);
        BlockUtil.splitByRightBoundAndCollectBlocks(subBlocks, before, after, bounds);
        return new Pair(before, after);
    }

    private static void splitByRightBoundAndCollectBlocks(@NotNull List<Block> blocks, @NotNull List<DataLanguageBlockWrapper> before, @NotNull List<DataLanguageBlockWrapper> after, @NotNull TextRange bounds) {
        if (blocks == null) {
            BlockUtil.$$$reportNull$$$0(3);
        }
        if (before == null) {
            BlockUtil.$$$reportNull$$$0(4);
        }
        if (after == null) {
            BlockUtil.$$$reportNull$$$0(5);
        }
        if (bounds == null) {
            BlockUtil.$$$reportNull$$$0(6);
        }
        for (Block block : blocks) {
            TextRange textRange = block.getTextRange();
            if (bounds.contains(textRange)) {
                BlockUtil.createAndAddBlock(before, block, null);
                continue;
            }
            if (bounds.getEndOffset() <= textRange.getStartOffset()) {
                BlockUtil.createAndAddBlock(after, block, null);
                continue;
            }
            BlockUtil.splitByRightBoundAndCollectBlocks(block.getSubBlocks(), before, after, bounds);
        }
    }

    @Nullable
    private static DataLanguageBlockWrapper createAndAddBlock(List<DataLanguageBlockWrapper> list2, Block block, @Nullable Indent indent) {
        DataLanguageBlockWrapper wrapper2 = DataLanguageBlockWrapper.create(block, indent);
        if (wrapper2 != null) {
            list2.add(wrapper2);
        }
        return wrapper2;
    }

    public static List<Block> mergeBlocks(@NotNull List<TemplateLanguageBlock> tlBlocks, @NotNull List<DataLanguageBlockWrapper> foreignBlocks) {
        if (tlBlocks == null) {
            BlockUtil.$$$reportNull$$$0(7);
        }
        if (foreignBlocks == null) {
            BlockUtil.$$$reportNull$$$0(8);
        }
        ArrayList<Block> result2 = new ArrayList<Block>(tlBlocks.size() + foreignBlocks.size());
        int vInd = 0;
        int fInd = 0;
        while (vInd < tlBlocks.size() && fInd < foreignBlocks.size()) {
            int lastContainedTlInd;
            TemplateLanguageBlock v = tlBlocks.get(vInd);
            DataLanguageBlockWrapper f = foreignBlocks.get(fInd);
            TextRange vRange = v.getTextRange();
            TextRange fRange = f.getTextRange();
            if (vRange.getStartOffset() >= fRange.getEndOffset()) {
                result2.add(f);
                ++fInd;
                continue;
            }
            if (vRange.getEndOffset() <= fRange.getStartOffset()) {
                result2.add((Block)v);
                ++vInd;
                continue;
            }
            if (vRange.getStartOffset() < fRange.getStartOffset() || vRange.getStartOffset() == fRange.getStartOffset() && vRange.getEndOffset() >= fRange.getEndOffset()) {
                DataLanguageBlockWrapper notContainedF;
                result2.add((Block)v);
                while (fInd < foreignBlocks.size() && vRange.contains(foreignBlocks.get(fInd).getTextRange())) {
                    v.addForeignChild(foreignBlocks.get(fInd++));
                }
                if (fInd < foreignBlocks.size() && vRange.intersectsStrict((notContainedF = foreignBlocks.get(fInd)).getTextRange())) {
                    Pair<List<DataLanguageBlockWrapper>, List<DataLanguageBlockWrapper>> splitBlocks = BlockUtil.splitBlocksByRightBound(notContainedF.getOriginal(), vRange);
                    v.addForeignChildren((List)splitBlocks.getFirst());
                    foreignBlocks.remove(fInd);
                    if (((List)splitBlocks.getSecond()).size() > 0) {
                        foreignBlocks.addAll(fInd, (Collection)splitBlocks.getSecond());
                    }
                }
                ++vInd;
                continue;
            }
            if (vRange.getStartOffset() <= fRange.getStartOffset() && (vRange.getStartOffset() != fRange.getStartOffset() || vRange.getEndOffset() >= fRange.getEndOffset())) continue;
            for (lastContainedTlInd = vInd; lastContainedTlInd < tlBlocks.size() && fRange.intersectsStrict(tlBlocks.get(lastContainedTlInd).getTextRange()); ++lastContainedTlInd) {
            }
            if (fRange.contains(tlBlocks.get(lastContainedTlInd - 1).getTextRange())) {
                result2.add(f);
                ++fInd;
                while (vInd < lastContainedTlInd) {
                    f.addTlChild(tlBlocks.get(vInd++));
                }
                continue;
            }
            foreignBlocks.remove(fInd);
            foreignBlocks.addAll(fInd, BlockUtil.buildChildWrappers(f.getOriginal()));
        }
        while (vInd < tlBlocks.size()) {
            result2.add((Block)tlBlocks.get(vInd++));
        }
        while (fInd < foreignBlocks.size()) {
            result2.add(foreignBlocks.get(fInd++));
        }
        return result2;
    }

    @NotNull
    public static List<DataLanguageBlockWrapper> filterBlocksByRange(@NotNull List<DataLanguageBlockWrapper> list2, @NotNull TextRange textRange) {
        if (list2 == null) {
            BlockUtil.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            BlockUtil.$$$reportNull$$$0(10);
        }
        int i = 0;
        while (i < list2.size()) {
            DataLanguageBlockWrapper wrapper2 = list2.get(i);
            TextRange range = wrapper2.getTextRange();
            if (textRange.contains(range)) {
                ++i;
                continue;
            }
            if (range.intersectsStrict(textRange)) {
                list2.remove(i);
                list2.addAll(i, BlockUtil.buildChildWrappers(wrapper2.getOriginal()));
                continue;
            }
            list2.remove(i);
        }
        List<DataLanguageBlockWrapper> list3 = list2;
        if (list3 == null) {
            BlockUtil.$$$reportNull$$$0(11);
        }
        return list3;
    }

    static List<Block> splitBlockIntoFragments(@NotNull Block block, @NotNull List<TemplateLanguageBlock> subBlocks) {
        if (block == null) {
            BlockUtil.$$$reportNull$$$0(12);
        }
        if (subBlocks == null) {
            BlockUtil.$$$reportNull$$$0(13);
        }
        ArrayList<Block> children2 = new ArrayList<Block>(5);
        TextRange range = block.getTextRange();
        int childStartOffset = range.getStartOffset();
        TemplateLanguageBlock lastTLBlock = null;
        for (TemplateLanguageBlock tlBlock : subBlocks) {
            TextRange dataBlockTextRange;
            TextRange tlTextRange = tlBlock.getTextRange();
            if (tlTextRange.getStartOffset() > childStartOffset && tlBlock.isRequiredRange(dataBlockTextRange = new TextRange(childStartOffset, tlTextRange.getStartOffset()))) {
                children2.add(new DataLanguageBlockFragmentWrapper(block, dataBlockTextRange));
            }
            children2.add((Block)tlBlock);
            lastTLBlock = tlBlock;
            childStartOffset = tlTextRange.getEndOffset();
        }
        if (range.getEndOffset() > childStartOffset) {
            TextRange dataBlockTextRange = new TextRange(childStartOffset, range.getEndOffset());
            if (lastTLBlock == null || lastTLBlock.isRequiredRange(dataBlockTextRange)) {
                children2.add(new DataLanguageBlockFragmentWrapper(block, dataBlockTextRange));
            }
        }
        return children2;
    }

    static void printBlocks(@Nullable TextRange textRange, @NotNull List<Block> list2) {
        if (list2 == null) {
            BlockUtil.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder(String.valueOf(textRange)).append(": ");
        for (Block block : list2) {
            ASTNode node = block instanceof ASTBlock ? ((ASTBlock)block).getNode() : null;
            TextRange r = block.getTextRange();
            sb.append(" [").append(node != null ? node.getElementType() : null).append(r).append(block.getIndent()).append(block.getAlignment()).append("] ");
        }
        System.out.println(sb);
    }

    static List<Block> setParent(List<Block> children2, BlockWithParent parent) {
        for (Block block : children2) {
            if (!(block instanceof BlockWithParent)) continue;
            ((BlockWithParent)block).setParent(parent);
        }
        return children2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tlBlocks";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreignBlocks";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/templateLanguages/BlockUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/templateLanguages/BlockUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBlocksByRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildWrappers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitBlocksByRightBound";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitByRightBoundAndCollectBlocks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeBlocks";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterBlocksByRange";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitBlockIntoFragments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printBlocks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

