/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseAllEditorsButActiveAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] siblings;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            window.closeAllExcept((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        for (VirtualFile sibling : siblings = fileEditorManager.getSiblings(selectedFile)) {
            if (Comparing.equal((Object)selectedFile, (Object)sibling)) continue;
            fileEditorManager.closeFile(sibling);
        }
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (window != null) {
            presentation.setEnabled(window.getFiles().length > 1);
            return;
        }
        if (fileEditorManager.getSelectedFiles().length == 0) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
        VirtualFile[] siblings = fileEditorManager.getSiblings(selectedFile);
        presentation.setEnabled(siblings.length > 1);
    }
}

