/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
implements StructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    @Nullable
    private Language myTemplateDataLanguage;
    private StructureViewComposite.StructureViewDescriptor myBaseStructureViewDescriptor;
    private FileEditor myFileEditor;
    private StructureViewComposite myStructureViewComposite;
    private int myBaseLanguageViewDescriptorIndex;

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
        this.myProject = psiElement.getProject();
        this.myTemplateDataLanguage = this.getTemplateDataLanguage();
    }

    private void updateAfterPsiChange() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (this.myBaseStructureViewDescriptor != null && ((StructureViewComponent)this.myBaseStructureViewDescriptor.structureView).isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.myVirtualFile.isValid() || this.getViewProvider() == null) {
                return;
            }
            StructureViewWrapper structureViewWrapper = StructureViewFactoryEx.getInstanceEx(this.myProject).getStructureViewWrapper();
            if (structureViewWrapper == null) {
                return;
            }
            Language baseLanguage = this.getTemplateDataLanguage();
            if (baseLanguage == this.myTemplateDataLanguage && (this.myBaseStructureViewDescriptor == null || TemplateLanguageStructureViewBuilder.isPsiValid(this.myBaseStructureViewDescriptor))) {
                this.updateBaseLanguageView();
            } else {
                this.myTemplateDataLanguage = baseLanguage;
                ((StructureViewWrapperImpl)structureViewWrapper).rebuild();
            }
        });
    }

    private static boolean isPsiValid(@NotNull StructureViewComposite.StructureViewDescriptor baseStructureViewDescriptor) {
        StructureViewComponent view;
        if (baseStructureViewDescriptor == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(0);
        }
        if ((view = (StructureViewComponent)baseStructureViewDescriptor.structureView).isDisposed()) {
            return false;
        }
        Object value = StructureViewComponent.unwrapValue(view.getTree().getModel().getRoot());
        return !(value instanceof PsiElement) || ((PsiElement)value).isValid();
    }

    @Nullable
    private FileViewProvider getViewProvider() {
        return PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myVirtualFile);
    }

    @Nullable
    private Language getTemplateDataLanguage() {
        FileViewProvider provider = this.getViewProvider();
        return provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : null;
    }

    private void updateBaseLanguageView() {
        if (this.myBaseStructureViewDescriptor == null || !this.myProject.isOpen()) {
            return;
        }
        StructureViewComponent view = (StructureViewComponent)this.myBaseStructureViewDescriptor.structureView;
        if (view.isDisposed()) {
            return;
        }
        TreeState treeState = TreeState.createOn((JTree)view.getTree(), (TreePath)new TreePath(view.getTree().getModel().getRoot()));
        this.updateTemplateDataFileView();
        if (view.isDisposed()) {
            return;
        }
        treeState.applyTo(view.getTree());
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(1);
        }
        this.myFileEditor = fileEditor;
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        FileViewProvider provider = this.getViewProvider();
        assert (provider != null) : this.myVirtualFile;
        StructureViewComposite.StructureViewDescriptor structureViewDescriptor = this.createMainView(fileEditor, provider.getPsi(provider.getBaseLanguage()));
        if (structureViewDescriptor != null) {
            viewDescriptors.add(structureViewDescriptor);
        }
        this.myBaseLanguageViewDescriptorIndex = -1;
        this.updateTemplateDataFileView();
        if (this.myBaseStructureViewDescriptor != null) {
            viewDescriptors.add(this.myBaseStructureViewDescriptor);
            this.myBaseLanguageViewDescriptorIndex = viewDescriptors.size() - 1;
        }
        if (provider instanceof TemplateLanguageFileViewProvider) {
            Language dataLanguage = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            for (Language language : provider.getLanguages()) {
                if (language == dataLanguage || language == provider.getBaseLanguage()) continue;
                ContainerUtil.addIfNotNull(viewDescriptors, (Object)this.createBaseLanguageStructureView(fileEditor, language));
            }
        }
        StructureViewComposite.StructureViewDescriptor[] array = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[viewDescriptors.size()]);
        this.myStructureViewComposite = new StructureViewComposite(array);
        project.getMessageBus().connect((Disposable)this.myStructureViewComposite).subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
            final Alarm alarm;
            {
                this.alarm = new Alarm((Disposable)TemplateLanguageStructureViewBuilder.this.myStructureViewComposite);
            }

            public void modificationCountChanged() {
                this.alarm.cancelAllRequests();
                this.alarm.addRequest(() -> TemplateLanguageStructureViewBuilder.this.updateAfterPsiChange(), 300, ModalityState.NON_MODAL);
            }
        });
        StructureViewComposite structureViewComposite = this.myStructureViewComposite;
        if (structureViewComposite == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(2);
        }
        return structureViewComposite;
    }

    protected abstract StructureViewComposite.StructureViewDescriptor createMainView(FileEditor var1, PsiFile var2);

    @Nullable
    private StructureViewComposite.StructureViewDescriptor createBaseLanguageStructureView(FileEditor fileEditor, Language language) {
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider == null) {
            return null;
        }
        PsiFile dataFile = viewProvider.getPsi(language);
        if (dataFile == null || !this.isAcceptableBaseLanguageFile(dataFile)) {
            return null;
        }
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        if (factory == null) {
            return null;
        }
        StructureViewBuilder builder = factory.getStructureViewBuilder(dataFile);
        if (builder == null) {
            return null;
        }
        StructureView structureView = builder.createStructureView(fileEditor, this.myProject);
        return new StructureViewComposite.StructureViewDescriptor(IdeBundle.message((String)"tab.structureview.baselanguage.view", (Object[])new Object[]{language.getDisplayName()}), structureView, TemplateLanguageStructureViewBuilder.findFileType(language).getIcon());
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    private void updateTemplateDataFileView() {
        Language newDataLanguage = this.getTemplateDataLanguage();
        if (this.myBaseStructureViewDescriptor != null) {
            if (this.myTemplateDataLanguage == newDataLanguage) {
                return;
            }
            Disposer.dispose((Disposable)this.myBaseStructureViewDescriptor.structureView);
        }
        if (newDataLanguage != null) {
            this.myBaseStructureViewDescriptor = this.createBaseLanguageStructureView(this.myFileEditor, newDataLanguage);
            if (this.myStructureViewComposite != null) {
                this.myStructureViewComposite.setStructureView(this.myBaseLanguageViewDescriptorIndex, this.myBaseStructureViewDescriptor);
            }
        }
    }

    @NotNull
    private static FileType findFileType(Language language) {
        FileType[] registeredFileTypes;
        for (FileType fileType : registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != language) continue;
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(3);
            }
            return fileType2;
        }
        FileType fileType = FileTypes.UNKNOWN;
        if (fileType == null) {
            TemplateLanguageStructureViewBuilder.$$$reportNull$$$0(4);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStructureViewDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureView";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPsiValid";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

