/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
Comparator<Object>,
DumbAware {
    private static final Pattern INNER_GROUP_WITH_IDS = Pattern.compile("(.*) \\(\\d+\\)");
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    @Nullable
    private final Editor myEditor;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    protected final Map<AnAction, String> myActionGroups = ContainerUtil.newHashMap();
    private final NotNullLazyValue<Map<String, String>> myConfigurablesNames = VolatileNotNullLazyValue.createValue(() -> {
        THashMap map2 = ContainerUtil.newTroveMap();
        for (Configurable configurable : ShowSettingsUtilImpl.getConfigurables(this.getProject(), true)) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            map2.put(((SearchableConfigurable)configurable).getId(), configurable.getDisplayName());
        }
        return map2;
    });
    private final ModalityState myModality;

    public GotoActionModel(@Nullable Project project, Component component, @Nullable Editor editor) {
        this(project, component, editor, ModalityState.defaultModalityState());
    }

    public GotoActionModel(@Nullable Project project, Component component, @Nullable Editor editor, @Nullable ModalityState modalityState) {
        this.myProject = project;
        this.myContextComponent = component;
        this.myEditor = editor;
        this.myModality = modalityState;
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        assert (mainMenu != null);
        this.collectActions(this.myActionGroups, mainMenu, mainMenu.getTemplatePresentation().getText());
    }

    @NotNull
    Map<String, ApplyIntentionAction> getAvailableIntentions() {
        TreeMap<String, ApplyIntentionAction> map2 = new TreeMap<String, ApplyIntentionAction>();
        if (this.myProject != null && !this.myProject.isDisposed() && this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplyIntentionAction[] children2;
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            ApplyIntentionAction[] applyIntentionActionArray = children2 = file2 == null ? null : ApplyIntentionAction.getAvailableIntentions(this.myEditor, file2);
            if (children2 != null) {
                for (ApplyIntentionAction action : children2) {
                    map2.put(action.getName(), action);
                }
            }
        }
        TreeMap<String, ApplyIntentionAction> treeMap = map2;
        if (treeMap == null) {
            GotoActionModel.$$$reportNull$$$0(0);
        }
        return treeMap;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    @Nullable
    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return 'd';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.enabled.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        return false;
    }

    public void saveInitialCheckBoxState(boolean state2) {
    }

    public ListCellRenderer getListCellRenderer() {
        return new GotoActionListCellRenderer((Function<OptionDescription, String>)((Function)this::getGroupName));
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(1);
        }
        return this.myActionManager.getId(anAction);
    }

    @NotNull
    private static JLabel createIconLabel(@Nullable Icon icon, boolean disabled) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon == null) {
            JLabel jLabel = new JLabel((Icon)layeredIcon);
            if (jLabel == null) {
                GotoActionModel.$$$reportNull$$$0(2);
            }
            return jLabel;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int emptyIconWidth = EMPTY_ICON.getIconWidth();
        int emptyIconHeight = EMPTY_ICON.getIconHeight();
        if (width <= emptyIconWidth && height <= emptyIconHeight) {
            layeredIcon.setIcon(disabled ? IconLoader.getDisabledIcon((Icon)icon) : icon, 1, (emptyIconWidth - width) / 2, (emptyIconHeight - height) / 2);
        }
        JLabel jLabel = new JLabel((Icon)layeredIcon);
        if (jLabel == null) {
            GotoActionModel.$$$reportNull$$$0(3);
        }
        return jLabel;
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            GotoActionModel.$$$reportNull$$$0(4);
        }
        if (o2 == null) {
            GotoActionModel.$$$reportNull$$$0(5);
        }
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareTo((MatchedValue)o2);
    }

    @NotNull
    public static AnActionEvent updateActionBeforeShow(@NotNull AnAction anAction, @NotNull DataContext dataContext) {
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            GotoActionModel.$$$reportNull$$$0(7);
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", null, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)false);
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null) {
            GotoActionModel.$$$reportNull$$$0(8);
        }
        return anActionEvent;
    }

    public static Color defaultActionForeground(boolean isSelected, @Nullable Presentation presentation) {
        if (!(presentation == null || presentation.isEnabled() && presentation.isVisible())) {
            return UIUtil.getInactiveTextColor();
        }
        if (isSelected) {
            return UIUtil.getListSelectionForeground();
        }
        return UIUtil.getListForeground();
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(9);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(10);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getGroupName(@NotNull OptionDescription description) {
        String settings;
        String name;
        if (description == null) {
            GotoActionModel.$$$reportNull$$$0(11);
        }
        if ((name = description.getGroupName()) == null) {
            name = (String)((Map)this.myConfigurablesNames.getValue()).get(description.getConfigurableId());
        }
        String string = settings = SystemInfo.isMac ? "Preferences" : "Settings";
        if (name == null || name.equals(description.getHit())) {
            String string2 = settings;
            if (string2 == null) {
                GotoActionModel.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String string3 = settings + " > " + name;
        if (string3 == null) {
            GotoActionModel.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    Map<String, String> getConfigurablesNames() {
        Map map2 = (Map)this.myConfigurablesNames.getValue();
        if (map2 == null) {
            GotoActionModel.$$$reportNull$$$0(14);
        }
        return map2;
    }

    private void collectActions(@NotNull Map<AnAction, String> result2, @NotNull ActionGroup group, @Nullable String containingGroupName) {
        if (result2 == null) {
            GotoActionModel.$$$reportNull$$$0(15);
        }
        if (group == null) {
            GotoActionModel.$$$reportNull$$$0(16);
        }
        AnAction[] actions = group.getChildren(null);
        this.includeGroup(result2, group, actions, containingGroupName);
        for (AnAction action : actions) {
            if (action == null || action instanceof Separator) continue;
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup;
                String groupName = (actionGroup = (ActionGroup)action).getTemplatePresentation().getText();
                this.collectActions(result2, actionGroup, GotoActionModel.getGroupName(StringUtil.isEmpty((String)groupName) || !actionGroup.isPopup() ? containingGroupName : groupName));
                continue;
            }
            String groupName = group.getTemplatePresentation().getText();
            if (result2.containsKey(action)) {
                result2.put(action, null);
                continue;
            }
            result2.put(action, GotoActionModel.getGroupName(StringUtil.isEmpty((String)groupName) ? containingGroupName : groupName));
        }
    }

    @Nullable
    private static String getGroupName(@Nullable String groupName) {
        Matcher matcher;
        if (groupName != null && (matcher = INNER_GROUP_WITH_IDS.matcher(groupName)).matches()) {
            return matcher.group(1);
        }
        return groupName;
    }

    private void includeGroup(@NotNull Map<AnAction, String> result2, @NotNull ActionGroup group, @NotNull AnAction[] actions, @Nullable String containingGroupName) {
        if (result2 == null) {
            GotoActionModel.$$$reportNull$$$0(17);
        }
        if (group == null) {
            GotoActionModel.$$$reportNull$$$0(18);
        }
        if (actions == null) {
            GotoActionModel.$$$reportNull$$$0(19);
        }
        boolean showGroup = true;
        for (AnAction action : actions) {
            if (this.myActionManager.getId(action) == null) continue;
            showGroup = false;
            break;
        }
        if (showGroup) {
            result2.put((AnAction)group, GotoActionModel.getGroupName(containingGroupName));
        }
    }

    @Nullable
    public String getFullName(@NotNull Object element) {
        if (element == null) {
            GotoActionModel.$$$reportNull$$$0(20);
        }
        return this.getElementName(element);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            GotoActionModel.$$$reportNull$$$0(21);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getElementName(@NotNull Object mv) {
        if (mv == null) {
            GotoActionModel.$$$reportNull$$$0(22);
        }
        return ((MatchedValue)mv).getValueText();
    }

    protected MatchMode actionMatches(@NotNull String pattern, MinusculeMatcher matcher, @NotNull AnAction anAction) {
        if (pattern == null) {
            GotoActionModel.$$$reportNull$$$0(23);
        }
        if (anAction == null) {
            GotoActionModel.$$$reportNull$$$0(24);
        }
        Presentation presentation = anAction.getTemplatePresentation();
        String text = presentation.getText();
        String description = presentation.getDescription();
        String groupName = this.myActionGroups.get(anAction);
        if (text != null && matcher.matches(text)) {
            return MatchMode.NAME;
        }
        if (description != null && !description.equals(text) && matcher.matches(description)) {
            return MatchMode.DESCRIPTION;
        }
        if (text == null) {
            return MatchMode.NONE;
        }
        if (matcher.matches(groupName + " " + text)) {
            return anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
        }
        return matcher.matches(text + " " + groupName) ? MatchMode.GROUP : MatchMode.NONE;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    public SortedSet<Object> sortItems(@NotNull Set<Object> elements) {
        if (elements == null) {
            GotoActionModel.$$$reportNull$$$0(25);
        }
        TreeSet objects = ContainerUtilRt.newTreeSet((Comparator)this);
        objects.addAll(elements);
        TreeSet treeSet = objects;
        if (treeSet == null) {
            GotoActionModel.$$$reportNull$$$0(26);
        }
        return treeSet;
    }

    private void updateOnEdt(Runnable update) {
        Semaphore semaphore = new Semaphore(1);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                update.run();
            }
            finally {
                semaphore.up();
            }
        }, this.myModality, __ -> indicator != null && indicator.isCanceled());
        while (!semaphore.waitFor(10L)) {
            if (indicator == null || !indicator.isCanceled()) continue;
            throw new ProcessCanceledException();
        }
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 1: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updateActionBeforeShow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurablesNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sortItems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateActionBeforeShow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectActions";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "includeGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "actionMatches";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        private final Function<OptionDescription, String> myGroupNamer;

        public GotoActionListCellRenderer(Function<OptionDescription, String> groupNamer) {
            this.myGroupNamer = groupNamer;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(0);
            }
            boolean showIcon = UISettings.getInstance().getShowIconsInMenus();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(JBUI.Borders.empty((int)2));
            panel2.setOpaque(true);
            Color bg = UIUtil.getListBackground((boolean)isSelected);
            panel2.setBackground(bg);
            SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            nameComponent.setBackground(bg);
            panel2.add((Component)nameComponent, "Center");
            if (matchedValue instanceof String) {
                nameComponent.append((String)matchedValue, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, null)));
                if (showIcon) {
                    panel2.add((Component)new JBLabel(EMPTY_ICON), "West");
                }
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    GotoActionListCellRenderer.$$$reportNull$$$0(1);
                }
                return jPanel;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getLabelDisabledForeground();
            Comparable value = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            JBEmptyBorder eastBorder = JBUI.Borders.emptyRight((int)2);
            if (value instanceof ActionWrapper) {
                boolean disabled;
                ActionWrapper actionWithParentGroup = (ActionWrapper)value;
                AnAction anAction = actionWithParentGroup.getAction();
                Presentation presentation = anAction.getTemplatePresentation();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Presentation actionPresentation = actionWithParentGroup.getPresentation();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, actionPresentation);
                boolean bl = disabled = actionPresentation != null && (!actionPresentation.isEnabled() || !actionPresentation.isVisible());
                if (disabled) {
                    groupFg = UIUtil.getLabelDisabledForeground();
                }
                if (showIcon) {
                    Icon icon = presentation.getIcon();
                    panel2.add((Component)GotoActionModel.createIconLabel(icon, disabled), "West");
                }
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, GotoActionListCellRenderer.getName(presentation.getText(), groupName, toggle), pattern, fg, isSelected);
                panel2.setToolTipText(presentation.getDescription());
                Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)ActionManager.getInstance().getId(anAction)).getShortcuts();
                String shortcutText = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
                if (StringUtil.isNotEmpty((String)shortcutText)) {
                    nameComponent.append(" " + shortcutText, new SimpleTextAttributes(129, UIUtil.isUnderDarcula() ? groupFg : ColorUtil.shift((Color)groupFg, (double)1.3)));
                }
                if (toggle) {
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((ActionWrapper)value).myDataContext);
                    boolean selected = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder((Border)eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel2.add((Component)groupLabel, "East");
                }
            } else if (value instanceof OptionDescription) {
                String hit;
                if (!isSelected && !(value instanceof BooleanOptionDescription)) {
                    Color descriptorBg = UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : LightColors.SLIGHTLY_GRAY;
                    panel2.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                if ((hit = ((OptionDescription)value).getHit()) == null) {
                    hit = ((OptionDescription)value).getOption();
                }
                hit = StringUtil.unescapeXml((String)hit);
                String fullHit = hit = hit.replace("  ", " ");
                hit = StringUtil.first((String)hit, (int)45, (boolean)true);
                Color fg = UIUtil.getListForeground((boolean)isSelected);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, hit.trim(), pattern, fg, isSelected);
                if (showIcon) {
                    panel2.add((Component)new JLabel(EMPTY_ICON), "West");
                }
                panel2.setToolTipText(fullHit);
                if (value instanceof BooleanOptionDescription) {
                    boolean selected = ((BooleanOptionDescription)value).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel2, selected);
                } else {
                    JLabel settingsLabel = new JLabel((String)this.myGroupNamer.fun((Object)((OptionDescription)value)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder((Border)eastBorder);
                    panel2.add((Component)settingsLabel, "East");
                }
            }
            JPanel jPanel = panel2;
            if (jPanel == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static void addOnOffButton(@NotNull JPanel panel2, boolean selected) {
            if (panel2 == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(3);
            }
            OnOffButton button = new OnOffButton();
            button.setSelected(selected);
            panel2.add((Component)button, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        }

        @NotNull
        private static String getName(@Nullable String text, @Nullable String groupName, boolean toggle) {
            String string = toggle && StringUtil.isNotEmpty((String)groupName) ? (StringUtil.isNotEmpty((String)text) ? groupName + ": " + text : groupName) : StringUtil.notNullize((String)text);
            if (string == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, @NotNull String name, @NotNull String pattern, Color fg, boolean selected) {
            int matchStart;
            if (name == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(5);
            }
            if (pattern == null) {
                GotoActionListCellRenderer.$$$reportNull$$$0(6);
            }
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(null, fg, null, 64);
            ArrayList fragments = ContainerUtil.newArrayList();
            if (selected && (matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0)) >= 0) {
                fragments.add(TextRange.from((int)matchStart, (int)pattern.length()));
            }
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, (Iterable)fragments, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addOnOffButton";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendWithColoredMatches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionWrapper
    implements Comparable<ActionWrapper> {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final String myGroupName;
        private final DataContext myDataContext;
        private final GotoActionModel myModel;
        private volatile Presentation myPresentation;

        public ActionWrapper(@NotNull AnAction action, @Nullable String groupName, @NotNull MatchMode mode, DataContext dataContext, GotoActionModel model) {
            if (action == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            this.myAction = action;
            this.myMode = mode;
            this.myGroupName = groupName;
            this.myDataContext = dataContext;
            this.myModel = model;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        public MatchMode getMode() {
            MatchMode matchMode = this.myMode;
            if (matchMode == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return matchMode;
        }

        @Override
        public int compareTo(@NotNull ActionWrapper o) {
            int compared;
            if (o == null) {
                ActionWrapper.$$$reportNull$$$0(4);
            }
            if ((compared = this.myMode.compareTo(o.getMode())) != 0) {
                return compared;
            }
            Presentation myPresentation = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o.getAction().getTemplatePresentation();
            String myText = myPresentation.getText();
            String oText = oPresentation.getText();
            int byText = StringUtil.compare((String)StringUtil.trimEnd((String)myText, (String)"..."), (String)StringUtil.trimEnd((String)oText, (String)"..."), (boolean)true);
            if (byText != 0) {
                return byText;
            }
            int byTextLength = StringUtil.notNullize((String)myText).length() - StringUtil.notNullize((String)oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byGroup = Comparing.compare((Comparable)((Object)this.myGroupName), (Comparable)((Object)o.myGroupName));
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare((String)myPresentation.getDescription(), (String)oPresentation.getDescription(), (boolean)true);
            if (byDesc != 0) {
                return byDesc;
            }
            return 0;
        }

        public boolean isAvailable() {
            Presentation presentation = this.getPresentation();
            return presentation != null && presentation.isEnabledAndVisible();
        }

        public Presentation getPresentation() {
            if (this.myPresentation != null) {
                return this.myPresentation;
            }
            Runnable r = () -> {
                this.myPresentation = GotoActionModel.updateActionBeforeShow(this.myAction, this.myDataContext).getPresentation();
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                r.run();
            } else {
                this.myModel.updateOnEdt(r);
            }
            return this.myPresentation;
        }

        private boolean hasPresentation() {
            return this.myPresentation != null;
        }

        @Nullable
        public String getGroupName() {
            if (this.myAction instanceof ActionGroup && Comparing.equal((String)this.myAction.getTemplatePresentation().getText(), (String)this.myGroupName)) {
                return null;
            }
            return this.myGroupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.compareTo((ActionWrapper)obj) == 0;
        }

        public int hashCode() {
            String text = this.myAction.getTemplatePresentation().getText();
            return text != null ? text.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum MatchMode {
        NONE,
        INTENTION,
        NAME,
        DESCRIPTION,
        GROUP,
        NON_MENU;

    }

    public static class MatchedValue
    implements Comparable<MatchedValue> {
        @NotNull
        public final Comparable value;
        @NotNull
        final String pattern;

        public MatchedValue(@NotNull Comparable value, @NotNull String pattern) {
            if (value == null) {
                MatchedValue.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                MatchedValue.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.pattern = pattern;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            if (this.value instanceof OptionDescription) {
                return ((OptionDescription)this.value).getHit();
            }
            if (!(this.value instanceof ActionWrapper)) {
                return null;
            }
            return ((ActionWrapper)this.value).getAction().getTemplatePresentation().getText();
        }

        @Nullable
        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        private int getMatchingDegree() {
            String text = this.getValueText();
            if (text != null) {
                int degree = this.getRank(text);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text) {
            if (text == null) {
                MatchedValue.$$$reportNull$$$0(2);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)StringUtil.trimEnd((String)text, (String)"..."), (CharSequence)this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase((String)text, (String)this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase((String)text, (String)this.pattern)) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(@NotNull MatchedValue o) {
            if (o == null) {
                MatchedValue.$$$reportNull$$$0(3);
            }
            if (o == this) {
                return 0;
            }
            int diff = o.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            boolean edt = ApplicationManager.getApplication().isDispatchThread();
            if (this.value instanceof ActionWrapper && o.value instanceof ActionWrapper) {
                int compared;
                if (edt || ((ActionWrapper)this.value).hasPresentation() && ((ActionWrapper)o.value).hasPresentation()) {
                    boolean p1Enable = ((ActionWrapper)this.value).isAvailable();
                    boolean p2enable = ((ActionWrapper)o.value).isAvailable();
                    if (p1Enable && !p2enable) {
                        return -1;
                    }
                    if (!p1Enable && p2enable) {
                        return 1;
                    }
                }
                if ((compared = this.value.compareTo(o.value)) != 0) {
                    return compared;
                }
            }
            if (this.value instanceof ActionWrapper && o.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)this.value).isAvailable() ? -1 : 1;
            }
            if (o.value instanceof ActionWrapper && this.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)o.value).isAvailable() ? 1 : -1;
            }
            if (this.value instanceof BooleanOptionDescription && !(o.value instanceof BooleanOptionDescription) && o.value instanceof OptionDescription) {
                return -1;
            }
            if (o.value instanceof BooleanOptionDescription && !(this.value instanceof BooleanOptionDescription) && this.value instanceof OptionDescription) {
                return 1;
            }
            if (this.value instanceof OptionDescription && !(o.value instanceof OptionDescription)) {
                return 1;
            }
            if (o.value instanceof OptionDescription && !(this.value instanceof OptionDescription)) {
                return -1;
            }
            diff = StringUtil.notNullize((String)this.getValueText()).length() - StringUtil.notNullize((String)o.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            diff = this.value.compareTo(o.value);
            if (diff != 0) {
                return diff;
            }
            return o.hashCode() - this.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRank";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

