/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecodeDefaultsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.ex.DecodeDefaultsUtil");
    private static final Map<String, URL> RESOURCE_CACHE = Collections.synchronizedMap(new THashMap());

    public static URL getDefaults(Object requestor, @NotNull String componentResourcePath) {
        URL url;
        if (componentResourcePath == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(0);
        }
        if ((url = RESOURCE_CACHE.get(componentResourcePath)) == null) {
            Class<?> requestorClass = requestor.getClass();
            if (StringUtil.startsWithChar((CharSequence)componentResourcePath, (char)'/')) {
                url = requestorClass.getResource(componentResourcePath + ".xml");
            } else {
                url = requestorClass.getResource('/' + ApplicationManagerEx.getApplicationEx().getName() + '/' + componentResourcePath + ".xml");
                if (url == null) {
                    url = requestorClass.getResource('/' + componentResourcePath + ".xml");
                }
            }
            RESOURCE_CACHE.put(componentResourcePath, url);
        }
        return url;
    }

    @Nullable
    public static InputStream getDefaultsInputStream(Object requestor, @NotNull String componentResourcePath) {
        if (componentResourcePath == null) {
            DecodeDefaultsUtil.$$$reportNull$$$0(1);
        }
        try {
            URL defaults = DecodeDefaultsUtil.getDefaults(requestor, componentResourcePath);
            return defaults == null ? null : URLUtil.openStream((URL)defaults);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "componentResourcePath";
        objectArray2[1] = "com/intellij/openapi/application/ex/DecodeDefaultsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultsInputStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

