/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ProjectTopics;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootType;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VirtualFileLogicalRoot;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogicalRootsManagerImpl
extends LogicalRootsManager {
    private Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> myRoots = null;
    private final MultiValuesMap<LogicalRootType, NotNullFunction> myProviders = new MultiValuesMap();
    private final MultiValuesMap<FileType, LogicalRootType> myFileTypes2RootTypes = new MultiValuesMap();
    private final ModuleManager myModuleManager;
    private final Project myProject;

    public LogicalRootsManagerImpl(final MessageBus bus, ModuleManager moduleManager, Project project) {
        this.myModuleManager = moduleManager;
        this.myProject = project;
        MessageBusConnection connection = bus.connect();
        connection.subscribe(LOGICAL_ROOTS, (Object)new LogicalRootsManager.LogicalRootListener(){

            public void logicalRootsChanged() {
                LogicalRootsManagerImpl.this.clear();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ((LogicalRootsManager.LogicalRootListener)bus.asyncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }
        });
        this.registerLogicalRootProvider(LogicalRootType.SOURCE_ROOT, module2 -> ContainerUtil.map2List((Object[])ModuleRootManager.getInstance((Module)module2).getSourceRoots(), s -> new VirtualFileLogicalRoot(s)));
    }

    private synchronized void clear() {
        this.myRoots = null;
    }

    private synchronized Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> getRoots(ModuleManager moduleManager) {
        if (this.myRoots == null) {
            Module[] modules;
            this.myRoots = new THashMap();
            for (Module module2 : modules = moduleManager.getModules()) {
                MultiValuesMap map2 = new MultiValuesMap();
                for (Map.Entry entry : this.myProviders.entrySet()) {
                    Collection functions = (Collection)entry.getValue();
                    for (NotNullFunction function : functions) {
                        map2.putAll(entry.getKey(), (Collection)((List)function.fun((Object)module2)));
                    }
                }
                this.myRoots.put(module2, (MultiValuesMap<LogicalRootType, LogicalRoot>)map2);
            }
        }
        return this.myRoots;
    }

    @Nullable
    public LogicalRoot findLogicalRoot(@NotNull VirtualFile file2) {
        Module module2;
        if (file2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(0);
        }
        if ((module2 = ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)this.myProject)) == null) {
            return null;
        }
        LogicalRoot result2 = null;
        List<LogicalRoot> list2 = this.getLogicalRoots(module2);
        for (LogicalRoot root : list2) {
            VirtualFile rootFile = root.getVirtualFile();
            if (rootFile == null || !VfsUtil.isAncestor((VirtualFile)rootFile, (VirtualFile)file2, (boolean)false)) continue;
            result2 = root;
            break;
        }
        return result2;
    }

    public List<LogicalRoot> getLogicalRoots() {
        return ContainerUtil.concat((Object[])this.myModuleManager.getModules(), module2 -> this.getLogicalRoots((Module)module2));
    }

    public List<LogicalRoot> getLogicalRoots(@NotNull Module module2) {
        Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> roots;
        MultiValuesMap<LogicalRootType, LogicalRoot> valuesMap;
        if (module2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(1);
        }
        if ((valuesMap = (roots = this.getRoots(this.myModuleManager)).get(module2)) == null) {
            return Collections.emptyList();
        }
        return new ArrayList<LogicalRoot>(valuesMap.values());
    }

    public List<LogicalRoot> getLogicalRootsOfType(@NotNull Module module2, LogicalRootType ... types) {
        if (module2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(2);
        }
        if (types == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(3);
        }
        return ContainerUtil.concat((Object[])types, s -> {
            if (module2 == null) {
                LogicalRootsManagerImpl.$$$reportNull$$$0(13);
            }
            return this.getLogicalRootsOfType(module2, (LogicalRootType<T>)((LogicalRootType)s));
        });
    }

    public <T extends LogicalRoot> List<T> getLogicalRootsOfType(@NotNull Module module2, @NotNull LogicalRootType<T> type) {
        Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> roots;
        MultiValuesMap<LogicalRootType, LogicalRoot> map2;
        if (module2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(4);
        }
        if (type == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(5);
        }
        if ((map2 = (roots = this.getRoots(this.myModuleManager)).get(module2)) == null) {
            return Collections.emptyList();
        }
        Collection collection = map2.get(type);
        if (collection == null) {
            return Collections.emptyList();
        }
        return new ArrayList(collection);
    }

    @NotNull
    public LogicalRootType[] getRootTypes(@NotNull FileType type) {
        Collection rootTypes;
        if (type == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(6);
        }
        if ((rootTypes = this.myFileTypes2RootTypes.get((Object)type)) == null) {
            LogicalRootType[] logicalRootTypeArray = new LogicalRootType[]{};
            if (logicalRootTypeArray == null) {
                LogicalRootsManagerImpl.$$$reportNull$$$0(7);
            }
            return logicalRootTypeArray;
        }
        LogicalRootType[] logicalRootTypeArray = rootTypes.toArray(new LogicalRootType[rootTypes.size()]);
        if (logicalRootTypeArray == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(8);
        }
        return logicalRootTypeArray;
    }

    public void registerRootType(@NotNull FileType fileType, LogicalRootType ... rootTypes) {
        if (fileType == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(9);
        }
        if (rootTypes == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(10);
        }
        this.myFileTypes2RootTypes.putAll((Object)fileType, (Object[])rootTypes);
    }

    public <T extends LogicalRoot> void registerLogicalRootProvider(@NotNull LogicalRootType<T> rootType, @NotNull NotNullFunction<Module, List<T>> provider) {
        if (rootType == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(12);
        }
        this.myProviders.put(rootType, provider);
        this.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/LogicalRootsManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/LogicalRootsManagerImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLogicalRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalRootsOfType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypes";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerRootType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerLogicalRootProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLogicalRootsOfType$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

