/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DetailsPanel
extends JPanel
implements EditorColorsListener {
    private static final int MAX_ROWS = 50;
    private static final int MIN_SIZE = 20;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JPanel myMainContentPanel;
    @NotNull
    private final StatusText myEmptyText;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private List<Integer> mySelection;
    @NotNull
    private Set<VcsFullCommitDetails> myCommitDetails;

    public DetailsPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parent) {
        if (logData == null) {
            DetailsPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            DetailsPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DetailsPanel.$$$reportNull$$$0(2);
        }
        this.mySelection = ContainerUtil.emptyList();
        this.myCommitDetails = Collections.emptySet();
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myScrollPane = new JBScrollPane(20, 30);
        this.myMainContentPanel = new MyMainContentPanel();
        this.myEmptyText = new StatusText(this.myMainContentPanel){

            protected boolean isStatusVisible() {
                return StringUtil.isNotEmpty((String)this.getText());
            }
        };
        this.myMainContentPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myMainContentPanel.setOpaque(false);
        this.myScrollPane.setViewportView(this.myMainContentPanel);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), parent, 300){

            public Color getBackground() {
                return CommitPanel.getCommitDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLoadingPanel, "Center");
        this.myEmptyText.setText("Commit details");
    }

    public void globalSchemeChange(EditorColorsScheme scheme2) {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.update();
        }
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public void installCommitSelectionListener(@NotNull VcsLogGraphTable graphTable) {
        if (graphTable == null) {
            DetailsPanel.$$$reportNull$$$0(3);
        }
        graphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDetails(graphTable));
    }

    public void branchesChanged() {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.updateBranches();
        }
    }

    private void rebuildCommitPanels(int[] selection) {
        this.myEmptyText.setText("");
        int selectionLength = selection.length;
        int existingCount = (this.myMainContentPanel.getComponentCount() + 1) / 2;
        int requiredCount = Math.min(selectionLength, 50);
        for (int i = existingCount; i < requiredCount; ++i) {
            if (i > 0) {
                this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            }
            this.myMainContentPanel.add((Component)((Object)new CommitPanel(this.myLogData, this.myColorManager)));
        }
        while (this.myMainContentPanel.getComponentCount() > 2 * requiredCount - 1) {
            this.myMainContentPanel.remove(this.myMainContentPanel.getComponentCount() - 1);
        }
        if (selectionLength > 50) {
            this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            JBLabel label = new JBLabel("(showing 50 of " + selectionLength + " selected commits)");
            label.setFont(VcsHistoryUtil.getCommitDetailsFont());
            label.setBorder((Border)CommitPanel.getDetailsBorder());
            this.myMainContentPanel.add((Component)label);
        }
        this.mySelection = Ints.asList((int[])Arrays.copyOf(selection, requiredCount));
        this.repaint();
    }

    @NotNull
    private CommitPanel getCommitPanel(int index) {
        CommitPanel commitPanel = (CommitPanel)((Object)this.myMainContentPanel.getComponent(2 * index));
        if (commitPanel == null) {
            DetailsPanel.$$$reportNull$$$0(4);
        }
        return commitPanel;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.max(minimumSize.width, JBUI.scale((int)20)), Math.max(minimumSize.height, JBUI.scale((int)20)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/DetailsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/DetailsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installCommitSelectionListener";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMainContentPanel
    extends ScrollablePanel {
        private MyMainContentPanel() {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            boolean expanded = false;
            for (Component c : this.getComponents()) {
                if (!(c instanceof CommitPanel) || !((CommitPanel)((Object)c)).isExpanded()) continue;
                expanded = true;
                break;
            }
            return !expanded;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int height = Math.max(preferredSize.height, DetailsPanel.this.myScrollPane.getViewport().getHeight());
            JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)this);
            if (scrollPane == null || this.getScrollableTracksViewportWidth()) {
                return new Dimension(preferredSize.width, height);
            }
            return new Dimension(Math.max(preferredSize.width, scrollPane.getViewport().getWidth()), height);
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (StringUtil.isNotEmpty((String)DetailsPanel.this.myEmptyText.getText())) {
                DetailsPanel.this.myEmptyText.paint((Component)this, g);
            } else {
                super.paintChildren(g);
            }
        }
    }

    private class CommitSelectionListenerForDetails
    extends CommitSelectionListener {
        public CommitSelectionListenerForDetails(VcsLogGraphTable graphTable) {
            super(DetailsPanel.this.myLogData, graphTable);
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
            if (detailsList == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(0);
            }
            HashSet newCommitDetails = ContainerUtil.newHashSet(detailsList);
            for (int i = 0; i < DetailsPanel.this.mySelection.size(); ++i) {
                CommitPanel commitPanel = DetailsPanel.this.getCommitPanel(i);
                commitPanel.setCommit(detailsList.get(i));
            }
            if (!ContainerUtil.intersects((Collection)DetailsPanel.this.myCommitDetails, (Collection)newCommitDetails)) {
                DetailsPanel.this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
            DetailsPanel.this.myCommitDetails = newCommitDetails;
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            if (selection == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(1);
            }
            DetailsPanel.this.rebuildCommitPanels(selection);
            List currentSelection = DetailsPanel.this.mySelection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ArrayList result2 = ContainerUtil.newArrayList();
                for (Integer row : currentSelection) {
                    result2.add(this.myGraphTable.getModel().getRefsAtRow(row));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (currentSelection == DetailsPanel.this.mySelection) {
                        for (int i = 0; i < currentSelection.size(); ++i) {
                            CommitPanel commitPanel = DetailsPanel.this.getCommitPanel(i);
                            commitPanel.setRefs((Collection)result2.get(i));
                        }
                    }
                });
            });
        }

        @Override
        protected void onEmptySelection() {
            DetailsPanel.this.myEmptyText.setText("No commits selected");
            DetailsPanel.this.myMainContentPanel.removeAll();
            DetailsPanel.this.mySelection = ContainerUtil.emptyList();
            DetailsPanel.this.myCommitDetails = Collections.emptySet();
        }

        @Override
        @NotNull
        protected List<Integer> getSelectionToLoad() {
            List list2 = DetailsPanel.this.mySelection;
            if (list2 == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        protected void startLoading() {
            DetailsPanel.this.myLoadingPanel.startLoading();
        }

        @Override
        protected void stopLoading() {
            DetailsPanel.this.myLoadingPanel.stopLoading();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/DetailsPanel$CommitSelectionListenerForDetails";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/DetailsPanel$CommitSelectionListenerForDetails";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionToLoad";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onDetailsLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelection";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

