/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u001e\u001a\u00020\u0017J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\u001e\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0007*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0007*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyTypeShed;", "", "()V", "BLACK_LIST", "", "", "ONLY_SUPPORTED_PY2_MINOR", "", "SUPPORTED_PY3_MINORS", "Lkotlin/ranges/IntRange;", "WHITE_LIST", "getWHITE_LIST", "()Ljava/util/Set;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "directory$delegate", "Lkotlin/Lazy;", "directoryPath", "getDirectoryPath", "()Ljava/lang/String;", "major", "Lcom/jetbrains/python/psi/LanguageLevel;", "getMajor", "(Lcom/jetbrains/python/psi/LanguageLevel;)I", "minor", "getMinor", "findRootsForLanguageLevel", "", "level", "findRootsForSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isInStandardLibrary", "", "file", "isInThirdPartyLibraries", "isInside", "maySearchForStubInRoot", "name", "Lcom/intellij/psi/util/QualifiedName;", "root", "python-community"})
public final class PyTypeShed {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final int ONLY_SUPPORTED_PY2_MINOR = 7;
    private static final IntRange SUPPORTED_PY3_MINORS;
    @NotNull
    private static final Set<String> WHITE_LIST;
    private static final Set<String> BLACK_LIST;
    @Nullable
    private static final Lazy directory$delegate;
    public static final PyTypeShed INSTANCE;

    static {
        PyTypeShed pyTypeShed;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PyTypeShed.class), "directory", "getDirectory()Lcom/intellij/openapi/vfs/VirtualFile;"))};
        INSTANCE = pyTypeShed = new PyTypeShed();
        ONLY_SUPPORTED_PY2_MINOR = 7;
        int n = 2;
        SUPPORTED_PY3_MINORS = new IntRange(n, 6);
        WHITE_LIST = SetsKt.setOf((Object[])new String[]{"typing", "six", "__builtin__", "builtins", "exceptions", "types", "datetime"});
        BLACK_LIST = SetsKt.emptySet();
        directory$delegate = LazyKt.lazy((Function0)directory.2.INSTANCE);
    }

    @NotNull
    public final Set<String> getWHITE_LIST() {
        return WHITE_LIST;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean maySearchForStubInRoot(@NotNull QualifiedName name, @NotNull VirtualFile root, @NotNull Sdk sdk) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        String string = name.getFirstComponent();
        if (string == null) return false;
        String topLevelPackage = string;
        if (BLACK_LIST.contains(topLevelPackage)) {
            return false;
        }
        if (!WHITE_LIST.contains(topLevelPackage)) {
            return false;
        }
        if (this.isInStandardLibrary(root)) {
            return true;
        }
        if (!this.isInThirdPartyLibraries(root)) return false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        List list2 = (List)PyPIPackageUtil.PACKAGES_TOPLEVEL.get((Object)topLevelPackage);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List pyPIPackages = list2;
        List<PyPackage> list3 = PyPackageManagers.getInstance().forSdk(sdk).getPackages();
        if (list3 == null) return true;
        List<PyPackage> packages = list3;
        if (PyPackageUtil.findPackage(packages, topLevelPackage) != null) return true;
        Iterable $receiver$iv = pyPIPackages;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            if (PyPackageUtil.findPackage(packages, it) != null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final List<VirtualFile> findRootsForSdk(@NotNull Sdk sdk) {
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        LanguageLevel level = PythonSdkType.getLanguageLevelForSdk(sdk);
        VirtualFile virtualFile = this.getDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile dir = virtualFile;
        LanguageLevel languageLevel = level;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageLevel), (String)"level");
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.findRootsForLanguageLevel(languageLevel)), (Function1)((Function1)new Function1<String, VirtualFile>(dir){
            final /* synthetic */ VirtualFile $dir;

            @Nullable
            public final VirtualFile invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$dir.findFileByRelativePath(it);
            }
            {
                this.$dir = virtualFile;
                super(1);
            }
        }))));
    }

    @NotNull
    public final List<String> findRootsForLanguageLevel(@NotNull LanguageLevel level) {
        int it;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        switch (this.getMajor(level)) {
            case 2: {
                list2 = CollectionsKt.listOf((Object)ONLY_SUPPORTED_PY2_MINOR);
                break;
            }
            case 3: {
                Iterable iterable = $receiver$iv = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)SUPPORTED_PY3_MINORS));
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = ((Number)element$iv$iv).intValue();
                    if (!(it <= INSTANCE.getMinor(level))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        List minors = list2;
        $receiver$iv$iv = $receiver$iv = (Iterable)minors;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            String string = "stdlib/" + INSTANCE.getMajor(level) + '.' + it;
            collection.add(string);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object[])new String[]{"stdlib/" + this.getMajor(level), "stdlib/2and3", "third_party/" + this.getMajor(level), "third_party/2and3"}));
    }

    public final boolean isInside(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile dir = this.getDirectory();
        return dir != null && VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file2, (boolean)true);
    }

    @Nullable
    public final VirtualFile getDirectory() {
        Lazy lazy = directory$delegate;
        PyTypeShed pyTypeShed = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (VirtualFile)lazy.getValue();
    }

    @Nullable
    public final String getDirectoryPath() {
        List paths = CollectionsKt.listOf((Object[])new String[]{"" + PathManager.getConfigPath() + "/typeshed", "" + PathManager.getConfigPath() + "/../typeshed", PythonHelpersLocator.getHelperPath("typeshed")});
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)paths), (Function1)directoryPath.1.INSTANCE));
    }

    public final boolean isInThirdPartyLibraries(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return StringsKt.contains$default((CharSequence)file2.getPath(), (CharSequence)"third_party", (boolean)false, (int)2, null);
    }

    public final boolean isInStandardLibrary(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return StringsKt.contains$default((CharSequence)file2.getPath(), (CharSequence)"stdlib", (boolean)false, (int)2, null);
    }

    private final int getMajor(@NotNull LanguageLevel $receiver) {
        return $receiver.getVersion() / 10;
    }

    private final int getMinor(@NotNull LanguageLevel $receiver) {
        return $receiver.getVersion() % 10;
    }

    private PyTypeShed() {
    }
}

