/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringTypeReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    @Nullable
    private PyType myType;
    @NotNull
    private TextRange myFullRange;
    @Nullable
    private final PyImportElement myImportElement;

    public DocStringTypeReference(PsiElement element, TextRange range, @NotNull TextRange fullRange, @Nullable PyType type, @Nullable PyImportElement importElement) {
        if (fullRange == null) {
            DocStringTypeReference.$$$reportNull$$$0(0);
        }
        super(element, range);
        this.myFullRange = fullRange;
        this.myType = type;
        this.myImportElement = importElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DocStringTypeReference.$$$reportNull$$$0(1);
        }
        if (element.equals(this.resolve())) {
            return element;
        }
        if (this.myElement instanceof PyStringLiteralExpression && element instanceof PyClass) {
            PyStringLiteralExpression e = (PyStringLiteralExpression)this.myElement;
            PyClass cls = (PyClass)element;
            QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath((PsiElement)cls, element);
            if (qname != null) {
                qname = qname.append(cls.getName());
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)e);
                this.myType = new PyClassTypeImpl(cls, false);
                return manipulator.handleContentChange((PsiElement)e, this.myFullRange, qname.toString());
            }
        }
        return null;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        newElementName = StringUtil.trimEnd((String)newElementName, (String)".py");
        return super.handleElementRename(newElementName);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (this.myType instanceof PyImportedModuleType) {
            return element.equals(PyUtil.turnInitIntoDir(this.resolve()));
        }
        return super.isReferenceTo(element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PyDocStringOwner result2 = null;
        ResolveResultList results = new ResolveResultList();
        if (this.myType instanceof PyClassType) {
            result2 = ((PyClassType)this.myType).getPyClass();
        } else if (this.myType instanceof PyImportedModuleType) {
            result2 = ((PyImportedModuleType)this.myType).getImportedModule().resolve();
        } else if (this.myType instanceof PyModuleType) {
            result2 = ((PyModuleType)this.myType).getModule();
        }
        if (result2 != null) {
            if (this.myImportElement != null) {
                results.add(new ImportedResolveResult((PsiElement)result2, 0, this.myImportElement));
            } else {
                results.poke((PsiElement)result2, 0);
            }
        }
        ResolveResult[] resolveResultArray = results.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            DocStringTypeReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            DocStringTypeReference.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public List<Object> collectTypeVariants() {
        PsiFile file2 = this.myElement.getContainingFile();
        ArrayList variants = Lists.newArrayList((Object[])new Object[]{"str", "int", "basestring", "bool", "buffer", "bytearray", "complex", "dict", "tuple", "enumerate", "file", "float", "frozenset", "list", "long", "set", "object"});
        if (file2 instanceof PyFile) {
            variants.addAll(((PyFile)file2).getTopLevelClasses());
            List<PyFromImportStatement> fromImports = ((PyFile)file2).getFromImports();
            for (PyFromImportStatement fromImportStatement : fromImports) {
                PyImportElement[] elements;
                for (PyImportElement element : elements = fromImportStatement.getImportElements()) {
                    PyType type;
                    PyReferenceExpression referenceExpression = element.getImportReferenceExpression();
                    if (referenceExpression == null || !((type = TypeEvalContext.userInitiated(file2.getProject(), CompletionUtil.getOriginalOrSelf(file2)).getType(referenceExpression)) instanceof PyClassType)) continue;
                    variants.add(((PyClassType)type).getPyClass());
                }
            }
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            DocStringTypeReference.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringTypeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringTypeReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

