/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualSymbol
extends Bib2GlsDualEntry {
    public Bib2GlsDualSymbol(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualsymbol");
    }

    public Bib2GlsDualSymbol(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualSymbolMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualSymbolMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualSymbolMap();
    }

    @Override
    protected Bib2GlsEntry createDualEntry() {
        return new Bib2GlsDualSymbol(this.bib2gls, this.getEntryType());
    }

    @Override
    public void checkRequiredFields(TeXParser teXParser) {
        if (this.getField("name") == null) {
            this.missingFieldWarning(teXParser, "name");
        }
        if (this.getField("symbol") == null) {
            this.missingFieldWarning(teXParser, "symbol");
        }
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        String string = this.getEntryType();
        if (string.startsWith("dual")) {
            string = string.substring(4);
        }
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.format("{name={#3},sort={#1},category={%s},#2}{#4}", string);
        printWriter.println("}");
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.getFieldSet();
        for (String string4 : set) {
            if (string4.equals("name")) {
                string2 = this.getFieldValue(string4);
                continue;
            }
            if (string4.equals("description")) {
                string3 = this.getFieldValue(string4);
                continue;
            }
            printWriter.format("%s", string);
            string = String.format(",%n", new Object[0]);
            printWriter.format("%s={%s}", string4, this.getFieldValue(string4));
        }
        printWriter.println(String.format("}%%%n{%s}%%%n{%s}", string2, string3));
    }
}

