/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2GlsEntry
extends BibEntry {
    private Vector<GlsRecord> records;
    private HashMap<String, Vector<GlsRecord>> recordMap;
    private Vector<GlsRecord> supplementalRecords;
    private Vector<GlsRecord> ignoredRecords;
    private Vector<Bib2GlsEntry> children;
    private HashMap<String, String> fieldValues;
    private Vector<String> deps;
    private Vector<Bib2GlsEntry> hierarchy;
    private Vector<Bib2GlsEntry> crossRefdBy;
    private String crossRefTag = null;
    private String[] crossRefs = null;
    private String[] alsocrossRefs = null;
    public static final int NO_SEE = 0;
    public static final int PRE_SEE = 1;
    public static final int POST_SEE = 2;
    protected Bib2Gls bib2gls;
    protected GlsResource resource;
    private CollationKey collationKey;
    private String labelPrefix = null;
    private Bib2GlsEntry dual = null;
    private Number numericSort = null;
    private Vector<String> locationList = null;
    private static final Pattern EXT_PREFIX_PATTERN = Pattern.compile("ext(\\d+)\\.(.*)");
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\(|\\))(.*)");

    public Bib2GlsEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "entry");
    }

    public Bib2GlsEntry(Bib2Gls bib2Gls, String string) {
        super(string.toLowerCase());
        this.bib2gls = bib2Gls;
        this.resource = bib2Gls.getCurrentResource();
        this.labelPrefix = this.resource.getLabelPrefix();
        this.fieldValues = new HashMap();
        this.deps = new Vector();
        String[] stringArray = this.resource.getLocationCounters();
        if (stringArray == null) {
            this.records = new Vector();
        } else {
            this.recordMap = new HashMap(stringArray.length);
            for (String string2 : stringArray) {
                this.recordMap.put(string2, new Vector());
            }
        }
    }

    public void setDual(Bib2GlsEntry bib2GlsEntry) {
        this.dual = bib2GlsEntry;
    }

    public Bib2GlsEntry getDual() {
        return this.dual;
    }

    public GlsResource getResource() {
        return this.resource;
    }

    public String getPrefix() {
        return this.labelPrefix;
    }

    @Override
    public String getId() {
        return this.labelPrefix == null ? super.getId() : this.labelPrefix + super.getId();
    }

    public String getOriginalId() {
        return super.getId();
    }

    public void setId(String string, String string2) {
        this.labelPrefix = string;
        this.setId(string2);
    }

    public String processLabel(String string) {
        block11: {
            if (string.startsWith("dual.")) {
                String string2 = this.resource.getDualPrefix();
                if (string2 == null) {
                    string = string.substring(5);
                } else if (!string2.equals("dual.")) {
                    string = String.format("%s%s", string2, string.substring(5));
                }
            } else {
                Matcher matcher = EXT_PREFIX_PATTERN.matcher(string);
                if (matcher.matches()) {
                    try {
                        String string3 = this.resource.getExternalPrefix(Integer.parseInt(matcher.group(1)));
                        if (string3 == null) {
                            string = matcher.group(2);
                            break block11;
                        }
                        string = String.format("%s%s", string3, matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bib2gls.debug(numberFormatException);
                    }
                } else if (this.labelPrefix != null) {
                    string = String.format("%s%s", this.labelPrefix, string);
                }
            }
        }
        return string;
    }

    private boolean isGlsCsOptLabel(String string) {
        block8: {
            block7: {
                if (string.equals("gls") || string.equals("glspl") || string.equals("acrfull") || string.equals("acrlong") || string.equals("acrshort") || string.equals("acrfullpl") || string.equals("acrlongpl") || string.equals("acrshortpl") || string.equals("cgls") || string.equals("cglspl") || string.equals("pgls") || string.equals("pglspl") || string.equals("glsadd") || string.equals("glsdisp") || string.equals("glslink") || string.equals("glsxtrfull") || string.equals("glsxtrfullpl") || string.equals("glsxtrshort") || string.equals("glsxtrshortpl") || string.equals("glsxtrlong") || string.equals("glsxtrlongpl") || string.equals("glsps") || string.equals("glspt") || string.equals("glshyperlink")) {
                    return true;
                }
                if (this.bib2gls.checkAcroShortcuts() && (string.equals("ac") || string.equals("acs") || string.equals("acsp") || string.equals("acl") || string.equals("aclp") || string.equals("acf") || string.equals("acfp"))) {
                    return true;
                }
                if (this.bib2gls.checkAbbrvShortcuts() && (string.equals("ab") || string.equals("abp") || string.equals("as") || string.equals("asp") || string.equals("al") || string.equals("alp") || string.equals("af") || string.equals("afp"))) {
                    return true;
                }
                if (!string.startsWith("glsxtr")) break block7;
                Vector<String> vector = this.bib2gls.getFields();
                HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
                for (String string2 : vector) {
                    if (string.equals("glsxtr" + string2)) {
                        return true;
                    }
                    String string3 = hashMap.get(string2);
                    if (string3 == null || !string.equals("glsxtr" + string3)) continue;
                    return true;
                }
                break block8;
            }
            if (!string.startsWith("gls")) break block8;
            Vector<String> vector = this.bib2gls.getFields();
            HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
            for (String string4 : vector) {
                if (string.equals("gls" + string4)) {
                    return true;
                }
                String string5 = hashMap.get(string4);
                if (string5 == null || !string.equals("gls" + string5)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCsProblematic(String string) {
        return string.equals("foreignlanguage") || string.equals("textcolor") || string.equals("ensuremath") || string.equals("cite") || string.equals("citep") || string.equals("citet") || string.equals("autoref") || string.equals("cref") || string.equals("ref");
    }

    private void checkGlsCs(TeXParser teXParser, TeXObjectList teXObjectList, boolean bl, String string) throws IOException {
        for (int i = 0; i < teXObjectList.size(); ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject.isPar() || teXObject instanceof TeXCsRef && ((TeXCsRef)teXObject).getName().equals("par")) {
                teXObjectList.set(i, new TeXCsRef("glspar"));
                continue;
            }
            if (teXObject instanceof TeXCsRef) {
                String string2 = ((TeXCsRef)teXObject).getName().toLowerCase();
                boolean bl2 = false;
                try {
                    Object object;
                    String string3;
                    String string4;
                    TeXObject teXObject2;
                    if (string2.equals("glssee") || string2.equals("glsxtrindexseealso")) {
                        int n;
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof CharObject && (n = ((CharObject)teXObject2).getCharCode()) == 91) {
                            while (i < teXObjectList.size()) {
                                teXObject2 = (TeXObject)teXObjectList.get(i);
                                if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                    break;
                                }
                                ++i;
                            }
                            while (teXObject2 instanceof Ignoreable) {
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                            }
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string4 = this.processLabel(string3 = teXObject2.toString(teXParser))).equals(string3)) {
                            string3 = string4;
                            teXObjectList.set(i, teXParser.getListener().createGroup(string3));
                        }
                        this.addDependency(string3);
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        object = teXParser.getListener().createGroup();
                        CsvList csvList = CsvList.getList(teXParser, teXObject2);
                        int n2 = csvList.size() - 1;
                        for (int j = 0; j <= n2; ++j) {
                            TeXObject teXObject3 = (TeXObject)csvList.get(j);
                            string3 = this.processLabel(teXObject3.toString(teXParser));
                            ((TeXObjectList)object).add(teXParser.getListener().createString(string3));
                            if (j < n2) {
                                ((TeXObjectList)object).add(teXParser.getListener().getOther(44));
                            }
                            this.addDependency(string3);
                        }
                        teXObjectList.set(i, object);
                    } else if (string2.equals("glsxtrp")) {
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string3 = teXObject2.toString(teXParser)).equals(string4 = this.processLabel(string3))) {
                            string3 = string4;
                            teXObjectList.set(i, teXParser.getListener().createGroup(string3));
                        }
                        this.addDependency(string3);
                    } else if (this.isGlsCsOptLabel(string2)) {
                        String string5;
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        string3 = "";
                        string4 = "";
                        if (teXObject2 instanceof CharObject) {
                            int n = ((CharObject)teXObject2).getCharCode();
                            if (n == 42 || n == 43) {
                                string3 = teXObject2.toString(teXParser);
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                                if (teXObject2 instanceof CharObject) {
                                    n = ((CharObject)teXObject2).getCharCode();
                                }
                            }
                            if (n == 91) {
                                string4 = "[";
                                while (i < teXObjectList.size()) {
                                    teXObject2 = (TeXObject)teXObjectList.get(i);
                                    string4 = string4 + teXObject2.toString(teXParser);
                                    if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                                        break;
                                    }
                                    ++i;
                                }
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                            }
                        }
                        int n = i;
                        if (teXObject2 instanceof BgChar) {
                            object = "";
                            while (!((teXObject2 = (TeXObject)teXObjectList.get(++i)) instanceof EgChar)) {
                                object = (String)object + teXObject2.toString(teXParser);
                            }
                        } else {
                            object = teXObject2 instanceof Group ? ((Group)teXObject2).toList().toString(teXParser) : teXObject2.toString(teXParser);
                        }
                        if (!((String)object).equals(string5 = this.processLabel((String)object))) {
                            object = string5;
                            while (i > n) {
                                teXObjectList.remove(i);
                                --i;
                            }
                            teXObjectList.set(i, teXParser.getListener().createGroup((String)object));
                        }
                        this.addDependency((String)object);
                        if (this.bib2gls.checkNestedLinkTextField(string) && !string2.equals("glsps") && !string2.equals("glspt")) {
                            this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.potential.nested.link", this.getId(), string, String.format("\\%s%s%s", string2, string3, string4), object));
                        }
                    } else if (this.isCsProblematic(string2)) {
                        bl2 = i == 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.can.find.arg", string2));
                }
                if (!bl2 || !bl) continue;
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, teXParser.getListener().createGroup());
                ++i;
                continue;
            }
            if (!(teXObject instanceof TeXObjectList)) continue;
            if (teXObject instanceof MathGroup && i == 0 && bl && this.bib2gls.mfirstucMathShiftProtection()) {
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, teXParser.getListener().createGroup());
                ++i;
            }
            this.checkGlsCs(teXParser, (TeXObjectList)teXObject, false, string);
        }
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        BibValueList bibValueList;
        Object object;
        Object object2;
        Object object3;
        super.parseContents(teXParser, teXObjectList, teXObject);
        Vector<String> vector = this.bib2gls.getFields();
        boolean bl = this.bib2gls.mfirstucProtection();
        String[] stringArray = this.bib2gls.mfirstucProtectionFields();
        if (this.resource.changeShortCase() && (object3 = this.getField("short")) != null) {
            this.putField("short", this.resource.applyShortCaseChange(teXParser, (BibValueList)object3));
        }
        if (this.resource.changeDualShortCase() && (object3 = this.getField("dualshort")) != null) {
            this.putField("dualshort", this.resource.applyShortCaseChange(teXParser, (BibValueList)object3));
        }
        object3 = this.resource.getShortPluralSuffix();
        String string = this.resource.getDualShortPluralSuffix();
        if (object3 != null && (object2 = this.getField("shortplural")) == null && (object2 = this.getField("short")) != null) {
            object = (TeXObjectList)((BibValueList)object2).getContents(true);
            bibValueList = new BibValueList();
            if (object != null) {
                bibValueList.add(new BibUserString((TeXObject)object));
            }
            if (!((String)object3).isEmpty()) {
                bibValueList.add(new BibUserString(teXParser.getListener().createString((String)object3)));
            }
            this.putField("shortplural", bibValueList);
        }
        if (string != null && (object2 = this.getField("dualshortplural")) == null && (object2 = this.getField("dualshort")) != null) {
            object = (TeXObjectList)((BibValueList)object2).getContents(true);
            bibValueList = new BibValueList();
            if (object != null) {
                bibValueList.add(new BibUserString((TeXObject)object));
            }
            if (!((String)object3).isEmpty()) {
                bibValueList.add(new BibUserString(teXParser.getListener().createString(string)));
            }
            this.putField("dualshortplural", bibValueList);
        }
        if (this.resource.hasSkippedFields()) {
            for (Object object4 : object2 = this.resource.getSkipFields()) {
                this.removeField((String)object4);
            }
        }
        if (this.bib2gls.useGroupField() && (object2 = this.resource.getGroupField()) != null) {
            this.putField("group", (String)object2);
        }
        boolean bl2 = false;
        for (String string2 : vector) {
            Object object4;
            BibValueList bibValueList2 = this.getField(string2);
            if (string2.equals("name")) {
                bl2 = true;
            }
            if (bibValueList2 == null) continue;
            object4 = BibValueList.stripDelim(bibValueList2.expand(teXParser));
            boolean bl3 = bl;
            if (bl3 && stringArray != null) {
                bl3 = false;
                for (String string3 : stringArray) {
                    if (!string3.equals(string2)) continue;
                    bl3 = true;
                    break;
                }
            }
            this.checkGlsCs(teXParser, (TeXObjectList)object4, bl3, string2);
            this.putField(string2, ((TeXObjectList)object4).toString(teXParser));
        }
        this.checkRequiredFields(teXParser);
    }

    public String getFallbackValue(String string) {
        if (string.equals("text")) {
            return this.fieldValues.get("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            String string3 = bib2GlsEntry.getFieldValue("name");
            if (string3 != null) {
                return string3;
            }
            return bib2GlsEntry.getFallbackValue("name");
        }
        if (string.equals("sort")) {
            String string4 = this.fieldValues.get("name");
            if (string4 != null) {
                return string4;
            }
            return this.getFallbackValue("name");
        }
        if (string.equals("first")) {
            String string5 = this.getFieldValue("text");
            if (string5 != null) {
                return string5;
            }
            return this.getFallbackValue("text");
        }
        if (string.equals("plural")) {
            String string6 = this.getFieldValue("text");
            if (string6 == null) {
                string6 = this.getFallbackValue("text");
            }
            if (string6 != null) {
                String string7 = this.resource.getPluralSuffix();
                return string7 == null ? string6 : string6 + string7;
            }
        } else {
            String string8;
            if (string.equals("firstplural")) {
                String string9 = this.getFieldValue("first");
                if (string9 == null) {
                    string9 = this.fieldValues.get("first");
                }
                if (string9 != null) {
                    String string10 = this.resource.getPluralSuffix();
                    return string10 == null ? string9 : string9 + string10;
                }
                string9 = this.getFieldValue("plural");
                return string9 == null ? this.getFallbackValue("plural") : string9;
            }
            if (string.equals("shortplural")) {
                String string11 = this.getFieldValue("short");
                if (string11 != null) {
                    String string12 = this.resource.getShortPluralSuffix();
                    return string12 == null ? string11 : string11 + string12;
                }
            } else if (string.equals("longplural") && (string8 = this.getFieldValue("long")) != null) {
                String string13 = this.resource.getPluralSuffix();
                return string13 == null ? string8 : string8 + string13;
            }
        }
        return null;
    }

    public BibValueList getFallbackContents(String string) {
        if (string.equals("text")) {
            return this.getField("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            BibValueList bibValueList = bib2GlsEntry.getField("name");
            if (bibValueList != null) {
                return bibValueList;
            }
            return bib2GlsEntry.getFallbackContents("name");
        }
        if (string.equals("sort")) {
            BibValueList bibValueList = this.getField("name");
            return bibValueList == null ? this.getFallbackContents("name") : bibValueList;
        }
        if (string.equals("first")) {
            BibValueList bibValueList = this.getField("text");
            return bibValueList == null ? this.getFallbackContents("text") : bibValueList;
        }
        if (string.equals("plural")) {
            BibValueList bibValueList = this.getField("text");
            if (bibValueList == null) {
                bibValueList = this.getFallbackContents("text");
            }
            return this.plural(bibValueList, "glspluralsuffix");
        }
        if (string.equals("firstplural")) {
            BibValueList bibValueList = this.getField("first");
            if (bibValueList == null) {
                bibValueList = this.getField("plural");
                return bibValueList == null ? this.getFallbackContents("plural") : bibValueList;
            }
            return this.plural(bibValueList, "glspluralsuffix");
        }
        if (string.equals("longplural")) {
            return this.plural(this.getField("long"), "glspluralsuffix");
        }
        if (string.equals("shortplural")) {
            return this.plural(this.getField("short"), "abbrvpluralsuffix");
        }
        if (string.equals("duallongplural")) {
            return this.plural(this.getField("duallong"), "glspluralsuffix");
        }
        if (string.equals("dualshortplural")) {
            return this.plural(this.getField("dualshort"), "abbrvpluralsuffix");
        }
        return null;
    }

    protected BibValueList plural(BibValueList bibValueList, String string) {
        if (bibValueList == null) {
            return null;
        }
        bibValueList = (BibValueList)bibValueList.clone();
        bibValueList.add(new BibUserString(new TeXCsRef(string)));
        return bibValueList;
    }

    public void checkRequiredFields(TeXParser teXParser) {
        if (this.getField("name") == null && this.getField("parent") == null) {
            this.missingFieldWarning(teXParser, "name");
        }
        if (this.getField("description") == null) {
            this.missingFieldWarning(teXParser, "description");
        }
    }

    protected void missingFieldWarning(TeXParser teXParser, String string) {
        teXParser.getListener().getTeXApp().warning(teXParser, this.bib2gls.getMessage("warning.missing.field", this.getId(), string));
    }

    public String getCsName() {
        return String.format("bibglsnew%s", this.getEntryType());
    }

    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.println("{name={#3},#2}{#4}%");
        printWriter.println("}");
    }

    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = null;
        String string3 = "";
        Set<String> set = this.getFieldSet();
        for (String string4 : set) {
            String string5 = this.fieldValues.get(string4);
            if (string5 == null) continue;
            if (string4.equals("description")) {
                string = string5;
                continue;
            }
            if (string4.equals("name")) {
                string2 = string5;
                continue;
            }
            printWriter.format("%s", string3);
            string3 = String.format(",%n", new Object[0]);
            printWriter.format("%s={%s}", string4, string5);
        }
        if (string2 == null) {
            string2 = this.getFallbackValue("name");
        }
        printWriter.println("}%");
        printWriter.println(String.format("{%s}%%", string2));
        printWriter.println(String.format("{%s}", string));
    }

    public void writeLocList(PrintWriter printWriter) throws IOException {
        if (this.locationList == null) {
            return;
        }
        for (String string : this.locationList) {
            printWriter.println(String.format("\\glsxtrfieldlistadd{%s}{loclist}{%s}", this.getId(), string));
        }
    }

    public Set<String> getFieldSet() {
        return this.fieldValues.keySet();
    }

    public String getFieldValue(String string) {
        return this.fieldValues.get(string);
    }

    public String putField(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("null label not permitted");
        }
        if (string2 == null) {
            throw new NullPointerException("null value not permitted for field " + string);
        }
        if (this.bib2gls.trimFields()) {
            string2 = string2.trim();
        }
        return this.fieldValues.put(string, string2);
    }

    public String removeFieldValue(String string) {
        return this.fieldValues.remove(string);
    }

    public String getParent() {
        return this.fieldValues.get("parent");
    }

    public boolean hasCrossRefs() {
        return this.crossRefs != null && this.crossRefs.length > 0 || this.alsocrossRefs != null && this.alsocrossRefs.length > 0;
    }

    public String[] getCrossRefs() {
        return this.crossRefs;
    }

    public String[] getAlsoCrossRefs() {
        return this.alsocrossRefs;
    }

    public void addCrossRefdBy(Bib2GlsEntry bib2GlsEntry) {
        if (this.crossRefdBy == null) {
            this.crossRefdBy = new Vector();
        }
        if (!this.crossRefdBy.contains(bib2GlsEntry)) {
            this.crossRefdBy.add(bib2GlsEntry);
        }
    }

    public Iterator<Bib2GlsEntry> getCrossRefdByIterator() {
        return this.crossRefdBy.iterator();
    }

    public boolean hasDependent(String string) {
        return this.deps.contains(string);
    }

    public void addDependency(String string) {
        if (!this.deps.contains(string) && !string.equals(this.getId())) {
            this.deps.add(string);
        }
    }

    public Iterator<String> getDependencyIterator() {
        return this.deps.iterator();
    }

    public boolean hasDependencies() {
        return this.deps.size() > 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Bib2GlsEntry)) {
            return false;
        }
        return this.getId().equals(((Bib2GlsEntry)object).getId());
    }

    public int recordCount() {
        int n = 0;
        if (this.supplementalRecords != null) {
            n = this.supplementalRecords.size();
        }
        if (this.ignoredRecords != null) {
            n = this.ignoredRecords.size();
        }
        if (this.records != null) {
            return n + this.records.size();
        }
        for (String string : this.resource.getLocationCounters()) {
            n += this.recordMap.get(string).size();
        }
        return n;
    }

    public int mainRecordCount() {
        if (this.records != null) {
            return this.records.size();
        }
        int n = 0;
        for (String string : this.resource.getLocationCounters()) {
            n += this.recordMap.get(string).size();
        }
        return n;
    }

    public int supplementalRecordCount() {
        return this.supplementalRecords == null ? 0 : this.supplementalRecords.size();
    }

    public int ignoredRecordCount() {
        return this.ignoredRecords == null ? 0 : this.ignoredRecords.size();
    }

    public boolean hasRecords() {
        return this.recordCount() > 0;
    }

    public void addRecord(GlsRecord glsRecord) {
        if (glsRecord.getFormat().equals("glsignore")) {
            this.bib2gls.debug(this.bib2gls.getMessage("message.ignored.record", glsRecord));
            this.addIgnoredRecord(glsRecord);
        } else if (this.records != null) {
            if (!this.records.contains(glsRecord)) {
                this.records.add(glsRecord);
            }
        } else {
            Vector<GlsRecord> vector = this.recordMap.get(glsRecord.getCounter());
            if (vector != null && !vector.contains(glsRecord)) {
                vector.add(glsRecord);
            }
        }
    }

    public void addSupplementalRecord(GlsRecord glsRecord) {
        if (this.supplementalRecords == null) {
            this.supplementalRecords = new Vector();
        }
        glsRecord.setLabel(this.getId());
        String string = glsRecord.getFormat();
        string = string.startsWith("(") ? "(glsxtrsupphypernumber" : (string.startsWith(")") ? ")glsxtrsupphypernumber" : "glsxtrsupphypernumber");
        glsRecord.setFormat(string);
        if (!this.supplementalRecords.contains(glsRecord)) {
            this.supplementalRecords.add(glsRecord);
        }
    }

    public void addIgnoredRecord(GlsRecord glsRecord) {
        if (this.ignoredRecords == null) {
            this.ignoredRecords = new Vector();
        }
        glsRecord.setLabel(this.getId());
        if (!this.ignoredRecords.contains(glsRecord)) {
            this.ignoredRecords.add(glsRecord);
        }
    }

    private StringBuilder updateLocationList(int n, String string, String string2, int n2, Vector<GlsRecord> vector, StringBuilder stringBuilder) throws Bib2GlsException {
        GlsRecord glsRecord = null;
        int n3 = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        int[] nArray = new int[]{0};
        boolean bl = true;
        GlsRecord glsRecord2 = null;
        String string3 = null;
        int n4 = 0;
        for (GlsRecord glsRecord3 : vector) {
            this.locationList.add(glsRecord3.getListTeXCode());
            Matcher matcher = RANGE_PATTERN.matcher(glsRecord3.getFormat());
            if (matcher.matches()) {
                char c = matcher.group(1).charAt(0);
                n3 = 0;
                stringBuilder2.setLength(0);
                if (c == '(') {
                    if (glsRecord2 != null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.nested.range", glsRecord3, glsRecord2));
                    }
                    glsRecord2 = glsRecord3;
                    string3 = matcher.group(2);
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else if (!bl) {
                        stringBuilder.append("\\delimN ");
                    }
                    n4 = stringBuilder.length();
                    stringBuilder.append("\\bibglsrange{");
                    stringBuilder.append(glsRecord3.getFmtTeXCode());
                } else {
                    if (glsRecord2 == null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.start", glsRecord3));
                    }
                    stringBuilder.append("\\delimR ");
                    stringBuilder.append(glsRecord3.getFmtTeXCode());
                    stringBuilder.append("}");
                    glsRecord2 = null;
                    string3 = null;
                }
            } else if (glsRecord2 != null) {
                String string4;
                String string5 = glsRecord3.getFormat();
                if (!glsRecord2.getPrefix().equals(glsRecord3.getPrefix()) || !glsRecord2.getCounter().equals(glsRecord3.getCounter())) {
                    this.bib2gls.warning(this.bib2gls.getMessage("error.inconsistent.range", glsRecord3, glsRecord2));
                    string4 = String.format("\\bibglsinterloper{%s}", glsRecord3.getFmtTeXCode());
                    stringBuilder.insert(n4, string4);
                    n4 += string4.length();
                } else if ((string3.isEmpty() || string3.equals("glsnumberformat")) && (string5.isEmpty() || string5.equals("glsnumberformat")) || string3.equals(string5)) {
                    this.bib2gls.debug(this.bib2gls.getMessage("message.merge.range", glsRecord3, glsRecord2));
                } else {
                    if (glsRecord3.getFormat().equals("glsnumberformat") || string3.isEmpty()) {
                        this.bib2gls.verbose(this.bib2gls.getMessage("message.inconsistent.range", glsRecord3, glsRecord2));
                    } else {
                        this.bib2gls.warning(this.bib2gls.getMessage("error.inconsistent.range", glsRecord3, glsRecord2));
                    }
                    string4 = String.format("\\bibglsinterloper{%s}", glsRecord3.getFmtTeXCode());
                    stringBuilder.insert(n4, string4);
                    n4 += string4.length();
                }
            } else if (glsRecord == null) {
                n3 = 1;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else if (!bl) {
                    stringBuilder.append("\\delimN ");
                }
                stringBuilder.append(glsRecord3.getFmtTeXCode());
            } else if (n < Integer.MAX_VALUE && glsRecord3.follows(glsRecord, n2, nArray)) {
                ++n3;
                stringBuilder2.append("\\delimN ");
                stringBuilder2.append(glsRecord3.getFmtTeXCode());
            } else if (n3 == 2 && string != null) {
                stringBuilder.append(string);
                stringBuilder.append("\\delimN ");
                stringBuilder.append(glsRecord3.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
            } else if (n3 > 2 && string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\\delimN ");
                stringBuilder.append(glsRecord3.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
            } else if (n3 >= n) {
                stringBuilder.append("\\delimR ");
                stringBuilder.append(glsRecord.getFmtTeXCode());
                if (nArray[0] > 1) {
                    stringBuilder.append("\\bibglspassim ");
                }
                nArray[0] = 0;
                stringBuilder.append("\\delimN ");
                stringBuilder.append(glsRecord3.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("\\delimN ");
                stringBuilder.append(glsRecord3.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
            }
            glsRecord = glsRecord3;
            bl = false;
        }
        if (glsRecord2 != null) {
            throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.end", glsRecord2));
        }
        if (glsRecord != null && stringBuilder2.length() > 0) {
            if (n3 >= n) {
                stringBuilder.append("\\delimR ");
                stringBuilder.append(glsRecord.getFmtTeXCode());
                if (nArray[0] > 1) {
                    stringBuilder.append("\\bibglspassim ");
                }
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder;
    }

    public void updateLocationList(int n, String string, String string2, int n2, int n3, boolean bl, boolean bl2, int n4) throws Bib2GlsException {
        boolean bl3;
        int n5;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = null;
        this.locationList = new Vector();
        int n6 = this.recordCount();
        if (n2 == 1 && this.crossRefs != null) {
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\\glsxtrusesee{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            if (n6 > 0) {
                stringBuilder2.append("\\bibglsseesep ");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\glsseeformat");
            if (this.crossRefTag != null) {
                stringBuilder.append('[');
                stringBuilder.append(this.crossRefTag);
                stringBuilder.append(']');
            }
            stringBuilder.append("{");
            for (n5 = 0; n5 < this.crossRefs.length; ++n5) {
                if (n5 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.processLabel(this.crossRefs[n5]));
            }
            stringBuilder.append("}{}");
            this.locationList.add(stringBuilder.toString());
        } else if (n3 == 1 && this.alsocrossRefs != null) {
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\\glsxtruseseealso{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            if (n6 > 0) {
                stringBuilder2.append("\\bibglsseealsosep ");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\glsxtruseseealsoformat");
            stringBuilder.append("{");
            for (n5 = 0; n5 < this.alsocrossRefs.length; ++n5) {
                if (n5 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.processLabel(this.alsocrossRefs[n5]));
            }
            stringBuilder.append("}");
            this.locationList.add(stringBuilder.toString());
        }
        boolean bl4 = bl3 = n6 > 0;
        if (this.getField("alias") != null && this.resource.aliasLocations() != 2) {
            bl3 = false;
        }
        if (bl3) {
            if (bl) {
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                }
                stringBuilder2.append(String.format("\\bibglslocprefix{%d}", n6));
            }
            String string3 = "";
            if (this.records == null) {
                String string4 = "";
                for (String string5 : this.resource.getLocationCounters()) {
                    Vector<GlsRecord> vector = this.recordMap.get(string5);
                    if (vector.size() <= 0) continue;
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder();
                    }
                    stringBuilder2.append(String.format("%s\\bibglslocationgroup{%s}{%s}{", string4, vector.size(), string5));
                    stringBuilder2 = this.updateLocationList(n, string, string2, n4, vector, stringBuilder2);
                    stringBuilder2.append("}");
                    string4 = "\\bibglslocationgroupsep ";
                    string3 = "\\bibglssupplementalsep ";
                }
            } else if (this.records.size() > 0) {
                stringBuilder2 = this.updateLocationList(n, string, string2, n4, this.records, stringBuilder2);
                string3 = "\\bibglssupplementalsep ";
            }
            if (this.supplementalRecords != null && this.supplementalRecords.size() > 0) {
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                }
                stringBuilder2.append(String.format("%s\\bibglssupplemental{%d}{", string3, this.supplementalRecords.size()));
                stringBuilder2 = this.updateLocationList(n, string, string2, n4, this.supplementalRecords, stringBuilder2);
                stringBuilder2.append("}");
            }
        }
        if (n2 == 2 && this.crossRefs != null) {
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            if (bl3) {
                stringBuilder2.append("\\bibglsseesep ");
            }
            stringBuilder2.append("\\glsxtrusesee{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append("\\glsseeformat");
            if (this.crossRefTag != null) {
                stringBuilder3.append('[');
                stringBuilder3.append(this.crossRefTag);
                stringBuilder3.append(']');
            }
            stringBuilder3.append("{");
            for (int i = 0; i < this.crossRefs.length; ++i) {
                if (i > 0) {
                    stringBuilder3.append(",");
                }
                stringBuilder3.append(this.processLabel(this.crossRefs[i]));
            }
            stringBuilder3.append("}{}");
            this.locationList.add(stringBuilder3.toString());
        } else if (n3 == 2 && this.alsocrossRefs != null) {
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            if (bl3) {
                stringBuilder2.append("\\bibglsseealsosep ");
            }
            stringBuilder2.append("\\glsxtruseseealso{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append("\\glsxtruseseealsoformat");
            stringBuilder4.append("{");
            for (int i = 0; i < this.alsocrossRefs.length; ++i) {
                if (i > 0) {
                    stringBuilder4.append(",");
                }
                stringBuilder4.append(this.processLabel(this.alsocrossRefs[i]));
            }
            stringBuilder4.append("}");
            this.locationList.add(stringBuilder4.toString());
        }
        if (stringBuilder2 != null) {
            if (bl2 && (n6 > 0 || this.crossRefs != null || this.alsocrossRefs != null)) {
                stringBuilder2.append(String.format("\\bibglslocsuffix{%d}", n6));
            }
            this.putField("location", stringBuilder2.toString());
        }
    }

    public void initAlias(TeXParser teXParser) throws IOException {
        BibValueList bibValueList = this.getField("alias");
        String string = null;
        if (bibValueList != null) {
            string = bibValueList.expand(teXParser).toString(teXParser);
            this.addDependency(this.processLabel(string));
            this.putField("alias", string);
            this.resource.setAliases(true);
            if (this.getField("see") == null) {
                this.putField("see", bibValueList);
            }
        }
    }

    public void initCrossRefs(TeXParser teXParser) throws IOException {
        Object object;
        BibValueList bibValueList = this.getField("see");
        TeXObjectList teXObjectList = null;
        BibValueList bibValueList2 = this.getField("seealso");
        if (bibValueList == null) {
            if (bibValueList2 != null) {
                this.initAlsoCrossRefs(teXParser, bibValueList2);
                return;
            }
            object = this.bib2gls.getSeeRecord(this.getId());
            if (object == null) {
                return;
            }
            TeXObject teXObject = ((GlsSeeRecord)object).getValue();
            if (teXObject instanceof TeXObjectList) {
                teXObjectList = (TeXObjectList)teXObject;
            } else {
                teXObjectList = new TeXObjectList();
                teXObjectList.add(teXObject);
            }
        }
        if (bibValueList2 != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.field.clash", "see", "seealso"));
        }
        if (teXObjectList == null) {
            teXObjectList = bibValueList.expand(teXParser);
        }
        object = new StringBuilder();
        this.initSeeRef(teXParser, teXObjectList, (StringBuilder)object);
    }

    private void initSeeRef(TeXParser teXParser, TeXObjectList teXObjectList, StringBuilder stringBuilder) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject;
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((teXObject = teXObjectList.popArg(teXParser, '[', ']')) != null) {
            this.crossRefTag = teXObject.toString(teXParser);
            stringBuilder.append('[');
            stringBuilder.append(this.crossRefTag);
            stringBuilder.append(']');
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObjectList)).size()) == 0) {
            return;
        }
        this.crossRefs = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = (TeXObject)csvList.get(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            this.crossRefs[i] = teXObject2.toString(teXParser);
            String string = this.processLabel(this.crossRefs[i]);
            this.addDependency(string);
            stringBuilder.append(string);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        this.putField("see", stringBuilder.toString());
    }

    private void initAlsoCrossRefs(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        CsvList csvList;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        if (!this.bib2gls.isKnownField("seealso")) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.field.unsupported", "seealso", "1.16"));
            this.crossRefTag = "\\seealsoname ";
            stringBuilder.append("[\\seealsoname]");
            this.initSeeRef(teXParser, teXObjectList, stringBuilder);
            return;
        }
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObjectList)).size()) == 0) {
            return;
        }
        this.alsocrossRefs = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)csvList.get(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            this.alsocrossRefs[i] = teXObject.toString(teXParser);
            String string = this.processLabel(this.alsocrossRefs[i]);
            this.addDependency(string);
            stringBuilder.append(string);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        this.putField("seealso", stringBuilder.toString());
    }

    public void setCollationKey(CollationKey collationKey) {
        this.collationKey = collationKey;
    }

    public CollationKey getCollationKey() {
        return this.collationKey;
    }

    public static Bib2GlsEntry getEntry(String string, Vector<Bib2GlsEntry> vector) {
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            if (!bib2GlsEntry.getId().equals(string)) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    public int getLevel(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        if (string == null) {
            return 0;
        }
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry != null) {
            return bib2GlsEntry.getLevel(vector) + 1;
        }
        return 0;
    }

    public void moveUpHierarchy(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        String string2 = this.getId();
        if (string == null) {
            return;
        }
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        String string3 = null;
        if (bib2GlsEntry != null) {
            bib2GlsEntry.removeChild(string2);
            string3 = bib2GlsEntry.getParent();
        }
        if (string3 == null) {
            this.removeField("parent");
            this.removeFieldValue("parent");
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string3, vector);
        if (bib2GlsEntry2 == null) {
            return;
        }
        bib2GlsEntry2.addChild(this);
        this.putField("parent", bib2GlsEntry.getField("parent"));
        this.putField("parent", string3);
    }

    private void addHierarchy(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        if (this.hierarchy.contains(bib2GlsEntry)) {
            throw new Bib2GlsException(this.bib2gls.getMessage("error.cyclic.hierarchy", bib2GlsEntry.getId()));
        }
        this.hierarchy.add(0, bib2GlsEntry);
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry2 != null) {
            this.addHierarchy(bib2GlsEntry2, vector);
        }
    }

    public void updateHierarchy(Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        this.hierarchy = new Vector();
        this.addHierarchy(this, vector);
    }

    public int getHierarchyCount() {
        return this.hierarchy == null ? 0 : this.hierarchy.size();
    }

    public Bib2GlsEntry getHierarchyElement(int n) {
        return this.hierarchy.get(n);
    }

    public Number getNumericSort() {
        return this.numericSort;
    }

    public void setNumericSort(Number number) {
        this.numericSort = number;
    }

    public void addChild(Bib2GlsEntry bib2GlsEntry) {
        if (this.children == null) {
            this.children = new Vector();
        }
        if (!this.children.contains(bib2GlsEntry)) {
            this.children.add(bib2GlsEntry);
        }
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Vector<Bib2GlsEntry> getChildren() {
        return this.children;
    }

    public Bib2GlsEntry getChild(int n) {
        return this.children.get(n);
    }

    private Bib2GlsEntry removeChild(String string) {
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getId().equals(string)) continue;
            return this.children.remove(i);
        }
        return null;
    }
}

