/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.latex.Section;
import java.io.IOException;

public class L2HSection
extends Section {
    private static final String[][] TAGS = new String[][]{{"chapter", "h1"}, {"section", "h2"}, {"subsection", "h3"}, {"subsubsection", "h4"}, {"paragraph", "h5"}};

    public L2HSection() {
        this("section");
    }

    public L2HSection(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HSection(this.getName());
    }

    @Override
    protected void unnumbered(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = this.getTag();
        if (string == null) {
            l2HConverter.write("<div class=\"" + this.getName() + "\">");
        } else {
            l2HConverter.write("<" + string + ">");
        }
        Object object = teXParser.getControlSequence("theH" + this.getName() + "*");
        if (object == null) {
            object = teXParser.getControlSequence("the" + this.getName() + "*");
        }
        if (object != null) {
            Object object2;
            if (object instanceof Expandable && (object2 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)object).expandfully(teXParser) : ((Expandable)object).expandfully(teXParser, teXObjectList)) != null) {
                object = object2;
            }
            object2 = this.getName() + "*";
            l2HConverter.write(String.format("<a name=\"%s\"></a>", HtmlTag.getUriFragment((String)object2 + "." + object.toString(teXParser))));
            l2HConverter.stepcounter((String)object2);
        }
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        if (string == null) {
            l2HConverter.write("</div>");
        } else {
            l2HConverter.write("</" + string + ">");
        }
    }

    @Override
    protected void numbered(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        String string = this.getTag();
        if (string == null) {
            teXObjectList2.add(new HtmlTag("<div class=\"" + this.getName() + "\">"));
        } else {
            teXObjectList2.add(new HtmlTag("<" + string + ">"));
        }
        teXObjectList2.add(l2HConverter.getControlSequence("the" + this.getName()));
        teXObjectList2.add(l2HConverter.getOther(46));
        teXObjectList2.add(l2HConverter.getSpace());
        TeXObject teXObject3 = teXParser == teXObjectList || teXObjectList == null ? teXParser.popStack() : teXObjectList.popStack(teXParser);
        while (teXObject3 instanceof WhiteSpace || teXObject3.isPar()) {
            if (teXParser == teXObjectList || teXObjectList == null) {
                teXObject3 = teXParser.popStack();
                continue;
            }
            teXObject3 = teXObjectList.popStack(teXParser);
        }
        if (teXObject3 instanceof TeXCsRef) {
            teXObject3 = l2HConverter.getControlSequence(((TeXCsRef)teXObject3).getName());
        }
        if (teXObject3 instanceof Label) {
            TeXObjectList teXObjectList3;
            TeXObject teXObject4 = teXParser == teXObjectList || teXObjectList == null ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
            if (teXObject4 instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject4)).expandfully(teXParser) : ((Expandable)((Object)teXObject4)).expandfully(teXParser, teXObjectList)) != null) {
                teXObject4 = teXObjectList3;
            }
            teXObjectList2.add(1, new HtmlTag("<a name=\"" + HtmlTag.getUriFragment(teXObject4.toString(teXParser)) + "\">"));
            teXObjectList2.add(new HtmlTag("</a>"));
        } else {
            if (teXParser == teXObjectList || teXObjectList == null) {
                teXParser.push(teXObject3);
            } else {
                teXObjectList.push(teXObject3);
            }
            TeXObject teXObject5 = teXParser.getControlSequence("theH" + this.getName());
            if (teXObject5 == null) {
                teXObject5 = teXParser.getControlSequence("the" + this.getName());
            }
            if (teXObject5 != null) {
                TeXObjectList teXObjectList4;
                if (teXObject5 instanceof Expandable && (teXObjectList4 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject5)).expandfully(teXParser) : ((Expandable)((Object)teXObject5)).expandfully(teXParser, teXObjectList)) != null) {
                    teXObject5 = teXObjectList4;
                }
                teXObjectList2.add(1, new HtmlTag("<a name=\"" + HtmlTag.getUriFragment(this.getName() + "." + teXObject5.toString(teXParser)) + "\">"));
                teXObjectList2.add(new HtmlTag("</a>"));
            }
        }
        teXObjectList2.add(teXObject2);
        if (string == null) {
            teXObjectList2.add(new HtmlTag("</div>"));
        } else {
            teXObjectList2.add(new HtmlTag("</" + string + ">"));
        }
        if (teXParser == teXObjectList || teXObjectList == null) {
            if (!TeXParser.isPar(teXParser.peekStack())) {
                teXObjectList2.add(l2HConverter.getPar());
            }
            teXObjectList2.process(teXParser);
        } else {
            if (!TeXParser.isPar(teXObjectList.peekStack())) {
                teXObjectList2.add(l2HConverter.getPar());
            }
            teXObjectList2.process(teXParser, teXObjectList);
        }
    }

    public String getTag() {
        String string = this.getName();
        for (int i = 0; i < TAGS.length; ++i) {
            if (!TAGS[i][0].equals(string)) continue;
            return TAGS[i][1];
        }
        return null;
    }
}

