#ifndef EFL_IMAGE_EO_HH
#define EFL_IMAGE_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_image.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { 
struct Image;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Image> : ::std::true_type {}; } }
namespace efl { 
struct Image;
} 

namespace eo_cxx {
namespace efl { 
struct Image {
   ::efl::eolian::return_traits<bool>::type smooth_scale_get() const;
   ::efl::eolian::return_traits<void>::type smooth_scale_set( ::efl::eolian::in_traits<bool>::type smooth_scale) const;
   ::efl::eolian::return_traits<double>::type ratio_get() const;
   ::efl::eolian::return_traits<void>::type border_get( ::efl::eolian::out_traits<int>::type l,  ::efl::eolian::out_traits<int>::type r,  ::efl::eolian::out_traits<int>::type t,  ::efl::eolian::out_traits<int>::type b) const;
   ::efl::eolian::return_traits<void>::type border_set( ::efl::eolian::in_traits<int>::type l,  ::efl::eolian::in_traits<int>::type r,  ::efl::eolian::in_traits<int>::type t,  ::efl::eolian::in_traits<int>::type b) const;
   ::efl::eolian::return_traits<double>::type border_scale_get() const;
   ::efl::eolian::return_traits<void>::type border_scale_set( ::efl::eolian::in_traits<double>::type scale) const;
   ::efl::eolian::return_traits<Efl_Gfx_Border_Fill_Mode>::type border_center_fill_get() const;
   ::efl::eolian::return_traits<void>::type border_center_fill_set( ::efl::eolian::in_traits<Efl_Gfx_Border_Fill_Mode>::type fill) const;
   ::efl::eolian::return_traits<void>::type image_size_get( ::efl::eolian::out_traits<int>::type w,  ::efl::eolian::out_traits<int>::type h) const;
   ::efl::eolian::return_traits<Efl_Image_Content_Hint>::type content_hint_get() const;
   ::efl::eolian::return_traits<void>::type content_hint_set( ::efl::eolian::in_traits<Efl_Image_Content_Hint>::type hint) const;
   ::efl::eolian::return_traits<Efl_Image_Scale_Hint>::type scale_hint_get() const;
   ::efl::eolian::return_traits<void>::type scale_hint_set( ::efl::eolian::in_traits<Efl_Image_Scale_Hint>::type hint) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IMAGE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Image() const;
   operator ::efl::Image&();
   operator ::efl::Image const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Image> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Image const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Image : ::efl::eo::concrete
{
   explicit Image( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Image(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Image(Image const& other) = default;
   Image(Image&& other) = default;
   Image& operator=(Image const& other) = default;
   Image& operator=(Image&& other) = default;
   Image()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Image( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Image(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<bool>::type smooth_scale_get() const;
   ::efl::eolian::return_traits<void>::type smooth_scale_set( ::efl::eolian::in_traits<bool>::type smooth_scale) const;
   ::efl::eolian::return_traits<double>::type ratio_get() const;
   ::efl::eolian::return_traits<void>::type border_get( ::efl::eolian::out_traits<int>::type l,  ::efl::eolian::out_traits<int>::type r,  ::efl::eolian::out_traits<int>::type t,  ::efl::eolian::out_traits<int>::type b) const;
   ::efl::eolian::return_traits<void>::type border_set( ::efl::eolian::in_traits<int>::type l,  ::efl::eolian::in_traits<int>::type r,  ::efl::eolian::in_traits<int>::type t,  ::efl::eolian::in_traits<int>::type b) const;
   ::efl::eolian::return_traits<double>::type border_scale_get() const;
   ::efl::eolian::return_traits<void>::type border_scale_set( ::efl::eolian::in_traits<double>::type scale) const;
   ::efl::eolian::return_traits<Efl_Gfx_Border_Fill_Mode>::type border_center_fill_get() const;
   ::efl::eolian::return_traits<void>::type border_center_fill_set( ::efl::eolian::in_traits<Efl_Gfx_Border_Fill_Mode>::type fill) const;
   ::efl::eolian::return_traits<void>::type image_size_get( ::efl::eolian::out_traits<int>::type w,  ::efl::eolian::out_traits<int>::type h) const;
   ::efl::eolian::return_traits<Efl_Image_Content_Hint>::type content_hint_get() const;
   ::efl::eolian::return_traits<void>::type content_hint_set( ::efl::eolian::in_traits<Efl_Image_Content_Hint>::type hint) const;
   ::efl::eolian::return_traits<Efl_Image_Scale_Hint>::type scale_hint_get() const;
   ::efl::eolian::return_traits<void>::type scale_hint_set( ::efl::eolian::in_traits<Efl_Image_Scale_Hint>::type hint) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IMAGE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct preload_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IMAGE_EVENT_PRELOAD; }
      typedef void parameter_type;
   } const preload_event;
   static struct resize_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IMAGE_EVENT_RESIZE; }
      typedef void parameter_type;
   } const resize_event;
   static struct unload_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IMAGE_EVENT_UNLOAD; }
      typedef void parameter_type;
   } const unload_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Image> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Image const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Image) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Image>::value, "");
} 
#endif
