/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.MemoryUsageCompositeData;

public class MemoryNotifInfoCompositeData
extends LazyCompositeData {
    private final MemoryNotificationInfo memoryNotifInfo;
    private static final CompositeType memoryNotifInfoCompositeType;
    private static final String POOL_NAME = "poolName";
    private static final String USAGE = "usage";
    private static final String COUNT = "count";
    private static final String[] memoryNotifInfoItemNames;
    private static final long serialVersionUID = -1805123446483771291L;

    private MemoryNotifInfoCompositeData(MemoryNotificationInfo info) {
        this.memoryNotifInfo = info;
    }

    public MemoryNotificationInfo getMemoryNotifInfo() {
        return this.memoryNotifInfo;
    }

    public static CompositeData toCompositeData(MemoryNotificationInfo info) {
        MemoryNotifInfoCompositeData mnicd = new MemoryNotifInfoCompositeData(info);
        return mnicd.getCompositeData();
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] memoryNotifInfoItemValues = new Object[]{this.memoryNotifInfo.getPoolName(), MemoryUsageCompositeData.toCompositeData(this.memoryNotifInfo.getUsage()), new Long(this.memoryNotifInfo.getCount())};
        try {
            return new CompositeDataSupport(memoryNotifInfoCompositeType, memoryNotifInfoItemNames, memoryNotifInfoItemValues);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getPoolName(CompositeData cd) {
        String poolname = MemoryNotifInfoCompositeData.getString(cd, POOL_NAME);
        if (poolname == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute poolName has null value");
        }
        return poolname;
    }

    public static MemoryUsage getUsage(CompositeData cd) {
        CompositeData usageData = (CompositeData)cd.get(USAGE);
        return MemoryUsage.from(usageData);
    }

    public static long getCount(CompositeData cd) {
        return MemoryNotifInfoCompositeData.getLong(cd, COUNT);
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!MemoryNotifInfoCompositeData.isTypeMatched(memoryNotifInfoCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for MemoryNotificationInfo");
        }
    }

    static {
        try {
            memoryNotifInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(MemoryNotificationInfo.class);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
        memoryNotifInfoItemNames = new String[]{POOL_NAME, USAGE, COUNT};
    }
}

