/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpPacket;

public final class JdpBroadcaster {
    private final InetAddress addr;
    private final int port;
    private final DatagramChannel channel;

    public JdpBroadcaster(InetAddress address, InetAddress srcAddress, int port, int ttl) throws IOException, JdpException {
        this.addr = address;
        this.port = port;
        StandardProtocolFamily family = address instanceof Inet6Address ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.channel = DatagramChannel.open(family);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)ttl);
        if (srcAddress != null) {
            NetworkInterface interf = NetworkInterface.getByInetAddress(srcAddress);
            try {
                this.channel.bind(new InetSocketAddress(srcAddress, 0));
            }
            catch (UnsupportedAddressTypeException ex) {
                throw new JdpException("Unable to bind to source address");
            }
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, interf);
        }
    }

    public JdpBroadcaster(InetAddress address, int port, int ttl) throws IOException, JdpException {
        this(address, null, port, ttl);
    }

    public void sendPacket(JdpPacket packet) throws IOException {
        byte[] data = packet.getPacketData();
        ByteBuffer b = ByteBuffer.wrap(data);
        this.channel.send(b, new InetSocketAddress(this.addr, this.port));
    }

    public void shutdown() throws IOException {
        this.channel.close();
    }
}

