/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;
import org.netbeans.lib.profiler.utils.StringUtils;

public class ClassFileParser
implements JavaClassConstants {
    private ClassInfo classInfo;
    private byte[] classBuf;
    private Object[] cpObjectCache;
    private int[] cpOffsets;
    private byte[] cpTags;
    private int curBufPos;

    public void parseClassFile(byte[] byArray, ClassInfo classInfo) throws ClassFileReadException {
        this.classBuf = byArray;
        this.classInfo = classInfo;
        this.curBufPos = 0;
        try {
            this.readPreamble();
            this.readConstantPool();
            this.readIntermediate();
            this.skipFields();
            this.readMethods();
            this.readAttributes();
        }
        catch (ClassFileReadRuntimeException classFileReadRuntimeException) {
            throw new ClassFileReadException(classFileReadRuntimeException);
        }
    }

    private char getChar(int n) {
        return (char)(((this.classBuf[n++] & 0xFF) << 8) + (this.classBuf[n++] & 0xFF));
    }

    private void badCPEntry(int n) {
        throw this.classFileReadException("Constant pool entry " + n + " : invalid type");
    }

    private void badCPReference(int n, int n2) {
        throw this.classFileReadException("Bad constant pool reference: " + n + " from entry " + n2);
    }

    private ClassFileReadRuntimeException classFileReadException(String string) {
        string = "Error reading class " + this.classInfo.name + ":\n" + string;
        return new ClassFileReadRuntimeException(string);
    }

    private String classNameAtCPIndex(int n) {
        if (this.cpTags[n] != 1) {
            throw this.classFileReadException("Constant pool entry " + n + " should be UTF8 constant");
        }
        int n2 = 0;
        if (this.cpObjectCache[n] == null) {
            int n3;
            int n4 = this.getChar(this.cpOffsets[n]);
            int n5 = n3 = this.cpOffsets[n] + 2;
            while (this.classBuf[n3] == 91) {
                ++n3;
                ++n2;
            }
            if (n3 != n5 && this.classBuf[n3] == 76) {
                ++n3;
                --n4;
            }
            String string = StringUtils.utf8ToString(this.classBuf, n3, n4 -= n3 - n5);
            for (int i = 0; i < n2; ++i) {
                string = "[" + string;
            }
            this.cpObjectCache[n] = string;
        }
        return (String)this.cpObjectCache[n];
    }

    private ClassFileReadRuntimeException dataFormatError() {
        return this.classFileReadException("Data format error");
    }

    private char nextChar() {
        return (char)(((this.classBuf[this.curBufPos++] & 0xFF) << 8) + (this.classBuf[this.curBufPos++] & 0xFF));
    }

    private int nextInt() {
        return ((this.classBuf[this.curBufPos++] & 0xFF) << 24) + ((this.classBuf[this.curBufPos++] & 0xFF) << 16) + ((this.classBuf[this.curBufPos++] & 0xFF) << 8) + (this.classBuf[this.curBufPos++] & 0xFF);
    }

    private void readAttributes() {
        this.classInfo.attrsStartOfs = this.curBufPos;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            char c = this.nextChar();
            int n2 = this.nextInt();
            if (this.utf8AtCPIndex(c).equals("InnerClasses")) {
                int n3 = this.nextChar();
                String[] stringArray = new String[n3];
                int n4 = 0;
                int n5 = 0;
                for (int j = 0; j < n3; ++j) {
                    char c2 = this.nextChar();
                    char c3 = this.nextChar();
                    char c4 = this.nextChar();
                    char c5 = this.nextChar();
                    String string = this.classNameAtCPIndex(this.getChar(this.cpOffsets[c2]));
                    if (c4 != '\u0000') {
                        String string2 = this.utf8AtCPIndex(c4);
                        if (!string.equals(this.classInfo.name + "$" + string2)) {
                            int n6 = n5 + 1;
                            if (!string.equals(this.classInfo.name + "$" + n6 + "$" + string2)) continue;
                            n5 = n6;
                        }
                    } else if (!string.equals(this.classInfo.name + "$" + ++n5)) continue;
                    stringArray[n4++] = string;
                }
                if (n4 == n3) {
                    this.classInfo.nestedClassNames = stringArray;
                    break;
                }
                if (n4 <= 0) break;
                this.classInfo.nestedClassNames = new String[n4];
                System.arraycopy(stringArray, 0, this.classInfo.nestedClassNames, 0, n4);
                break;
            }
            this.curBufPos += n2;
        }
    }

    private void readConstantPool() {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.classInfo.cpoolStartOfs = this.curBufPos;
        this.classInfo.origCPoolCount = this.nextChar();
        this.cpOffsets = new int[this.classInfo.origCPoolCount];
        this.cpTags = new byte[this.classInfo.origCPoolCount];
        int n4 = this.curBufPos;
        int n5 = 1;
        block9: while (n5 < this.cpOffsets.length) {
            n = this.classBuf[this.curBufPos++];
            this.cpOffsets[n5] = this.curBufPos;
            this.cpTags[n5] = n;
            ++n5;
            switch (n) {
                case 1: {
                    char c = this.nextChar();
                    this.curBufPos += c;
                    continue block9;
                }
                case 7: {
                    ++n3;
                }
                case 8: 
                case 16: {
                    this.curBufPos += 2;
                    continue block9;
                }
                case 15: {
                    this.curBufPos += 3;
                    continue block9;
                }
                case 3: 
                case 4: 
                case 9: 
                case 12: 
                case 18: {
                    this.curBufPos += 4;
                    continue block9;
                }
                case 10: 
                case 11: {
                    ++n2;
                    this.curBufPos += 4;
                    continue block9;
                }
                case 5: 
                case 6: {
                    this.curBufPos += 8;
                    ++n5;
                    continue block9;
                }
            }
            throw this.classFileReadException("Bad constant pool tag: " + n + " at " + Integer.toString(this.curBufPos - 1));
        }
        this.classInfo.cpoolRefsToMethodIdx = new char[n2];
        this.classInfo.cpoolRefsToMethodClassNameAndSig = new String[n2][3];
        this.classInfo.cpoolRefsToClassIdx = new char[n3];
        this.classInfo.cpoolRefsToClassName = new String[n3];
        n = 0;
        int n6 = 0;
        this.cpObjectCache = new Object[this.cpOffsets.length];
        for (n5 = 0; n5 < this.cpOffsets.length; ++n5) {
            int n7 = this.cpOffsets[n5];
            if (this.cpTags[n5] == 10 || this.cpTags[n5] == 11) {
                this.classInfo.cpoolRefsToMethodIdx[n] = (char)n5;
                this.classInfo.cpoolRefsToMethodClassNameAndSig[n] = new String[3];
                char c = this.getChar(n7);
                char c2 = this.getChar(n7 + 2);
                if (this.cpTags[c] != 7 || this.cpTags[c2] != 12) {
                    this.badCPReference(n7, n5);
                }
                this.classInfo.cpoolRefsToMethodClassNameAndSig[n][0] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[c]));
                n7 = this.cpOffsets[c2];
                char c3 = this.getChar(n7);
                char c4 = this.getChar(n7 + 2);
                if (this.cpTags[c3] != 1 || this.cpTags[c4] != 1) {
                    this.badCPReference(n7, n5);
                }
                this.classInfo.cpoolRefsToMethodClassNameAndSig[n][1] = this.utf8AtCPIndex(c3);
                this.classInfo.cpoolRefsToMethodClassNameAndSig[n][2] = this.signatureAtCPIndex(c4);
                ++n;
                continue;
            }
            if (this.cpTags[n5] != 7) continue;
            this.classInfo.cpoolRefsToClassIdx[n6] = (char)n5;
            this.classInfo.cpoolRefsToClassName[n6] = this.classNameAtCPIndex(this.getChar(n7));
            ++n6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readIntermediate() {
        this.classInfo.intermediateDataStartOfs = this.curBufPos;
        this.classInfo.accessFlags = this.nextChar();
        char c = this.nextChar();
        this.classInfo.classIndex = c;
        if (this.cpTags[c] != 7) {
            throw this.classFileReadException("Bad reference to this class name");
        }
        this.classInfo.name = this.classNameAtCPIndex(this.getChar(this.cpOffsets[c]));
        char c2 = this.nextChar();
        if (this.cpTags[c2] != 7) {
            if (c2 != '\u0000' || !this.classInfo.name.equals("java/lang/Object")) throw this.classFileReadException("Bad reference to super class name");
            this.classInfo.superName = "java/lang/Object";
        } else {
            this.classInfo.superName = this.classNameAtCPIndex(this.getChar(this.cpOffsets[c2]));
        }
        int n = this.nextChar();
        if (n == 0) return;
        this.classInfo.interfaces = new String[n];
        for (int i = 0; i < n; ++i) {
            c = this.nextChar();
            if (this.cpTags[c] != 7) {
                throw this.classFileReadException("Bad reference to an implemented interface");
            }
            this.classInfo.interfaces[i] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[c]));
        }
    }

    private void readMethods() {
        this.classInfo.methodsStartOfs = this.curBufPos;
        int n = this.nextChar();
        if (n == 0) {
            this.classInfo.methodNames = new String[0];
            return;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        char[] cArray2 = new char[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        char[] cArray3 = new char[n];
        int[] nArray6 = new int[n];
        char[] cArray4 = new char[n];
        int n2 = 0;
        int[] nArray7 = new int[n];
        char[] cArray5 = new char[n];
        int n3 = 0;
        int[] nArray8 = new int[n];
        char[] cArray6 = new char[n];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.curBufPos;
            cArray[i] = this.nextChar();
            stringArray[i] = this.utf8AtCPIndex(this.nextChar());
            stringArray2[i] = this.signatureAtCPIndex(this.nextChar());
            nArray3[i] = 0;
            nArray5[i] = 0;
            nArray6[i] = 0;
            nArray7[i] = 0;
            int n5 = this.nextChar();
            for (int j = 0; j < n5; ++j) {
                char c = this.nextChar();
                int n6 = this.nextInt();
                if (this.utf8AtCPIndex(c).equals("Code")) {
                    this.curBufPos += 4;
                    char c2 = cArray2[i] = (char)this.nextInt();
                    nArray3[i] = this.curBufPos - nArray[i];
                    this.curBufPos += c2;
                    nArray4[i] = this.curBufPos - nArray[i];
                    int n7 = this.nextChar();
                    this.curBufPos += 8 * n7;
                    n7 = this.nextChar();
                    for (int k = 0; k < n7; ++k) {
                        char c3;
                        c = this.nextChar();
                        n6 = this.nextInt();
                        if (this.utf8AtCPIndex(c).equals("LineNumberTable")) {
                            c3 = cArray3[i] = this.nextChar();
                            nArray5[i] = this.curBufPos - nArray[i];
                            this.curBufPos += 4 * c3;
                            continue;
                        }
                        if (this.utf8AtCPIndex(c).equals("LocalVariableTable")) {
                            c3 = cArray4[i] = this.nextChar();
                            nArray6[i] = this.curBufPos - nArray[i];
                            this.curBufPos += 10 * c3;
                            if (n2 == 0) {
                                n2 = c;
                                continue;
                            }
                            assert (n2 == c);
                            continue;
                        }
                        if (this.utf8AtCPIndex(c).equals("LocalVariableTypeTable")) {
                            c3 = cArray5[i] = this.nextChar();
                            nArray7[i] = this.curBufPos - nArray[i];
                            this.curBufPos += 10 * c3;
                            if (n3 == 0) {
                                n3 = c;
                                continue;
                            }
                            assert (n3 == c);
                            continue;
                        }
                        if (this.utf8AtCPIndex(c).equals("StackMapTable")) {
                            c3 = cArray6[i] = this.nextChar();
                            nArray8[i] = this.curBufPos - nArray[i];
                            this.curBufPos += n6 - 2;
                            if (n4 == 0) {
                                n4 = c;
                                continue;
                            }
                            assert (n4 == c);
                            continue;
                        }
                        this.curBufPos += n6;
                    }
                    continue;
                }
                this.curBufPos += n6;
            }
            nArray2[i] = this.curBufPos - nArray[i];
        }
        this.classInfo.methodNames = stringArray;
        this.classInfo.methodSignatures = stringArray2;
        this.classInfo.methodAccessFlags = cArray;
        this.classInfo.methodInfoOffsets = nArray;
        this.classInfo.methodInfoLengths = nArray2;
        this.classInfo.methodBytecodesOffsets = nArray3;
        this.classInfo.methodBytecodesLengths = cArray2;
        this.classInfo.exceptionTableStartOffsets = nArray4;
        this.classInfo.lineNumberTablesOffsets = nArray5;
        this.classInfo.lineNumberTablesLengths = cArray3;
        this.classInfo.localVariableTablesOffsets = nArray6;
        this.classInfo.localVariableTablesLengths = cArray4;
        this.classInfo.localVaribaleTableCPindex = n2;
        this.classInfo.localVariableTypeTablesOffsets = nArray7;
        this.classInfo.localVariableTypeTablesLengths = cArray5;
        this.classInfo.localVaribaleTypeTableCPindex = n3;
        this.classInfo.stackMapTablesOffsets = nArray8;
        this.classInfo.stackMapTablesLengths = cArray6;
        this.classInfo.stackMapTableCPindex = n4;
    }

    private void readPreamble() {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.classFileReadException("Illegal start of class file");
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 > '5' || c2 * 1000 + c < 45003) {
            String string = c2 + "." + c;
            String string2 = "Unsupported class file version: " + string;
            throw this.classFileReadException(string2);
        }
        this.classInfo.majorVersion = c2;
    }

    private String signatureAtCPIndex(int n) {
        return this.utf8AtCPIndex(n);
    }

    private void skipFields() {
        this.classInfo.fieldsStartOfs = this.curBufPos;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.curBufPos += 6;
            int n2 = this.nextChar();
            for (int j = 0; j < n2; ++j) {
                this.curBufPos += 2;
                int n3 = this.nextInt();
                this.curBufPos += n3;
            }
        }
    }

    private String utf8AtCPIndex(int n) {
        if (this.cpTags[n] != 1) {
            throw this.classFileReadException("Constant pool entry " + n + " should be UTF8 constant");
        }
        if (this.cpObjectCache[n] == null) {
            char c = this.getChar(this.cpOffsets[n]);
            this.cpObjectCache[n] = StringUtils.utf8ToString(this.classBuf, this.cpOffsets[n] + 2, c);
        }
        return (String)this.cpObjectCache[n];
    }

    private static class ClassFileReadRuntimeException
    extends RuntimeException {
        public ClassFileReadRuntimeException(String string) {
            super(string);
        }
    }

    public static class ClassFileReadException
    extends Exception {
        ClassFileReadRuntimeException e;

        private ClassFileReadException(ClassFileReadRuntimeException classFileReadRuntimeException) {
            this.e = classFileReadRuntimeException;
        }

        @Override
        public Throwable getCause() {
            return this.e;
        }

        @Override
        public String getMessage() {
            return this.e.getMessage();
        }

        @Override
        public String toString() {
            return this.e.toString();
        }
    }
}

