/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.plugins.PluginLoaderIndirection;
import org.elasticsearch.threadpool.ExecutorBuilder;

public class PluginsService
extends AbstractComponent {
    private final Path configPath;
    private final List<Tuple<PluginInfo, Plugin>> plugins;
    private final PluginsAndModules info;
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.listSetting("plugin.mandatory", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);

    public List<Setting<?>> getPluginSettings() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettings().stream()).collect(Collectors.toList());
    }

    public List<String> getPluginSettingsFilter() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettingsFilter().stream()).collect(Collectors.toList());
    }

    public PluginsService(Settings settings, Path configPath, Path modulesDirectory, Path pluginsDirectory, Collection<Class<? extends Plugin>> classpathPlugins) {
        super(settings);
        this.configPath = configPath;
        ArrayList<Tuple<Object, Plugin>> pluginsLoaded = new ArrayList<Tuple<Object, Plugin>>();
        ArrayList<PluginInfo> pluginsList = new ArrayList<PluginInfo>();
        for (Class<? extends Plugin> pluginClass : classpathPlugins) {
            Plugin plugin = this.loadPlugin(pluginClass, settings, configPath);
            Iterator<Bundle> pluginInfo = new PluginInfo(pluginClass.getName(), "classpath plugin", "NA", pluginClass.getName(), Collections.emptyList(), false, false);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("plugin loaded from classpath [{}]", pluginInfo);
            }
            pluginsLoaded.add(new Tuple<Iterator<Bundle>, Plugin>(pluginInfo, plugin));
            pluginsList.add((PluginInfo)((Object)pluginInfo));
        }
        LinkedHashSet<Bundle> seenBundles = new LinkedHashSet<Bundle>();
        ArrayList<PluginInfo> modulesList = new ArrayList<PluginInfo>();
        if (modulesDirectory != null) {
            try {
                Set<Bundle> modules = PluginsService.getModuleBundles(modulesDirectory);
                for (Bundle bundle : modules) {
                    modulesList.add(bundle.plugin);
                }
                seenBundles.addAll(modules);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        }
        if (pluginsDirectory != null) {
            try {
                if (FileSystemUtils.isAccessibleDirectory(pluginsDirectory, this.logger)) {
                    PluginsService.checkForFailedPluginRemovals(pluginsDirectory);
                    Set<Bundle> plugins = PluginsService.getPluginBundles(pluginsDirectory);
                    for (Bundle bundle : plugins) {
                        pluginsList.add(bundle.plugin);
                    }
                    seenBundles.addAll(plugins);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        }
        List<Tuple<PluginInfo, Plugin>> loaded = this.loadBundles(seenBundles);
        pluginsLoaded.addAll(loaded);
        this.info = new PluginsAndModules(pluginsList, modulesList);
        this.plugins = Collections.unmodifiableList(pluginsLoaded);
        HashSet<String> pluginsNames = new HashSet<String>();
        for (Tuple<PluginInfo, Plugin> tuple : this.plugins) {
            pluginsNames.add(tuple.v1().getName());
        }
        List<String> list = MANDATORY_SETTING.get(settings);
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String mandatoryPlugin : list) {
                if (pluginsNames.contains(mandatoryPlugin) || hashSet.contains(mandatoryPlugin)) continue;
                hashSet.add(mandatoryPlugin);
            }
            if (!hashSet.isEmpty()) {
                throw new ElasticsearchException("Missing mandatory plugins [" + Strings.collectionToDelimitedString(hashSet, ", ") + "]", new Object[0]);
            }
        }
        PluginsService.logPluginInfo(this.info.getModuleInfos(), "module", this.logger);
        PluginsService.logPluginInfo(this.info.getPluginInfos(), "plugin", this.logger);
    }

    private static void logPluginInfo(List<PluginInfo> pluginInfos, String type, Logger logger) {
        assert (pluginInfos != null);
        if (pluginInfos.isEmpty()) {
            logger.info("no " + type + "s loaded");
        } else {
            for (String name : pluginInfos.stream().map(PluginInfo::getName).sorted().collect(Collectors.toList())) {
                logger.info("loaded " + type + " [" + name + "]");
            }
        }
    }

    public Settings updatedSettings() {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            Settings settings = plugin.v2().additionalSettings();
            for (String setting : settings.keySet()) {
                String oldPlugin = foundSettings.put(setting, plugin.v1().getName());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + plugin.v1().getName() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
        }
        return builder.put(this.settings).build();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            modules.addAll(plugin.v2().createGuiceModules());
        }
        return modules;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList builders = new ArrayList();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            builders.addAll(plugin.v2().getExecutorBuilders(settings));
        }
        return builders;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            services.addAll(plugin.v2().getGuiceServiceClasses());
        }
        return services;
    }

    public void onIndexModule(IndexModule indexModule) {
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            plugin.v2().onIndexModule(indexModule);
        }
    }

    public PluginsAndModules info() {
        return this.info;
    }

    static Set<Bundle> getModuleBundles(Path modulesDirectory) throws IOException {
        if (Files.notExists(modulesDirectory, new LinkOption[0])) {
            return Collections.emptySet();
        }
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(modulesDirectory);){
            for (Path module : stream) {
                PluginInfo info = PluginInfo.readFromProperties(module);
                if (bundles.add(new Bundle(info, module))) continue;
                throw new IllegalStateException("duplicate module: " + info);
            }
        }
        return bundles;
    }

    static void checkForFailedPluginRemovals(Path pluginsDirectory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDirectory, ".removing-*");){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path removing = iterator.next();
                String fileName = removing.getFileName().toString();
                String name = fileName.substring(1 + fileName.indexOf("-"));
                String message = String.format(Locale.ROOT, "found file [%s] from a failed attempt to remove the plugin [%s]; execute [elasticsearch-plugin remove %2$s]", removing, name);
                throw new IllegalStateException(message);
            }
        }
    }

    static Set<Bundle> getPluginBundles(Path pluginsDirectory) throws IOException {
        Logger logger = Loggers.getLogger(PluginsService.class);
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        List<Path> infos = PluginInfo.extractAllPlugins(pluginsDirectory);
        for (Path plugin : infos) {
            PluginInfo info;
            logger.trace("--- adding plugin [{}]", (Object)plugin.toAbsolutePath());
            try {
                info = PluginInfo.readFromProperties(plugin);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load plugin descriptor for existing plugin [" + plugin.getFileName() + "]. Was the plugin built before 2.0?", e);
            }
            if (bundles.add(new Bundle(info, plugin))) continue;
            throw new IllegalStateException("duplicate plugin: " + info);
        }
        return bundles;
    }

    static List<Bundle> sortBundles(Set<Bundle> bundles) {
        Map<String, Bundle> namedBundles = bundles.stream().collect(Collectors.toMap(b -> b.plugin.getName(), Function.identity()));
        LinkedHashSet<Bundle> sortedBundles = new LinkedHashSet<Bundle>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (Bundle bundle : bundles) {
            PluginsService.addSortedBundle(bundle, namedBundles, sortedBundles, dependencyStack);
        }
        return new ArrayList<Bundle>(sortedBundles);
    }

    private static void addSortedBundle(Bundle bundle, Map<String, Bundle> bundles, LinkedHashSet<Bundle> sortedBundles, LinkedHashSet<String> dependencyStack) {
        String name = bundle.plugin.getName();
        if (dependencyStack.contains(name)) {
            StringBuilder msg = new StringBuilder("Cycle found in plugin dependencies: ");
            dependencyStack.forEach(s -> {
                msg.append((String)s);
                msg.append(" -> ");
            });
            msg.append(name);
            throw new IllegalStateException(msg.toString());
        }
        if (sortedBundles.contains(bundle)) {
            return;
        }
        dependencyStack.add(name);
        for (String dependency : bundle.plugin.getExtendedPlugins()) {
            Bundle depBundle = bundles.get(dependency);
            if (depBundle == null) {
                throw new IllegalArgumentException("Missing plugin [" + dependency + "], dependency of [" + name + "]");
            }
            PluginsService.addSortedBundle(depBundle, bundles, sortedBundles, dependencyStack);
            assert (sortedBundles.contains(depBundle));
        }
        dependencyStack.remove(name);
        sortedBundles.add(bundle);
    }

    private List<Tuple<PluginInfo, Plugin>> loadBundles(Set<Bundle> bundles) {
        ArrayList<Tuple<PluginInfo, Plugin>> plugins = new ArrayList<Tuple<PluginInfo, Plugin>>();
        HashMap<String, Plugin> loaded = new HashMap<String, Plugin>();
        HashMap<String, Set<URL>> transitiveUrls = new HashMap<String, Set<URL>>();
        List<Bundle> sortedBundles = PluginsService.sortBundles(bundles);
        for (Bundle bundle : sortedBundles) {
            PluginsService.checkBundleJarHell(bundle, transitiveUrls);
            Plugin plugin = this.loadBundle(bundle, loaded);
            plugins.add(new Tuple<PluginInfo, Plugin>(bundle.plugin, plugin));
        }
        return Collections.unmodifiableList(plugins);
    }

    static void checkBundleJarHell(Bundle bundle, Map<String, Set<URL>> transitiveUrls) {
        List<String> exts = bundle.plugin.getExtendedPlugins();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String extendedPlugin : exts) {
                Set<URL> pluginUrls = transitiveUrls.get(extendedPlugin);
                assert (pluginUrls != null) : "transitive urls should have already been set for " + extendedPlugin;
                HashSet<Object> intersection = new HashSet(urls);
                intersection.retainAll(pluginUrls);
                if (!intersection.isEmpty()) {
                    throw new IllegalStateException("jar hell! extended plugins " + exts + " have duplicate codebases with each other: " + intersection);
                }
                intersection = new HashSet<URL>(bundle.urls);
                intersection.retainAll(pluginUrls);
                if (!intersection.isEmpty()) {
                    throw new IllegalStateException("jar hell! duplicate codebases with extended plugin [" + extendedPlugin + "]: " + intersection);
                }
                urls.addAll(pluginUrls);
                JarHell.checkJarHell(urls);
            }
            urls.addAll(bundle.urls);
            JarHell.checkJarHell(urls);
            transitiveUrls.put(bundle.plugin.getName(), urls);
            Set classpath = JarHell.parseClassPath();
            HashSet intersection = new HashSet(classpath);
            intersection.retainAll(bundle.urls);
            if (!intersection.isEmpty()) {
                throw new IllegalStateException("jar hell! duplicate codebases between plugin and core: " + intersection);
            }
            HashSet<URL> union = new HashSet<URL>(classpath);
            union.addAll(bundle.urls);
            JarHell.checkJarHell(union);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load plugin " + bundle.plugin.getName() + " due to jar hell", e);
        }
    }

    private Plugin loadBundle(Bundle bundle, Map<String, Plugin> loaded) {
        String name = bundle.plugin.getName();
        ArrayList<ClassLoader> extendedLoaders = new ArrayList<ClassLoader>();
        for (String extendedPluginName : bundle.plugin.getExtendedPlugins()) {
            Plugin extendedPlugin = loaded.get(extendedPluginName);
            assert (extendedPlugin != null);
            if (!ExtensiblePlugin.class.isInstance(extendedPlugin)) {
                throw new IllegalStateException("Plugin [" + name + "] cannot extend non-extensible plugin [" + extendedPluginName + "]");
            }
            extendedLoaders.add(extendedPlugin.getClass().getClassLoader());
        }
        ClassLoader parentLoader = PluginLoaderIndirection.createLoader(this.getClass().getClassLoader(), extendedLoaders);
        URLClassLoader loader = URLClassLoader.newInstance(bundle.urls.toArray(new URL[0]), parentLoader);
        PluginsService.reloadLuceneSPI(loader);
        for (String extendedPluginName : bundle.plugin.getExtendedPlugins()) {
            ((ExtensiblePlugin)ExtensiblePlugin.class.cast(loaded.get(extendedPluginName))).reloadSPI(loader);
        }
        Class<? extends Plugin> pluginClass = this.loadPluginClass(bundle.plugin.getClassname(), loader);
        Plugin plugin = this.loadPlugin(pluginClass, this.settings, this.configPath);
        loaded.put(name, plugin);
        return plugin;
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats((ClassLoader)loader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)loader);
        Codec.reloadCodecs((ClassLoader)loader);
        CharFilterFactory.reloadCharFilters((ClassLoader)loader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)loader);
        TokenizerFactory.reloadTokenizers((ClassLoader)loader);
    }

    private Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    private Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings, Path configPath) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public constructor for [" + pluginClass.getName() + "]");
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public constructor for [" + pluginClass.getName() + "]");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() > 2) {
            throw new IllegalStateException(this.signatureMessage(pluginClass));
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        try {
            if (constructor.getParameterCount() == 2 && parameterTypes[0] == Settings.class && parameterTypes[1] == Path.class) {
                return (Plugin)constructor.newInstance(settings, configPath);
            }
            if (constructor.getParameterCount() == 1 && parameterTypes[0] == Settings.class) {
                return (Plugin)constructor.newInstance(settings);
            }
            if (constructor.getParameterCount() == 0) {
                return (Plugin)constructor.newInstance(new Object[0]);
            }
            throw new IllegalStateException(this.signatureMessage(pluginClass));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to load plugin class [" + pluginClass.getName() + "]", e);
        }
    }

    private String signatureMessage(Class<? extends Plugin> clazz) {
        return String.format(Locale.ROOT, "no public constructor of correct signature for [%s]; must be [%s], [%s], or [%s]", clazz.getName(), "(org.elasticsearch.common.settings.Settings,java.nio.file.Path)", "(org.elasticsearch.common.settings.Settings)", "()");
    }

    public <T> List<T> filterPlugins(Class<T> type) {
        return this.plugins.stream().filter(x -> type.isAssignableFrom(((Plugin)x.v2()).getClass())).map(p -> p.v2()).collect(Collectors.toList());
    }

    static class Bundle {
        final PluginInfo plugin;
        final Set<URL> urls;

        Bundle(PluginInfo plugin, Path dir) throws IOException {
            this.plugin = Objects.requireNonNull(plugin);
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(dir, "*.jar");){
                for (Path jar : jarStream) {
                    URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                    if (urls.add(url)) continue;
                    throw new IllegalStateException("duplicate codebase: " + url);
                }
            }
            this.urls = Objects.requireNonNull(urls);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bundle bundle = (Bundle)o;
            return Objects.equals(this.plugin, bundle.plugin);
        }

        public int hashCode() {
            return Objects.hash(this.plugin);
        }
    }
}

