/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import javajs.api.ZInputStream;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptManager;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptQueueThread;
import org.jmol.thread.JmolThread;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class ScriptManager
implements JmolScriptManager {
    private Viewer vwr;
    private ScriptEval eval;
    private JmolScriptEvaluator evalTemp;
    private Thread[] queueThreads = new Thread[2];
    private boolean[] scriptQueueRunning = new boolean[2];
    private JmolThread commandWatcherThread;
    public Lst<Lst<Object>> scriptQueue = new Lst();
    private boolean useCommandWatcherThread = false;
    private int scriptIndex;
    private boolean isScriptQueued = true;
    private static int prevCovalentVersion = 1;

    @Override
    public Lst<Lst<Object>> getScriptQueue() {
        return this.scriptQueue;
    }

    @Override
    public boolean isScriptQueued() {
        return this.isScriptQueued;
    }

    @Override
    public JmolScriptEvaluator setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.eval = this.newScriptEvaluator();
        this.eval.setCompiler();
        return this.eval;
    }

    private ScriptEval newScriptEvaluator() {
        return ((ScriptEval)Interface.getInterface("org.jmol.script.ScriptEval", this.vwr, "setOptions")).setViewer(this.vwr);
    }

    @Override
    public void clear(boolean isAll) {
        if (!isAll) {
            this.evalTemp = null;
            return;
        }
        this.startCommandWatcher(false);
        this.interruptQueueThreads();
    }

    @Override
    public String addScript(String strScript, boolean isQuiet) {
        return (String)this.addScr("String", strScript, "", isQuiet);
    }

    private Object addScr(String returnType, String strScript, String statusList, boolean isQuiet) {
        if (!this.vwr.g.useScriptQueue) {
            this.clearQueue();
            this.vwr.haltScriptExecution();
        }
        if (this.commandWatcherThread == null && this.useCommandWatcherThread) {
            this.startCommandWatcher(true);
        }
        if (this.commandWatcherThread != null && strScript.indexOf("/*SPLIT*/") >= 0) {
            String[] scripts = PT.split(strScript, "/*SPLIT*/");
            for (int i = 0; i < scripts.length; ++i) {
                this.addScr(returnType, scripts[i], statusList, isQuiet);
            }
            return "split into " + scripts.length + " sections for processing";
        }
        boolean useCommandThread = this.commandWatcherThread != null && (strScript.indexOf("javascript") < 0 || strScript.indexOf("#javascript ") >= 0);
        Lst<Object> scriptItem = new Lst<Object>();
        scriptItem.addLast(strScript);
        scriptItem.addLast(statusList);
        scriptItem.addLast(returnType);
        scriptItem.addLast(isQuiet ? Boolean.TRUE : Boolean.FALSE);
        scriptItem.addLast(Integer.valueOf(useCommandThread ? -1 : 1));
        this.scriptQueue.addLast(scriptItem);
        this.startScriptQueue(false);
        return "pending";
    }

    @Override
    public void clearQueue() {
        this.scriptQueue.clear();
    }

    @Override
    public void waitForQueue() {
        if (this.vwr.isSingleThreaded) {
            return;
        }
        int n = 0;
        while (this.isQueueProcessing()) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0 || !Logger.debugging) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size() + " thread=" + Thread.currentThread().getName());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isQueueProcessing() {
        return this.queueThreads[0] != null || this.queueThreads[1] != null;
    }

    private synchronized void flushQueue(String command) {
        int i = this.scriptQueue.size();
        while (--i >= 0) {
            String strScript = (String)((Lst)this.scriptQueue.get(i)).get(0);
            if (strScript.indexOf(command) != 0) continue;
            this.scriptQueue.removeItemAt(i);
            if (!Logger.debugging) continue;
            Logger.debug(this.scriptQueue.size() + " scripts; removed: " + strScript);
        }
    }

    private void startScriptQueue(boolean startedByCommandWatcher) {
        int pt;
        int n = pt = startedByCommandWatcher ? 1 : 0;
        if (this.scriptQueueRunning[pt]) {
            return;
        }
        this.scriptQueueRunning[pt] = true;
        this.queueThreads[pt] = new ScriptQueueThread(this, this.vwr, startedByCommandWatcher, pt);
        this.queueThreads[pt].start();
    }

    @Override
    public Lst<Object> getScriptItem(boolean watching, boolean isByCommandWatcher) {
        if (this.vwr.isSingleThreaded && this.vwr.queueOnHold) {
            return null;
        }
        Lst scriptItem = (Lst)this.scriptQueue.get(0);
        int flag = (Integer)scriptItem.get(4);
        boolean isOK = watching ? flag < 0 : (isByCommandWatcher ? flag == 0 : flag == 1);
        return isOK ? scriptItem : null;
    }

    @Override
    public synchronized void startCommandWatcher(boolean isStart) {
        this.useCommandWatcherThread = isStart;
        if (isStart) {
            if (this.commandWatcherThread != null) {
                return;
            }
            this.commandWatcherThread = (JmolThread)Interface.getInterface("org.jmol.script.CommandWatcherThread", this.vwr, "setOptions");
            this.commandWatcherThread.setManager(this, this.vwr, null);
            this.commandWatcherThread.start();
        } else {
            if (this.commandWatcherThread == null) {
                return;
            }
            this.clearCommandWatcherThread();
        }
        if (Logger.debugging) {
            Logger.debug("command watcher " + (isStart ? "started" : "stopped") + this.commandWatcherThread);
        }
    }

    void interruptQueueThreads() {
        for (int i = 0; i < this.queueThreads.length; ++i) {
            if (this.queueThreads[i] == null) continue;
            this.queueThreads[i].interrupt();
        }
    }

    public void clearCommandWatcherThread() {
        if (this.commandWatcherThread == null) {
            return;
        }
        this.commandWatcherThread.interrupt();
        this.commandWatcherThread = null;
    }

    @Override
    public void queueThreadFinished(int pt) {
        this.queueThreads[pt].interrupt();
        this.scriptQueueRunning[pt] = false;
        this.queueThreads[pt] = null;
        this.vwr.setSyncDriver(4);
        this.vwr.queueOnHold = false;
    }

    public void runScriptNow() {
        Lst<Object> scriptItem;
        if (this.scriptQueue.size() > 0 && (scriptItem = this.getScriptItem(true, true)) != null) {
            scriptItem.set(4, 0);
            this.startScriptQueue(true);
        }
    }

    @Override
    public String evalFile(String strFilename) {
        int ptWait = strFilename.indexOf(" -noqueue");
        if (ptWait >= 0) {
            return (String)this.evalStringWaitStatusQueued("String", "script " + PT.esc(strFilename.substring(0, ptWait)), "", false, false);
        }
        return this.addScript("script " + PT.esc(strFilename), false);
    }

    @Override
    public Object evalStringWaitStatusQueued(String returnType, String strScript, String statusList, boolean isQuiet, boolean isQueued) {
        boolean historyDisabled;
        if (strScript == null) {
            return null;
        }
        String str = this.checkScriptExecution(strScript, false);
        if (str != null) {
            return str;
        }
        SB outputBuffer = statusList == null || statusList.equals("output") ? new SB() : null;
        String oldStatusList = this.vwr.sm.statusList;
        this.vwr.getStatusChanged(statusList);
        if (this.vwr.isSyntaxCheck) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl = historyDisabled = strScript.indexOf(")") == 0;
        if (historyDisabled) {
            strScript = strScript.substring(1);
        }
        historyDisabled = historyDisabled || !isQueued;
        this.vwr.setErrorMessage(null, null);
        ScriptEval eval = isQueued ? this.eval : this.newScriptEvaluator();
        boolean isOK = eval.compileScriptString(strScript, isQuiet);
        String strErrorMessage = eval.getErrorMessage();
        String strErrorMessageUntranslated = eval.getErrorMessageUntranslated();
        this.vwr.setErrorMessage(strErrorMessage, strErrorMessageUntranslated);
        this.vwr.refresh(7, "script complete");
        if (isOK) {
            this.isScriptQueued = isQueued;
            if (!isQuiet) {
                this.vwr.setScriptStatus(null, strScript, -2 - ++this.scriptIndex, null);
            }
            eval.evaluateCompiledScript(this.vwr.isSyntaxCheck, this.vwr.isSyntaxAndFileCheck, historyDisabled, this.vwr.listCommands, outputBuffer, isQueued || !this.vwr.isSingleThreaded);
        } else {
            this.vwr.scriptStatus(strErrorMessage);
            this.vwr.setScriptStatus("Jmol script terminated", strErrorMessage, 1, strErrorMessageUntranslated);
            if (eval.isStateScript()) {
                ScriptManager.setStateScriptVersion(this.vwr, null);
            }
        }
        if (strErrorMessage != null && this.vwr.autoExit) {
            this.vwr.exitJmol();
        }
        if (this.vwr.isSyntaxCheck) {
            if (strErrorMessage == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + strErrorMessageUntranslated);
            }
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (returnType.equalsIgnoreCase("String")) {
            return strErrorMessageUntranslated;
        }
        if (outputBuffer != null) {
            return strErrorMessageUntranslated == null ? outputBuffer.toString() : strErrorMessageUntranslated;
        }
        Object info = this.vwr.getProperty(returnType, "jmolStatus", statusList);
        this.vwr.getStatusChanged(oldStatusList);
        return info;
    }

    private String checkScriptExecution(String strScript, boolean isInsert) {
        String str = strScript;
        if (str.indexOf("\u0001##") >= 0) {
            str = str.substring(0, str.indexOf("\u0001##"));
        }
        if (this.checkResume(str)) {
            return "script processing resumed";
        }
        if (this.checkStepping(str)) {
            return "script processing stepped";
        }
        if (this.checkHalt(str, isInsert)) {
            return "script execution halted";
        }
        return null;
    }

    private boolean checkResume(String str) {
        if (str.equalsIgnoreCase("resume")) {
            this.vwr.setScriptStatus("", "execution resumed", 0, null);
            this.eval.resumePausedExecution();
            return true;
        }
        return false;
    }

    private boolean checkStepping(String str) {
        if (str.equalsIgnoreCase("step")) {
            this.eval.stepPausedExecution();
            return true;
        }
        if (str.equalsIgnoreCase("?")) {
            this.vwr.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    @Override
    public String evalStringQuietSync(String strScript, boolean isQuiet, boolean allowSyncScript) {
        String msg;
        boolean isInsert;
        if (allowSyncScript && this.vwr.sm.syncingScripts && strScript.indexOf("#NOSYNC;") < 0) {
            this.vwr.syncScript(strScript + " #NOSYNC;", null, 0);
        }
        if (this.eval.isPaused() && strScript.charAt(0) != '!') {
            strScript = '!' + PT.trim(strScript, "\n\r\t ");
        }
        boolean bl = isInsert = strScript.length() > 0 && strScript.charAt(0) == '!';
        if (isInsert) {
            strScript = strScript.substring(1);
        }
        if ((msg = this.checkScriptExecution(strScript, isInsert)) != null) {
            return msg;
        }
        if (this.vwr.isScriptExecuting() && (isInsert || this.eval.isPaused())) {
            this.vwr.setInsertedCommand(strScript);
            if (strScript.indexOf("moveto ") == 0) {
                this.flushQueue("moveto ");
            }
            return "!" + strScript;
        }
        this.vwr.setInsertedCommand("");
        if (isQuiet) {
            strScript = strScript + "\u0001## EDITOR_IGNORE ##";
        }
        return this.addScript(strScript, isQuiet && !this.vwr.getBoolean(603979880));
    }

    @Override
    public boolean checkHalt(String str, boolean isInsert) {
        if (str.equalsIgnoreCase("pause")) {
            this.vwr.pauseScriptExecution();
            if (this.vwr.scriptEditorVisible) {
                this.vwr.setScriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        if (str.equalsIgnoreCase("menu")) {
            this.vwr.getProperty("DATA_API", "getPopupMenu", "\u0000");
            return true;
        }
        str = str.toLowerCase();
        boolean exitScript = false;
        String haltType = null;
        if (str.startsWith("exit")) {
            this.vwr.haltScriptExecution();
            this.vwr.clearScriptQueue();
            this.vwr.clearTimeouts();
            haltType = "exit";
            exitScript = str.equals("exit");
        } else if (str.startsWith("quit")) {
            this.vwr.haltScriptExecution();
            haltType = "quit";
            exitScript = str.equals("quit");
        }
        if (haltType == null) {
            return false;
        }
        if (isInsert) {
            this.vwr.clearThreads();
            this.vwr.queueOnHold = false;
        }
        if (isInsert || this.vwr.g.waitForMoveTo) {
            this.vwr.tm.stopMotion();
        }
        Logger.info(this.vwr.isSyntaxCheck ? haltType + " -- stops script checking" : (isInsert ? "!" : "") + haltType + " received");
        this.vwr.isSyntaxCheck = false;
        return exitScript;
    }

    @Override
    public BS getAtomBitSetEval(JmolScriptEvaluator eval, Object atomExpression) {
        if (eval == null && (eval = this.evalTemp) == null) {
            eval = this.evalTemp = this.newScriptEvaluator();
        }
        return this.vwr.slm.excludeAtoms(eval.getAtomBitSet(atomExpression), false);
    }

    @Override
    public Object scriptCheckRet(String strScript, boolean returnContext) {
        if (strScript.indexOf(")") == 0 || strScript.indexOf("!") == 0) {
            strScript = strScript.substring(1);
        }
        ScriptContext sc = this.newScriptEvaluator().checkScriptSilent(strScript);
        return returnContext || sc.errorMessage == null ? sc : sc.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFileAsync(String fileName, int flags) {
        block23: {
            String cmd;
            boolean noAutoPlay;
            boolean noScript;
            block19: {
                block22: {
                    String type;
                    boolean isCached;
                    boolean pdbCartoons;
                    boolean isAppend;
                    block20: {
                        block21: {
                            block17: {
                                block18: {
                                    noScript = (flags & 2) == 2;
                                    isAppend = (flags & 4) == 4;
                                    pdbCartoons = (flags & 1) == 1 && !isAppend;
                                    noAutoPlay = (flags & 8) == 8;
                                    cmd = null;
                                    if ((fileName = fileName.trim()).startsWith("\t")) {
                                        noScript = true;
                                        fileName = fileName.substring(1);
                                    }
                                    fileName = fileName.replace('\\', '/');
                                    isCached = fileName.startsWith("cache://");
                                    if (this.vwr.isApplet && fileName.indexOf("://") < 0) {
                                        fileName = "file://" + (fileName.startsWith("/") ? "" : "/") + fileName;
                                    }
                                    try {
                                        if (!fileName.endsWith(".pse")) break block17;
                                        cmd = (isCached ? "" : "zap;") + "load SYNC " + PT.esc(fileName) + (this.vwr.isApplet ? "" : " filter 'DORESIZE'");
                                        if (cmd == null) break block18;
                                        this.vwr.evalString(cmd + (noAutoPlay ? "#!NOAUTOPLAY" : ""));
                                    }
                                    catch (Throwable throwable) {
                                        if (cmd != null) {
                                            this.vwr.evalString(cmd + (noAutoPlay ? "#!NOAUTOPLAY" : ""));
                                        }
                                        throw throwable;
                                    }
                                }
                                return;
                            }
                            if (fileName.endsWith("jvxl")) {
                                cmd = "isosurface ";
                                break block19;
                            }
                            if (fileName.toLowerCase().endsWith(".spt")) break block19;
                            type = this.getDragDropFileTypeName(fileName);
                            if (type != null) break block20;
                            type = FileManager.determineSurfaceTypeIs(this.vwr.getBufferedInputStream(fileName));
                            if (type != null) {
                                cmd = "if (_filetype == 'Pdb') { isosurface sigma 1.0 within 2.0 {*} " + PT.esc(fileName) + " mesh nofill }; else; { isosurface " + PT.esc(fileName) + "}";
                            }
                            if (cmd == null) break block21;
                            this.vwr.evalString(cmd + (noAutoPlay ? "#!NOAUTOPLAY" : ""));
                        }
                        return;
                    }
                    if (type.equals("dssr")) {
                        cmd = "model {visible} property dssr ";
                        break block19;
                    }
                    if (type.equals("Jmol")) {
                        cmd = "script ";
                        break block19;
                    }
                    if (type.equals("Cube")) {
                        cmd = "isosurface sign red blue ";
                        break block19;
                    }
                    if (type.equals("spt")) break block19;
                    cmd = this.vwr.g.defaultDropScript;
                    cmd = PT.rep(cmd, "%FILE", fileName);
                    if ((cmd = PT.rep(cmd, "%ALLOWCARTOONS", "" + pdbCartoons)).toLowerCase().startsWith("zap") && (isCached || isAppend)) {
                        cmd = cmd.substring(3);
                    }
                    if (isAppend) {
                        cmd = PT.rep(cmd, "load SYNC", "load append");
                    }
                    if (cmd == null) break block22;
                    this.vwr.evalString(cmd + (noAutoPlay ? "#!NOAUTOPLAY" : ""));
                }
                return;
            }
            if (cmd == null && !noScript && this.vwr.scriptEditorVisible) {
                this.vwr.showEditor(new String[]{fileName, this.vwr.getFileAsString3(fileName, true, null)});
            } else {
                cmd = (cmd == null ? "script " : cmd) + PT.esc(fileName);
            }
            if (cmd == null) break block23;
            this.vwr.evalString(cmd + (noAutoPlay ? "#!NOAUTOPLAY" : ""));
        }
    }

    private String getDragDropFileTypeName(String fileName) {
        int pt = fileName.indexOf("::");
        if (pt >= 0) {
            return fileName.substring(0, pt);
        }
        if (fileName.startsWith("=")) {
            return "pdb";
        }
        if (fileName.endsWith(".dssr")) {
            return "dssr";
        }
        Object br = this.vwr.fm.getUnzippedReaderOrStreamFromName(fileName, null, true, false, true, true, null);
        if (br instanceof ZInputStream) {
            String zipDirectory = this.getZipDirectoryAsString(fileName);
            if (zipDirectory.indexOf("JmolManifest") >= 0) {
                return "Jmol";
            }
            return this.vwr.getModelAdapter().getFileTypeName(Rdr.getBR(zipDirectory));
        }
        if (br instanceof BufferedReader || br instanceof BufferedInputStream) {
            return this.vwr.getModelAdapter().getFileTypeName(br);
        }
        if (AU.isAS(br)) {
            return ((String[])br)[0];
        }
        return null;
    }

    private String getZipDirectoryAsString(String fileName) {
        Object t = this.vwr.fm.getBufferedInputStreamOrErrorMessageFromName(fileName, fileName, false, false, null, false, true);
        return this.vwr.getJzt().getZipDirectoryAsStringAndClose((BufferedInputStream)t);
    }

    public static void setStateScriptVersion(Viewer vwr, String version) {
        if (version != null) {
            prevCovalentVersion = Elements.bondingVersion;
            String[] tokens = PT.getTokens(version.replace('.', ' ').replace('_', ' '));
            try {
                int main = PT.parseInt(tokens[0]);
                int sub = PT.parseInt(tokens[1]);
                int minor = PT.parseInt(tokens[2]);
                if (minor == Integer.MIN_VALUE) {
                    minor = 0;
                }
                if (main != Integer.MIN_VALUE && sub != Integer.MIN_VALUE) {
                    vwr.stateScriptVersionInt = main * 10000 + sub * 100 + minor;
                    int ver = vwr.stateScriptVersionInt;
                    vwr.setBooleanProperty("legacyautobonding", ver < 110924);
                    vwr.g.legacyHAddition = ver < 130117;
                    vwr.setBooleanProperty("legacyjavafloat", ver < 140206 || ver >= 140300 && ver < 140306);
                    vwr.setIntProperty("bondingVersion", ver < 140111 ? 0 : 1);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        vwr.setIntProperty("bondingVersion", prevCovalentVersion);
        vwr.setBooleanProperty("legacyautobonding", false);
        vwr.g.legacyHAddition = false;
        vwr.stateScriptVersionInt = Integer.MAX_VALUE;
    }

    @Override
    public BS addHydrogensInline(BS bsAtoms, Lst<Atom> vConnections, P3[] pts) throws Exception {
        short modelIndex = this.vwr.ms.at[bsAtoms.nextSetBit((int)0)].mi;
        if (modelIndex != this.vwr.ms.mc - 1) {
            return new BS();
        }
        BS bsA = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
        this.vwr.g.appendNew = false;
        int atomIndex = this.vwr.ms.ac;
        int atomno = this.vwr.ms.getAtomCountInModel(modelIndex);
        SB sbConnect = new SB();
        for (int i = 0; i < vConnections.size(); ++i) {
            Atom a = (Atom)vConnections.get(i);
            sbConnect.append(";  connect 0 100 ").append("({" + atomIndex++ + "}) ").append("({" + a.i + "}) group;");
        }
        SB sb = new SB();
        sb.appendI(pts.length).append("\n").append("Viewer.AddHydrogens").append("#noautobond").append("\n");
        for (int i = 0; i < pts.length; ++i) {
            sb.append("H ").appendF(pts[i].x).append(" ").appendF(pts[i].y).append(" ").appendF(pts[i].z).append(" - - - - ").appendI(++atomno).appendC('\n');
        }
        this.vwr.openStringInlineParamsAppend(sb.toString(), null, true);
        this.eval.runScriptBuffer(sbConnect.toString(), null, false);
        BS bsB = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
        bsB.andNot(bsA);
        return bsB;
    }
}

