/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.io.JSONWriter;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public class QCSchemaWriter
extends JSONWriter {
    private static final String version = "QCJSON 0-0-0.Jmol_" + Viewer.getJmolVersion().replace(' ', '_');
    private static final String knownUnits = "cm cm^-1 cm-1 angstroms au atomic units";
    private Map<String, Object> moBases = new Hashtable<String, Object>();
    private boolean filterMOs;
    private Viewer vwr;
    private int basisID = 0;
    private Lst<int[]> shells;
    private int[][] dfCoefMaps;

    public String getUnitsConversion(String units) {
        String convFactor = "\"?\"";
        units = units.toLowerCase();
        switch (knownUnits.indexOf(units)) {
            case 3: 
            case 9: {
                units = "cm-1";
                break;
            }
            case 14: {
                units = "angstroms";
                convFactor = "1.8897";
                break;
            }
            case 24: 
            case 27: {
                units = "au";
                convFactor = "1";
            }
        }
        return "[\"" + units + "\"," + convFactor + "]";
    }

    public void set(Viewer viewer, OutputStream os) {
        this.vwr = viewer;
        this.setStream(os);
    }

    public String toString() {
        return this.oc == null ? "{}" : this.oc.toString();
    }

    public void writeJSON() {
        this.openSchema();
        this.writeMagic();
        this.oc.append(",\n");
        this.writeSchemaMetadata();
        this.writeJobs();
        this.closeSchema();
    }

    public void writeSchemaMetadata() {
        this.mapOpen();
        this.mapAddKeyValue("__jmol_created", new Date(), ",\n");
        this.mapAddKeyValue("__jmol_source", this.vwr.getP("_modelFile"), "");
        this.mapClose();
    }

    public void openSchema() {
        this.arrayOpen(false);
    }

    public void writeMagic() {
        this.writeString(version);
    }

    public void closeSchema() {
        this.oc.append("\n");
        this.arrayClose(false);
        this.closeStream();
    }

    public void writeJobs() {
        this.writeJob(1);
    }

    public void writeJob(int iJob) {
        this.append(",\n");
        this.mapOpen();
        this.mapAddKeyValue("__jmol_block", "Job " + iJob, ",\n");
        this.writeJobMetadata();
        this.writeModels();
        this.writeMOBases();
        this.mapClose();
    }

    public void writeJobMetadata() {
        this.mapAddKey("metadata");
        this.mapOpen();
        this.mapAddMapAllExcept("__jmol_info", this.vwr.getModelSetAuxiliaryInfo(), ";group3Counts;properties;group3Lists;models;");
        this.mapClose();
    }

    public void writeModels() {
        int nModels = this.vwr.ms.mc;
        this.oc.append(",\n");
        this.mapAddKey("steps");
        this.arrayOpen(true);
        this.oc.append("\n");
        int i = 0;
        while (i < nModels) {
            if (i > 0) {
                this.append(",\n");
            }
            i = this.writeModel(i);
        }
        this.arrayClose(true);
    }

    public int writeModel(int modelIndex) {
        int nextModel = modelIndex + 1;
        this.append("");
        this.mapOpen();
        this.mapAddKeyValue("__jmol_block", "Model " + (modelIndex + 1), ",\n");
        this.writeTopology(modelIndex);
        if (this.isVibration(modelIndex)) {
            this.oc.append(",\n");
            nextModel = this.writeVibrations(modelIndex);
        }
        if (this.haveMOData(modelIndex)) {
            this.oc.append(",\n");
            this.writeMOData(modelIndex);
        }
        this.oc.append(",\n");
        this.writeModelMetadata(modelIndex);
        this.mapClose();
        this.oc.append("\n");
        return nextModel;
    }

    public void writeTopology(int modelIndex) {
        this.mapAddKey("topology");
        this.mapOpen();
        this.writeAtoms(modelIndex);
        this.writeBonds(modelIndex);
        this.mapClose();
    }

    public Object getProperty(int modelIndex, String key) {
        Map props = (Map)(modelIndex >= this.vwr.ms.am.length ? null : this.vwr.ms.am[modelIndex].auxiliaryInfo.get("modelProperties"));
        return props == null ? null : props.get(key);
    }

    private boolean isVibration(int modelIndex) {
        return this.getProperty(modelIndex, "Frequency") != null;
    }

    public void writeModelMetadata(int modelIndex) {
        this.mapAddKey("metadata");
        this.mapOpen();
        this.mapAddMapAllExcept("__jmol_info", this.vwr.ms.am[modelIndex].auxiliaryInfo, ";.PATH;PATH;fileName;moData;");
        this.mapClose();
    }

    public void writeAtoms(int modelIndex) {
        SparseArray symbols = new SparseArray("_RLE_");
        SparseArray numbers = new SparseArray("_RLE_");
        SparseArray charges = new SparseArray("_RLE_");
        SparseArray names = new SparseArray("_RLE_");
        SparseArray types = new SparseArray("_RLE_");
        this.mapAddKey("atoms");
        this.mapOpen();
        this.writePrefix_Units("coords_", "Angstroms");
        this.mapAddKey("coords");
        this.arrayOpen(true);
        this.oc.append("\n");
        BS bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
        int last = bs.length() - 1;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.vwr.ms.at[i];
            this.append("");
            this.oc.append(this.formatNumber(a.x)).append(",\t").append(this.formatNumber(a.y)).append(",\t").append(this.formatNumber(a.z)).append(i < last ? ",\n" : "\n");
            symbols.add(PT.esc(a.getElementSymbol()));
            numbers.add("" + a.getElementNumber());
            charges.add("" + a.getPartialCharge());
            String name = a.getAtomName();
            names.add(name);
            String type = a.getAtomType();
            types.add(type.equals(name) ? null : type);
            i = bs.nextSetBit(i + 1);
        }
        this.arrayClose(true);
        this.oc.append(",\n");
        if (charges.isNumericAndNonZero()) {
            this.mapAddKeyValueRaw("charge", charges, ",\n");
        }
        if (types.hasValues()) {
            this.mapAddKeyValueRaw("types", types, ",\n");
        }
        this.mapAddKeyValueRaw("symbol", symbols, ",\n");
        this.mapAddKeyValueRaw("atom_number", numbers, "\n");
        this.mapClose();
    }

    private String formatNumber(float x) {
        return (x < 0.0f ? "" : " ") + DF.formatDecimal(x, -6);
    }

    private void writePrefix_Units(String prefix, String units) {
        this.mapAddKeyValueRaw(prefix + "units", this.getUnitsConversion(units), ",\n");
    }

    public void writeBonds(int modelIndex) {
    }

    public int writeVibrations(int modelIndex) {
        this.mapAddKey("vibrations");
        this.arrayOpen(true);
        this.oc.append("\n");
        String sep = null;
        int ivib = 0;
        while (this.isVibration(++modelIndex)) {
            String label;
            if (sep != null) {
                this.oc.append(sep);
            }
            sep = ",\n";
            this.append("");
            this.mapOpen();
            this.mapAddKeyValue("__jmol_block", "Vibration " + ++ivib, ",\n");
            Object value = this.getProperty(modelIndex, "FreqValue");
            String freq = (String)this.getProperty(modelIndex, "Frequency");
            String intensity = (String)this.getProperty(modelIndex, "IRIntensity");
            if (value == null) {
                System.out.println("model " + modelIndex + " has no _M.properties.FreqValue");
                continue;
            }
            if (freq == null) {
                System.out.println("model " + modelIndex + " has no _M.properties.Frequency");
                continue;
            }
            String[] tokens = PT.split(freq, " ");
            if (tokens.length == 1) {
                System.out.println("model " + modelIndex + " has no frequency units");
                continue;
            }
            this.writeMapKeyValueUnits("frequency", value, tokens[1]);
            if (intensity != null) {
                tokens = PT.split(intensity, " ");
                this.writeMapKeyValueUnits("ir_intensity", tokens[0], tokens[1]);
            }
            if ((label = (String)this.getProperty(modelIndex, "FrequencyLabel")) != null) {
                this.mapAddKeyValue("label", label, ",\n");
            }
            this.mapAddKey("vectors");
            this.arrayOpen(true);
            this.oc.append("\n");
            BS bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
            int last = bs.length() - 1;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                Atom a = this.vwr.ms.at[i];
                Vibration v = a.getVibrationVector();
                this.append("");
                this.oc.append(this.formatNumber(v.x)).append(",\t").append(this.formatNumber(v.y)).append(",\t").append(this.formatNumber(v.z)).append(i < last ? ",\n" : "\n");
                i = bs.nextSetBit(i + 1);
            }
            this.arrayClose(true);
            this.append("");
            this.mapClose();
        }
        this.oc.append("\n");
        this.arrayClose(true);
        return modelIndex;
    }

    private void writeMapKeyValueUnits(String key, Object value, String units) {
        this.mapAddKeyValueRaw(key, "{\"value\":" + value + ",\"units\":" + this.getUnitsConversion(units) + "}", ",\n");
    }

    private boolean haveMOData(int modelIndex) {
        return this.getAuxiliaryData(modelIndex, "moData") != null;
    }

    private Object getAuxiliaryData(int modelIndex, String key) {
        return this.vwr.ms.am[modelIndex].auxiliaryInfo.get(key);
    }

    private void writeMOData(int modelIndex) {
        Map moData = (Map)this.getAuxiliaryData(modelIndex, "moData");
        Hashtable moDataJSON = new Hashtable();
        moDataJSON.put("orbitals", moData.get("mos"));
        String units = (String)moData.get("EnergyUnits");
        if (units == null) {
            units = "?";
        }
        moDataJSON.put("orbitals_energy_units", this.getUnitsConversion(units));
        moDataJSON.put("normalized", moData.get("isNormalized") == Boolean.TRUE);
        String type = (String)moData.get("calculationType");
        moDataJSON.put("calculation_type", type == null ? "?" : type);
        moDataJSON.put("basis_id", this.getBasisID(moData));
        this.filterMOs = true;
        this.mapAddKeyValue("molecular_orbitals", moDataJSON, "\n");
        this.filterMOs = false;
        this.append("");
    }

    @Override
    protected Object getAndCheckValue(Map<String, Object> map, String key) {
        if (this.filterMOs) {
            if (key.equals("dfCoefMaps")) {
                return null;
            }
            if (key.equals("symmetry")) {
                return ((String)map.get(key)).replace('_', ' ').trim();
            }
            if (key.equals("coefficients") && this.dfCoefMaps != null) {
                return this.fixCoefficients((double[])map.get(key));
            }
        }
        return map.get(key);
    }

    private Object fixCoefficients(double[] coeffs) {
        double[] c = new double[coeffs.length];
        int n = this.shells.size();
        for (int i = 0; i < n; ++i) {
            int[] shell = (int[])this.shells.get(i);
            int type = shell[1];
            int[] map = this.dfCoefMaps[type];
            int j = 0;
            int coefPtr = 0;
            while (j < map.length) {
                c[coefPtr + j] = coeffs[coefPtr + map[j]];
                ++j;
                ++coefPtr;
            }
        }
        return c;
    }

    private String getBasisID(Map<String, Object> moData) {
        String key;
        Object slaters;
        Object gaussians;
        String hash = "!";
        this.dfCoefMaps = (int[][])moData.get("dfCoefMaps");
        if (this.dfCoefMaps != null) {
            boolean haveMap = false;
            block0: for (int i = 0; !haveMap && i < this.dfCoefMaps.length; ++i) {
                int[] m = this.dfCoefMaps[i];
                for (int j = 0; j < m.length; ++j) {
                    if (m[j] == 0) continue;
                    haveMap = true;
                    continue block0;
                }
            }
            if (!haveMap) {
                this.dfCoefMaps = null;
            }
        }
        if ((gaussians = moData.get("gaussians")) != null) {
            hash = hash + gaussians.hashCode();
        }
        this.shells = (Lst)moData.get("shells");
        if (this.shells != null) {
            hash = hash + this.shells.hashCode();
        }
        if ((slaters = moData.get("slaters")) != null) {
            hash = hash + slaters.hashCode();
        }
        if ((key = (String)this.moBases.get(hash)) == null) {
            key = "MOBASIS_" + ++this.basisID;
            this.moBases.put(hash, key);
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            if (gaussians != null) {
                map.put("gaussians", gaussians);
            }
            if (this.shells != null) {
                map.put("shells", this.shells);
            }
            if (slaters != null) {
                map.put("slaters", slaters);
            }
            this.moBases.put(key, map);
        }
        return key;
    }

    public void writeMOBases() {
        if (this.moBases.isEmpty()) {
            return;
        }
        this.oc.append(",\n");
        this.mapAddKey("mo_bases");
        this.mapOpen();
        String sep = "";
        for (String key : this.moBases.keySet()) {
            if (key.startsWith("!")) continue;
            this.append(sep);
            this.mapAddKeyValue(key, this.moBases.get(key), "\n");
            sep = ",";
        }
        this.mapClose();
        this.moBases.clear();
    }

    @Override
    public void writeObject(Object o) {
        if (o instanceof SlaterData) {
            this.oc.append(o.toString());
        } else {
            super.writeObject(o);
        }
    }

    public class SparseArray
    extends SB {
        private int repeatCount = 0;
        private int elementCount = 0;
        private String lastElement = null;
        private String sep = "";
        private String type;
        private boolean isRLE;

        public SparseArray(String type) {
            this.type = type;
            this.isRLE = type.equals("_RLE_");
        }

        protected void add(String element) {
            if (element == null) {
                element = "null";
            }
            if (!this.isRLE) {
                this.append(this.sep);
                this.append(element);
                this.sep = ",";
                return;
            }
            if (this.repeatCount > 0 && !element.equals(this.lastElement)) {
                this.append(this.sep);
                this.appendI(this.repeatCount);
                this.sep = ",";
                this.append(this.sep);
                this.append(this.lastElement);
                this.repeatCount = 0;
            }
            this.lastElement = element;
            ++this.repeatCount;
            ++this.elementCount;
        }

        public String lastElement() {
            return this.lastElement;
        }

        public boolean isEmpty() {
            return this.elementCount == 0;
        }

        public boolean allNaN() {
            return this.allSame() && PT.parseFloat(this.lastElement) == Float.NaN;
        }

        public boolean allNull() {
            return this.allSame() && this.lastElement.equals("null");
        }

        public boolean allEmptyString() {
            return this.allSame() && this.lastElement.equals("");
        }

        public boolean allSame() {
            return !this.isEmpty() && this.elementCount == this.repeatCount;
        }

        public boolean allZero() {
            return this.allSame() && PT.parseFloat(this.lastElement) != Float.NaN;
        }

        public boolean hasValues() {
            return !this.allSame() || !this.allNull() && !this.allEmptyString();
        }

        public boolean isNumericAndNonZero() {
            return this.allSame() && !this.allNaN() && !this.allZero();
        }

        @Override
        public String toString() {
            String s = super.toString();
            return s.length() == 0 ? "[]" : "[\"" + this.type + "\"," + s + (this.repeatCount > 0 ? this.sep + this.repeatCount + "," + this.lastElement : "") + "]";
        }
    }
}

